/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;

public abstract class RandomUtils {
    private static final double[] C = new double[1000];
    private static final double[] L9;

    public static double calculateVariance(double aSumOfValues, double aSumOfSquaredValues, int aValuesCount) {
        return ((double)aValuesCount * aSumOfSquaredValues - aSumOfValues * aSumOfValues) / (double)(aValuesCount * (aValuesCount - 1));
    }

    public static double erf(double anArg) {
        double retVal = PrimitiveMath.ZERO;
        double tmpSqr = anArg * anArg;
        for (int n = 0; n <= 60; ++n) {
            double tmpVal = anArg / (double)(2 * n + 1);
            for (int i = 1; i <= n; ++i) {
                tmpVal *= -tmpSqr / (double)i;
            }
            retVal += tmpVal;
        }
        return PrimitiveMath.TWO * retVal / PrimitiveMath.SQRT_PI;
    }

    public static double erfc(double anArg) {
        return PrimitiveMath.ONE - RandomUtils.erf(anArg);
    }

    public static double erfi(double anArg) {
        double retVal = PrimitiveMath.ZERO;
        for (int k = 500; k >= 0; --k) {
            retVal += C[k] * Math.pow(PrimitiveMath.SQRT_PI * anArg / PrimitiveMath.TWO, 2 * k + 1) / (double)(2 * k + 1);
        }
        return retVal;
    }

    public static double factorial(int aVal) {
        double retVal = PrimitiveMath.ONE;
        for (int i = 2; i <= aVal; ++i) {
            retVal *= (double)i;
        }
        return retVal;
    }

    public static double gamma(double arg) {
        if (arg <= PrimitiveMath.ZERO && Math.abs(arg % PrimitiveMath.ONE) < PrimitiveMath.MACHINE_EPSILON) {
            return Double.NaN;
        }
        if (arg < PrimitiveMath.HALF) {
            return PrimitiveMath.PI / (Math.sin(PrimitiveMath.PI * arg) * RandomUtils.gamma(PrimitiveMath.ONE - arg));
        }
        double z = arg - PrimitiveMath.ONE;
        double x = L9[0];
        for (int i = 1; i < L9.length; ++i) {
            x += L9[i] / (z + (double)i);
        }
        double t = z + (7.0 + PrimitiveMath.HALF);
        return PrimitiveMath.SQRT_TWO_PI * Math.pow(t, z + PrimitiveMath.HALF) * Math.exp(-t) * x;
    }

    public static int partitions(int n, int[] k) {
        int retVal = (int)RandomUtils.factorial(n);
        for (int i = 0; i < k.length; ++i) {
            retVal = (int)((double)retVal / RandomUtils.factorial(k[i]));
        }
        return retVal;
    }

    public static int permutations(int n) {
        return (int)RandomUtils.factorial(n);
    }

    public static int subsets(int n, int k) {
        return (int)(RandomUtils.factorial(n) / (RandomUtils.factorial(k) * RandomUtils.factorial(n - k)));
    }

    public static int variations(int n, int k) {
        return (int)(RandomUtils.factorial(n) / RandomUtils.factorial(n - k));
    }

    private RandomUtils() {
    }

    static {
        RandomUtils.C[0] = PrimitiveMath.ONE;
        for (int k = 1; k < C.length; ++k) {
            RandomUtils.C[k] = PrimitiveMath.ZERO;
            for (int m = 0; m <= k - 1; ++m) {
                int n = k;
                C[n] = C[n] + C[m] * C[k - 1 - m] / (double)((m + 1) * (2 * m + 1));
            }
        }
        L9 = new double[]{0.9999999999998099, 676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};
    }
}

