/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import java.math.MathContext;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class Money
extends Number
implements Scalar<Money>,
NumberContext.Enforceable<Money> {
    public static final Scalar.Factory<Money> FACTORY = new Scalar.Factory<Money>(){

        @Override
        public Money cast(double value) {
            return Money.valueOf(value);
        }

        @Override
        public Money cast(Number number) {
            return Money.valueOf(number);
        }

        public Money convert(double value) {
            return Money.valueOf(value);
        }

        public Money convert(Number number) {
            return Money.valueOf(number);
        }

        public Money one() {
            return ONE;
        }

        public Money zero() {
            return ZERO;
        }
    };
    private static final double DOUBLE_DENOMINATOR = 1000000.0;
    private static final long LONG_DENOMINATOR = 1000000L;
    public static final Money NEG = new Money(-1000000L);
    public static final Money ONE = new Money(1000000L);
    public static final Money TWO = new Money(2000000L);
    public static final Money ZERO = new Money();
    static final NumberContext CONTEXT = BigScalar.CONTEXT.newPrecision(19).newScale(4);
    private transient BigDecimal myDecimal = null;
    private final long myNumerator;

    public static boolean isAbsolute(Money value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(Money value) {
        return false;
    }

    public static boolean isNaN(Money value) {
        return false;
    }

    public static boolean isSmall(double comparedTo, Money value) {
        return value.isSmall(comparedTo);
    }

    public static Money valueOf(double value) {
        return new Money(value * 1000000.0);
    }

    public static Money valueOf(Number number) {
        if (number != null) {
            if (number instanceof Money) {
                return (Money)number;
            }
            return new Money(number.doubleValue() * 1000000.0);
        }
        return ZERO;
    }

    private static String toString(Money scalar) {
        return Double.toString(scalar.doubleValue());
    }

    private Money() {
        this.myNumerator = 0L;
    }

    private Money(double numerator) {
        this.myNumerator = Math.round(numerator);
    }

    private Money(long numerator) {
        this.myNumerator = numerator;
    }

    @Override
    public Money add(double arg) {
        return new Money((double)this.myNumerator + arg * 1000000.0);
    }

    @Override
    public Money add(Money arg) {
        return new Money(this.myNumerator + arg.getNumerator());
    }

    @Override
    public int compareTo(Money reference) {
        return Long.compare(this.myNumerator, reference.getNumerator());
    }

    @Override
    public Money conjugate() {
        return this;
    }

    @Override
    public Money divide(double arg) {
        return new Money((double)this.myNumerator / arg);
    }

    @Override
    public Money divide(Money arg) {
        return new Money(this.myNumerator * 1000000L / arg.getNumerator());
    }

    @Override
    public double doubleValue() {
        return (double)this.myNumerator / 1000000.0;
    }

    @Override
    public Money enforce(NumberContext context) {
        if (context.getScale() < 4) {
            return Money.valueOf(context.enforce(this.doubleValue()));
        }
        return this;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public Money getNumber() {
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public Money invert() {
        return new Money(1000000000000L / this.myNumerator);
    }

    @Override
    public boolean isAbsolute() {
        return this.myNumerator >= 0L;
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return CONTEXT.isSmall(comparedTo, this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public Money multiply(double arg) {
        return new Money((double)this.myNumerator * arg);
    }

    @Override
    public Money multiply(Money arg) {
        return new Money(this.myNumerator * arg.getNumerator() / 1000000L);
    }

    @Override
    public Money negate() {
        return new Money(-this.myNumerator);
    }

    @Override
    public double norm() {
        return Math.abs(this.doubleValue());
    }

    @Override
    public Money signum() {
        if (this.myNumerator == 0L) {
            return ZERO;
        }
        if (this.myNumerator < 0L) {
            return NEG;
        }
        return ONE;
    }

    @Override
    public Money subtract(double arg) {
        return new Money((double)this.myNumerator - arg * 1000000.0);
    }

    @Override
    public Money subtract(Money arg) {
        return new Money(this.myNumerator - arg.getNumerator());
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.myDecimal == null) {
            this.myDecimal = this.toBigDecimal(CONTEXT.getMathContext());
        }
        return this.myDecimal;
    }

    public String toString() {
        return Money.toString(this);
    }

    @Override
    public String toString(NumberContext context) {
        return Money.toString(this.enforce(context));
    }

    private BigDecimal toBigDecimal(MathContext context) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(1000000L), context);
    }

    long getNumerator() {
        return this.myNumerator;
    }
}

