/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class Quaternion
extends Number
implements Scalar<Quaternion>,
NumberContext.Enforceable<Quaternion>,
Access2D<Double> {
    public static final Scalar.Factory<Quaternion> FACTORY = new Scalar.Factory<Quaternion>(){

        @Override
        public Quaternion cast(double value) {
            return Quaternion.valueOf(value);
        }

        @Override
        public Quaternion cast(Number number) {
            return Quaternion.valueOf(number);
        }

        public Quaternion convert(double value) {
            return Quaternion.valueOf(value);
        }

        public Quaternion convert(Number number) {
            return Quaternion.valueOf(number);
        }

        public Quaternion one() {
            return ONE;
        }

        public Quaternion zero() {
            return ZERO;
        }
    };
    public static final Quaternion I = new Quaternion(PrimitiveMath.ONE, PrimitiveMath.ZERO, PrimitiveMath.ZERO);
    public static final Quaternion IJK = new Quaternion(PrimitiveMath.ONE, PrimitiveMath.ONE, PrimitiveMath.ONE).versor();
    public static final Quaternion INFINITY = Quaternion.makePolar(Double.POSITIVE_INFINITY, IJK.vector(), PrimitiveMath.ZERO);
    public static final Quaternion J = new Quaternion(PrimitiveMath.ZERO, PrimitiveMath.ONE, PrimitiveMath.ZERO);
    public static final Quaternion K = new Quaternion(PrimitiveMath.ZERO, PrimitiveMath.ZERO, PrimitiveMath.ONE);
    public static final Quaternion NEG = new Quaternion(PrimitiveMath.NEG);
    public static final Quaternion ONE = new Quaternion(PrimitiveMath.ONE);
    public static final Quaternion ZERO = new Quaternion();
    private static final double ARGUMENT_TOLERANCE = PrimitiveMath.PI * PrimitiveScalar.CONTEXT.epsilon();
    public final double i;
    public final double j;
    public final double k;
    private final boolean myPureForSure;
    private final boolean myRealForSure;
    private final double myScalar;

    public static boolean isAbsolute(Quaternion value) {
        return value.isAbsolute();
    }

    public static boolean isInfinite(Quaternion value) {
        return Double.isInfinite(value.doubleValue()) || Double.isInfinite(value.i) || Double.isInfinite(value.j) || Double.isInfinite(value.k) || Double.isInfinite(value.norm());
    }

    public static boolean isNaN(Quaternion value) {
        return Double.isNaN(value.doubleValue()) || Double.isNaN(value.i) || Double.isNaN(value.j) || Double.isNaN(value.k);
    }

    public static boolean isReal(Quaternion value) {
        return value.isReal();
    }

    public static boolean isSmall(double comparedTo, Quaternion value) {
        return value.isSmall(comparedTo);
    }

    public static Quaternion makePolar(double norm, double[] unit, double angle) {
        double tmpSin;
        double tmpCos;
        double tmpAngle = angle % PrimitiveMath.TWO_PI;
        if (tmpAngle < PrimitiveMath.ZERO) {
            tmpAngle += PrimitiveMath.TWO_PI;
        }
        if (tmpAngle <= ARGUMENT_TOLERANCE) {
            return new Quaternion(norm);
        }
        if (Math.abs(tmpAngle - PrimitiveMath.PI) <= ARGUMENT_TOLERANCE) {
            return new Quaternion(-norm);
        }
        double tmpScalar = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpCos = Math.cos(tmpAngle)) != PrimitiveMath.ZERO) {
            tmpScalar = norm * tmpCos;
        }
        double tmpI = PrimitiveMath.ZERO;
        double tmpJ = PrimitiveMath.ZERO;
        double tmpK = PrimitiveMath.ZERO;
        if (norm != PrimitiveMath.ZERO && (tmpSin = Math.sin(tmpAngle)) != PrimitiveMath.ZERO) {
            tmpI = unit[0] * norm * tmpSin;
            tmpJ = unit[1] * norm * tmpSin;
            tmpK = unit[2] * norm * tmpSin;
        }
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public static Quaternion of(double scalar, double i, double j, double k) {
        return new Quaternion(scalar, i, j, k);
    }

    public static Quaternion valueOf(double value) {
        return new Quaternion(value);
    }

    public static Quaternion valueOf(Number number) {
        if (number != null) {
            if (number instanceof Quaternion) {
                return (Quaternion)number;
            }
            if (number instanceof ComplexNumber) {
                ComplexNumber tmpComplex = (ComplexNumber)number;
                return new Quaternion(tmpComplex.doubleValue(), tmpComplex.i, PrimitiveMath.ZERO, PrimitiveMath.ZERO);
            }
            return new Quaternion(number.doubleValue());
        }
        return ZERO;
    }

    private Quaternion(double scalar) {
        this.myScalar = scalar;
        this.myRealForSure = true;
        this.myPureForSure = false;
        this.i = PrimitiveMath.ZERO;
        this.j = PrimitiveMath.ZERO;
        this.k = PrimitiveMath.ZERO;
    }

    private Quaternion(double i, double j, double k) {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = false;
        this.myPureForSure = true;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    private Quaternion(double scalar, double i, double j, double k) {
        this.myScalar = scalar;
        this.myRealForSure = false;
        this.myPureForSure = false;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    private Quaternion(double scalar, double[] vector) {
        this.myScalar = scalar;
        this.myRealForSure = false;
        this.myPureForSure = false;
        this.i = vector[0];
        this.j = vector[1];
        this.k = vector[2];
    }

    private Quaternion(double[] vector) {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = false;
        this.myPureForSure = true;
        this.i = vector[0];
        this.j = vector[1];
        this.k = vector[2];
    }

    Quaternion() {
        this.myScalar = PrimitiveMath.ZERO;
        this.myRealForSure = true;
        this.myPureForSure = true;
        this.i = PrimitiveMath.ZERO;
        this.j = PrimitiveMath.ZERO;
        this.k = PrimitiveMath.ZERO;
    }

    @Override
    public Quaternion add(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar + arg);
        }
        return new Quaternion(this.myScalar + arg, this.i, this.j, this.k);
    }

    @Override
    public Quaternion add(Quaternion arg) {
        if (this.isReal()) {
            return arg.add(this.myScalar);
        }
        double tmpScalar = this.myScalar + arg.scalar();
        double tmpI = this.i + arg.i;
        double tmpJ = this.j + arg.j;
        double tmpK = this.k + arg.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public double angle() {
        return Math.acos(this.myScalar / this.norm());
    }

    public MatrixStore<ComplexNumber> asComplex2D() {
        ComplexDenseStore retVal = (ComplexDenseStore)ComplexDenseStore.FACTORY.makeZero(2L, 2L);
        retVal.set(0L, (Number)ComplexNumber.of(this.myScalar, this.i));
        retVal.set(1L, (Number)ComplexNumber.of(-this.j, this.k));
        retVal.set(2L, (Number)ComplexNumber.of(this.j, this.k));
        retVal.set(3L, (Number)ComplexNumber.of(this.myScalar, -this.i));
        return retVal;
    }

    @Override
    public int compareTo(Quaternion reference) {
        int retVal = 0;
        retVal = Double.compare(this.norm(), reference.norm());
        if (retVal == 0 && (retVal = Double.compare(this.myScalar, reference.scalar())) == 0 && (retVal = Double.compare(this.i, reference.i)) == 0 && (retVal = Double.compare(this.j, reference.j)) == 0) {
            retVal = Double.compare(this.k, reference.k);
        }
        return retVal;
    }

    @Override
    public Quaternion conjugate() {
        double tmpScalar = this.myScalar;
        double tmpI = -this.i;
        double tmpJ = -this.j;
        double tmpK = -this.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public long count() {
        return 16L;
    }

    @Override
    public long countColumns() {
        return 4L;
    }

    @Override
    public long countRows() {
        return 4L;
    }

    @Override
    public Quaternion divide(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar / arg);
        }
        if (this.isPure()) {
            double tmpI = this.i / arg;
            double tmpJ = this.j / arg;
            double tmpK = this.k / arg;
            return new Quaternion(tmpI, tmpJ, tmpK);
        }
        double tmpScalar = this.myScalar / arg;
        double tmpI = this.i / arg;
        double tmpJ = this.j / arg;
        double tmpK = this.k / arg;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion divide(Quaternion arg) {
        Quaternion tmpReciprocal = arg.invert();
        return this.multiply(tmpReciprocal);
    }

    @Override
    public double doubleValue() {
        return this.myScalar;
    }

    @Override
    public double doubleValue(long index) {
        switch ((int)index) {
            case 0: {
                return this.myScalar;
            }
            case 1: {
                return -this.i;
            }
            case 2: {
                return -this.j;
            }
            case 3: {
                return -this.k;
            }
            case 4: {
                return this.i;
            }
            case 5: {
                return this.myScalar;
            }
            case 6: {
                return this.k;
            }
            case 7: {
                return -this.j;
            }
            case 8: {
                return this.j;
            }
            case 9: {
                return -this.k;
            }
            case 10: {
                return this.myScalar;
            }
            case 11: {
                return this.i;
            }
            case 12: {
                return this.k;
            }
            case 13: {
                return this.j;
            }
            case 14: {
                return -this.i;
            }
            case 15: {
                return this.myScalar;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public double doubleValue(long row, long column) {
        if (row == column) {
            return this.myScalar;
        }
        return this.doubleValue(row + column * 4L);
    }

    @Override
    public Quaternion enforce(NumberContext context) {
        double tmpScalar = context.enforce(this.myScalar);
        double tmpI = context.enforce(this.i);
        double tmpJ = context.enforce(this.j);
        double tmpK = context.enforce(this.k);
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Quaternion)) {
            return false;
        }
        Quaternion other = (Quaternion)obj;
        if (Double.doubleToLongBits(this.myScalar) != Double.doubleToLongBits(other.myScalar)) {
            return false;
        }
        if (Double.doubleToLongBits(this.i) != Double.doubleToLongBits(other.i)) {
            return false;
        }
        if (Double.doubleToLongBits(this.j) != Double.doubleToLongBits(other.j)) {
            return false;
        }
        return Double.doubleToLongBits(this.k) == Double.doubleToLongBits(other.k);
    }

    @Override
    public float floatValue() {
        return (float)this.myScalar;
    }

    @Override
    public Double get(long index) {
        return this.doubleValue(index);
    }

    @Override
    public Double get(long row, long column) {
        return this.doubleValue(row, column);
    }

    public double getDeterminant() {
        double tmpSumOfSquares = this.calculateSumOfSquaresAll();
        return tmpSumOfSquares * tmpSumOfSquares;
    }

    @Override
    public Quaternion getNumber() {
        return this;
    }

    public Quaternion getPureVersor() {
        double tmpLength = this.getVectorLength();
        if (tmpLength > 0.0) {
            return new Quaternion(this.i / tmpLength, this.j / tmpLength, this.k / tmpLength);
        }
        return IJK;
    }

    public double getVectorLength() {
        return Math.sqrt(this.calculateSumOfSquaresVector());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.myScalar);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.i);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.j);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.k);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.myScalar;
    }

    @Override
    public Quaternion invert() {
        Quaternion tmpConjugate = this.conjugate();
        double tmpSumOfSquares = this.calculateSumOfSquaresAll();
        return tmpConjugate.divide(tmpSumOfSquares);
    }

    @Override
    public boolean isAbsolute() {
        if (this.myRealForSure) {
            return this.myScalar >= PrimitiveMath.ZERO;
        }
        return !PrimitiveScalar.CONTEXT.isDifferent(this.myScalar, this.norm());
    }

    public boolean isPure() {
        return this.myPureForSure || PrimitiveScalar.CONTEXT.isSmall(this.norm(), this.myScalar);
    }

    public boolean isReal() {
        NumberContext tmpCntxt = PrimitiveScalar.CONTEXT;
        return this.myRealForSure || tmpCntxt.isSmall(this.myScalar, this.i) && tmpCntxt.isSmall(this.myScalar, this.j) && tmpCntxt.isSmall(this.myScalar, this.k);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.CONTEXT.isSmall(comparedTo, this.norm());
    }

    @Override
    public long longValue() {
        return (long)this.myScalar;
    }

    @Override
    public Quaternion multiply(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar * arg);
        }
        if (this.isPure()) {
            double tmpI = this.i * arg;
            double tmpJ = this.j * arg;
            double tmpK = this.k * arg;
            return new Quaternion(tmpI, tmpJ, tmpK);
        }
        double tmpScalar = this.myScalar * arg;
        double tmpI = this.i * arg;
        double tmpJ = this.j * arg;
        double tmpK = this.k * arg;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion multiply(Quaternion arg) {
        if (this.isReal()) {
            return arg.multiply(this.myScalar);
        }
        double tmpScalar = this.myScalar * arg.scalar() - this.i * arg.i - this.j * arg.j - this.k * arg.k;
        double tmpI = this.myScalar * arg.i + this.i * arg.scalar() + this.j * arg.k - this.k * arg.j;
        double tmpJ = this.myScalar * arg.j - this.i * arg.k + this.j * arg.scalar() + this.k * arg.i;
        double tmpK = this.myScalar * arg.k + this.i * arg.j - this.j * arg.i + this.k * arg.scalar();
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public Quaternion negate() {
        double tmpScalar = -this.myScalar;
        double tmpI = -this.i;
        double tmpJ = -this.j;
        double tmpK = -this.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public double norm() {
        return Math.sqrt(this.calculateSumOfSquaresAll());
    }

    public double scalar() {
        return this.myScalar;
    }

    @Override
    public Quaternion signum() {
        return this.versor();
    }

    @Override
    public Quaternion subtract(double arg) {
        if (this.isReal()) {
            return new Quaternion(this.myScalar - arg);
        }
        return new Quaternion(this.myScalar - arg, this.i, this.j, this.k);
    }

    @Override
    public Quaternion subtract(Quaternion arg) {
        double tmpScalar = this.myScalar - arg.scalar();
        double tmpI = this.i - arg.i;
        double tmpJ = this.j - arg.j;
        double tmpK = this.k - arg.k;
        return new Quaternion(tmpScalar, tmpI, tmpJ, tmpK);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.myScalar, PrimitiveScalar.CONTEXT.getMathContext());
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("(");
        retVal.append(Double.toString(this.myScalar));
        if (this.i < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(Math.abs(this.i)));
        retVal.append("i");
        if (this.j < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(Math.abs(this.j)));
        retVal.append("j");
        if (this.k < PrimitiveMath.ZERO) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(Double.toString(Math.abs(this.k)));
        retVal.append("k)");
        return retVal.toString();
    }

    @Override
    public String toString(NumberContext context) {
        StringBuilder retVal = new StringBuilder("(");
        BigDecimal tmpScalar = context.enforce(new BigDecimal(this.myScalar, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpI = context.enforce(new BigDecimal(this.i, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpJ = context.enforce(new BigDecimal(this.j, PrimitiveScalar.CONTEXT.getMathContext()));
        BigDecimal tmpK = context.enforce(new BigDecimal(this.k, PrimitiveScalar.CONTEXT.getMathContext()));
        retVal.append(tmpScalar.toString());
        if (tmpI.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpI.abs().toString());
        retVal.append("i");
        if (tmpJ.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpJ.abs().toString());
        retVal.append("j");
        if (tmpK.signum() < 0) {
            retVal.append(" - ");
        } else {
            retVal.append(" + ");
        }
        retVal.append(tmpK.abs().toString());
        retVal.append("k)");
        return retVal.toString();
    }

    public double[] unit() {
        double tmpLength = this.getVectorLength();
        if (tmpLength > 0.0) {
            return new double[]{this.i / tmpLength, this.j / tmpLength, this.k / tmpLength};
        }
        return IJK.vector();
    }

    public double[] vector() {
        return new double[]{this.i, this.j, this.k};
    }

    public Quaternion versor() {
        return this.divide(this.norm());
    }

    private double calculateSumOfSquaresAll() {
        return this.myScalar * this.myScalar + this.calculateSumOfSquaresVector();
    }

    private double calculateSumOfSquaresVector() {
        return this.i * this.i + this.j * this.j + this.k * this.k;
    }
}

