/*
 * Decompiled with CFR 0.152.
 */
package xlinear;

import java.util.stream.DoubleStream;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import xlinear.CholeskyDecomposition;
import xlinear.DenseMatrix;
import xlinear.SparseMatrix;
import xlinear.StaticUtils;

public interface Matrix {
    public Matrix slice(int var1, int var2, int var3, int var4, boolean var5);

    default public Matrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Excl) {
        return this.slice(row0Incl, row1Excl, col0Incl, col1Excl, false);
    }

    default public Matrix row(int index) {
        int _nCols = this.nCols();
        return this.slice(index, index + 1, 0, _nCols, false);
    }

    default public Matrix col(int index) {
        int _nRows = this.nRows();
        return this.slice(0, _nRows, index, index + 1, false);
    }

    default public Matrix readOnlyView() {
        int _nRows = this.nRows();
        int _nCols = this.nCols();
        return this.slice(0, _nRows, 0, _nCols, true);
    }

    public int nRows();

    public int nCols();

    default public int nEntries() {
        int _nRows = this.nRows();
        int _nCols = this.nCols();
        return _nRows * _nCols;
    }

    public double get(int var1, int var2);

    public void set(int var1, int var2, double var3);

    public DoubleStream nonZeroEntries();

    default public double get(int index) {
        boolean _equals;
        boolean _not;
        boolean _isVector = this.isVector();
        boolean bl = _not = !_isVector;
        if (_not) {
            throw StaticUtils.notAVectorException;
        }
        int _nRows = this.nRows();
        boolean bl2 = _equals = _nRows == 1;
        if (_equals) {
            return this.get(0, index);
        }
        return this.get(index, 0);
    }

    default public void set(int index, double value) {
        boolean _equals;
        boolean _not;
        boolean _isVector = this.isVector();
        boolean bl = _not = !_isVector;
        if (_not) {
            throw StaticUtils.notAVectorException;
        }
        int _nRows = this.nRows();
        boolean bl2 = _equals = _nRows == 1;
        if (_equals) {
            this.set(0, index, value);
        } else {
            this.set(index, 0, value);
        }
    }

    default public boolean isVector() {
        int _nCols;
        boolean _equals_1;
        boolean _equals;
        boolean _or = false;
        int _nRows = this.nRows();
        boolean bl = _equals = _nRows == 1;
        _or = _equals ? true : (_equals_1 = (_nCols = this.nCols()) == 1);
        return _or;
    }

    public Matrix createEmpty(int var1, int var2);

    public CholeskyDecomposition cholesky();

    public Matrix transpose();

    public Matrix inverse();

    public Matrix operator_multiply(Number var1);

    public Matrix mul(Number var1);

    default public Matrix operator_divide(Number n) {
        return this.div(n);
    }

    default public Matrix div(Number n) {
        double _divide = DoubleExtensions.operator_divide((Double)1.0, (Number)n);
        return this.mul(_divide);
    }

    default public void operator_multiplyAssign(Number n) {
        this.mulInPlace(n);
    }

    public void mulInPlace(Number var1);

    default public void operator_divideAssign(Number n) {
        this.divInPlace(n);
    }

    default public void divInPlace(Number n) {
        double _divide = DoubleExtensions.operator_divide((Double)1.0, (Number)n);
        this.mulInPlace(_divide);
    }

    public Matrix operator_multiply(Matrix var1);

    public DenseMatrix operator_multiply(DenseMatrix var1);

    public Matrix operator_multiply(SparseMatrix var1);

    default public Matrix mul(Matrix m) {
        boolean _matched = false;
        if (!_matched && m instanceof SparseMatrix) {
            _matched = true;
            return this.mul((SparseMatrix)m);
        }
        if (!_matched && m instanceof DenseMatrix) {
            _matched = true;
            return this.mul((DenseMatrix)m);
        }
        throw StaticUtils.denseOrSparseException;
    }

    public DenseMatrix mul(DenseMatrix var1);

    public Matrix mul(SparseMatrix var1);

    public Matrix operator_plus(Matrix var1);

    public DenseMatrix operator_plus(DenseMatrix var1);

    public Matrix operator_plus(SparseMatrix var1);

    default public Matrix add(Matrix m) {
        boolean _matched = false;
        if (!_matched && m instanceof SparseMatrix) {
            _matched = true;
            return this.add((SparseMatrix)m);
        }
        if (!_matched && m instanceof DenseMatrix) {
            _matched = true;
            return this.add((DenseMatrix)m);
        }
        throw StaticUtils.denseOrSparseException;
    }

    public DenseMatrix add(DenseMatrix var1);

    public Matrix add(SparseMatrix var1);

    default public void operator_add(Matrix m) {
        this.addInPlace(m);
    }

    default public void operator_add(DenseMatrix m) {
        this.addInPlace(m);
    }

    default public void operator_add(SparseMatrix m) {
        this.addInPlace(m);
    }

    default public void addInPlace(Matrix m) {
        boolean _matched = false;
        if (!_matched && m instanceof DenseMatrix) {
            _matched = true;
            this.addInPlace((DenseMatrix)m);
        }
        if (!_matched && m instanceof SparseMatrix) {
            _matched = true;
            this.addInPlace((SparseMatrix)m);
        }
        if (!_matched) {
            throw StaticUtils.denseOrSparseException;
        }
    }

    public void addInPlace(DenseMatrix var1);

    public void addInPlace(SparseMatrix var1);

    public Matrix operator_minus(Matrix var1);

    public DenseMatrix operator_minus(DenseMatrix var1);

    public Matrix operator_minus(SparseMatrix var1);

    default public Matrix sub(Matrix m) {
        boolean _matched = false;
        if (!_matched && m instanceof SparseMatrix) {
            _matched = true;
            return this.sub((SparseMatrix)m);
        }
        if (!_matched && m instanceof DenseMatrix) {
            _matched = true;
            return this.sub((DenseMatrix)m);
        }
        throw StaticUtils.denseOrSparseException;
    }

    public DenseMatrix sub(DenseMatrix var1);

    public Matrix sub(SparseMatrix var1);

    default public void operator_remove(Matrix m) {
        this.subInPlace(m);
    }

    default public void operator_remove(DenseMatrix m) {
        this.subInPlace(m);
    }

    default public void operator_remove(SparseMatrix m) {
        this.subInPlace(m);
    }

    default public void subInPlace(Matrix m) {
        boolean _matched = false;
        if (!_matched && m instanceof DenseMatrix) {
            _matched = true;
            this.subInPlace((DenseMatrix)m);
        }
        if (!_matched && m instanceof SparseMatrix) {
            _matched = true;
            this.subInPlace((SparseMatrix)m);
        }
        if (!_matched) {
            throw StaticUtils.denseOrSparseException;
        }
    }

    public void subInPlace(DenseMatrix var1);

    public void subInPlace(SparseMatrix var1);
}

