/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Stack;
import spoon.compiler.Environment;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.visitor.CtScanner;

public class ModelConsistencyChecker
extends CtScanner {
    boolean fixInconsistencies = false;
    boolean fixNullParents = false;
    Environment environment;
    Stack<CtElement> stack = new Stack();

    public ModelConsistencyChecker(Environment environment, boolean fixInconsistencies, boolean fixNullParents) {
        this.environment = environment;
        this.fixInconsistencies = fixInconsistencies;
        this.fixNullParents = fixNullParents;
    }

    @Override
    public void enter(CtElement element) {
        if (!(this.stack.isEmpty() || element.isParentInitialized() && element.getParent() == this.stack.peek())) {
            if (!element.isParentInitialized() && this.fixNullParents || element.getParent() != this.stack.peek() && this.fixInconsistencies) {
                element.setParent(this.stack.peek());
            } else {
                this.environment.report(null, Severity.WARNING, (element.isParentInitialized() ? "inconsistent" : "null") + " parent for " + element.getClass() + (element instanceof CtNamedElement ? " - " + ((CtNamedElement)element).getSimpleName() : "") + " - " + element.getPosition() + " - " + this.stack.peek().getPosition());
                this.dumpStack();
            }
        }
        this.stack.push(element);
    }

    @Override
    protected void exit(CtElement e) {
        this.stack.pop();
    }

    private void dumpStack() {
        System.out.println("model consistency checker stack:");
        for (CtElement e : this.stack) {
            System.out.println("    " + e.getClass().getSimpleName() + " " + (e.getPosition() == null ? "(?)" : "" + e.getPosition()));
        }
    }
}

