/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.amd.tdouble;

import edu.ufl.cise.amd.tdouble.Damd_internal;

public class Damd_info
extends Damd_internal {
    private static void PRI(String format, double x) {
        if (x >= 0.0) {
            Damd_info.PRINTF(format, x);
        }
    }

    public static void amd_info(double[] Info) {
        Damd_info.PRINTF("\nAMD version %d.%d.%d, %s, results:\n", 2, 2, 2, "Jan 25, 2011");
        if (Info == null || Info.length == 0) {
            return;
        }
        double n = Info[1];
        double ndiv = Info[10];
        double nmultsubs_ldl = Info[11];
        double nmultsubs_lu = Info[12];
        double lnz = Info[9];
        double lnzd = n >= 0.0 && lnz >= 0.0 ? n + lnz : -1.0;
        Damd_info.PRINTF("    status: ", new Object[0]);
        if (Info[0] == 0.0) {
            Damd_info.PRINTF("OK\n", new Object[0]);
        } else if (Info[0] == -1.0) {
            Damd_info.PRINTF("out of memory\n", new Object[0]);
        } else if (Info[0] == -2.0) {
            Damd_info.PRINTF("invalid matrix\n", new Object[0]);
        } else if (Info[0] == 1.0) {
            Damd_info.PRINTF("OK, but jumbled\n", new Object[0]);
        } else {
            Damd_info.PRINTF("unknown\n", new Object[0]);
        }
        Damd_info.PRI("    n, dimension of A:                                  %6.0f\n", n);
        Damd_info.PRI("    nz, number of nonzeros in A:                        %6.0f\n", Info[2]);
        Damd_info.PRI("    symmetry of A:                                      %.4f\n", Info[3]);
        Damd_info.PRI("    number of nonzeros on diagonal:                     %6.0f\n", Info[4]);
        Damd_info.PRI("    nonzeros in pattern of A+A' (excl. diagonal):       %6.0f\n", Info[5]);
        Damd_info.PRI("    # dense rows/columns of A+A':                       %6.0f\n", Info[6]);
        Damd_info.PRI("    memory used, in bytes:                              %6.0f\n", Info[7]);
        Damd_info.PRI("    # of memory compactions:                            %6.0f\n", Info[8]);
        Damd_info.PRINTF("\n    The following approximate statistics are for a subsequent\n    factorization of A(P,P) + A(P,P)'.  They are slight upper\n    bounds if there are no dense rows/columns in A+A', and become\n    looser if dense rows/columns exist.\n\n", new Object[0]);
        Damd_info.PRI("    nonzeros in L (excluding diagonal):                 %6.0f\n", lnz);
        Damd_info.PRI("    nonzeros in L (including diagonal):                 %6.0f\n", lnzd);
        Damd_info.PRI("    # divide operations for LDL' or LU:                 %6.0f\n", ndiv);
        Damd_info.PRI("    # multiply-subtract operations for LDL':            %6.0f\n", nmultsubs_ldl);
        Damd_info.PRI("    # multiply-subtract operations for LU:              %6.0f\n", nmultsubs_lu);
        Damd_info.PRI("    max nz. in any column of L (incl. diagonal):        %6.0f\n", Info[13]);
        if (n >= 0.0 && ndiv >= 0.0 && nmultsubs_ldl >= 0.0 && nmultsubs_lu >= 0.0) {
            Damd_info.PRINTF("\n    chol flop count for real A, sqrt counted as 1 flop: %6.0f\n    LDL' flop count for real A:                         %6.0f\n    LDL' flop count for complex A:                      %6.0f\n    LU flop count for real A (with no pivoting):        %6.0f\n    LU flop count for complex A (with no pivoting):     %6.0f\n\n", n + ndiv + 2.0 * nmultsubs_ldl, ndiv + 2.0 * nmultsubs_ldl, 9.0 * ndiv + 8.0 * nmultsubs_ldl, ndiv + 2.0 * nmultsubs_lu, 9.0 * ndiv + 8.0 * nmultsubs_lu);
        }
    }
}

