/*
 * Decompiled with CFR 0.152.
 */
package xlinear;

import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import xlinear.CholeskyDecomposition;
import xlinear.Matrix;
import xlinear.SparseMatrix;
import xlinear.StaticUtils;
import xlinear.internals.CommonsDenseMatrix;
import xlinear.internals.MatrixVisitorEditInPlace;
import xlinear.internals.MatrixVisitorViewOnly;

public interface DenseMatrix
extends Matrix {
    public void visit(MatrixVisitorViewOnly var1);

    public void editInPlace(MatrixVisitorEditInPlace var1);

    @Override
    public DenseMatrix createEmpty(int var1, int var2);

    @Override
    default public CholeskyDecomposition cholesky() {
        CommonsDenseMatrix _convertToCommonsDenseMatrix = StaticUtils.convertToCommonsDenseMatrix(this);
        return _convertToCommonsDenseMatrix.cholesky();
    }

    @Override
    default public DenseMatrix inverse() {
        CommonsDenseMatrix _convertToCommonsDenseMatrix = StaticUtils.convertToCommonsDenseMatrix(this);
        return _convertToCommonsDenseMatrix.inverse();
    }

    @Override
    default public DenseMatrix transpose() {
        int _nCols = this.nCols();
        int _nRows = this.nRows();
        DenseMatrix result = this.createEmpty(_nCols, _nRows);
        MatrixVisitorEditInPlace _function = (row, col, value) -> this.get(col, row);
        result.editInPlace(_function);
        return result;
    }

    @Override
    default public DoubleStream nonZeroEntries() {
        DoubleStream _xifexpression = null;
        boolean _isVector = this.isVector();
        if (_isVector) {
            int _nEntries = this.nEntries();
            IntStream _range = IntStream.range(0, _nEntries);
            IntToDoubleFunction _function = entry -> this.get(entry);
            _xifexpression = _range.mapToDouble(_function);
        } else {
            int _nRows = this.nRows();
            IntStream _range_1 = IntStream.range(0, _nRows);
            IntFunction<DenseMatrix> _function_1 = row -> this.row(row);
            Stream<DenseMatrix> _mapToObj = _range_1.mapToObj(_function_1);
            Function<Matrix, DoubleStream> _function_2 = rowMatrix -> rowMatrix.nonZeroEntries();
            _xifexpression = _mapToObj.flatMapToDouble(_function_2);
        }
        DoubleStream result = _xifexpression;
        DoublePredicate _function_3 = entry -> entry != 0.0;
        return result.filter(_function_3);
    }

    @Override
    default public DenseMatrix operator_multiply(Number n) {
        return this.mul(n);
    }

    @Override
    default public DenseMatrix mul(Number n) {
        double _doubleValue = n.doubleValue();
        return StaticUtils.scale(this, _doubleValue);
    }

    @Override
    default public void mulInPlace(Number n) {
        double _doubleValue = n.doubleValue();
        StaticUtils.scaleInPlace(this, _doubleValue);
    }

    @Override
    default public DenseMatrix operator_multiply(Matrix m) {
        return this.mul(m);
    }

    @Override
    default public DenseMatrix operator_multiply(DenseMatrix m) {
        return this.mul(m);
    }

    @Override
    default public DenseMatrix operator_multiply(SparseMatrix m) {
        return this.mul(m);
    }

    @Override
    default public DenseMatrix mul(Matrix m) {
        Matrix _mul = Matrix.super.mul(m);
        return (DenseMatrix)_mul;
    }

    @Override
    public DenseMatrix mul(DenseMatrix var1);

    @Override
    default public DenseMatrix mul(SparseMatrix m) {
        return StaticUtils.multiply(this, m);
    }

    @Override
    default public DenseMatrix operator_plus(Matrix m) {
        return this.add(m);
    }

    @Override
    default public DenseMatrix operator_plus(DenseMatrix m) {
        return this.add(m);
    }

    @Override
    default public DenseMatrix operator_plus(SparseMatrix m) {
        return this.add(m);
    }

    @Override
    default public DenseMatrix add(Matrix m) {
        Matrix _add = Matrix.super.add(m);
        return (DenseMatrix)_add;
    }

    @Override
    default public DenseMatrix add(DenseMatrix m) {
        return StaticUtils.add(this, m);
    }

    @Override
    default public DenseMatrix add(SparseMatrix m) {
        return StaticUtils.add(m, this);
    }

    @Override
    default public void addInPlace(DenseMatrix m) {
        StaticUtils.addInPlace(this, m);
    }

    @Override
    default public void addInPlace(SparseMatrix m) {
        StaticUtils.addInPlace((Matrix)this, m);
    }

    @Override
    default public DenseMatrix operator_minus(Matrix m) {
        return this.sub(m);
    }

    @Override
    default public DenseMatrix operator_minus(DenseMatrix m) {
        return this.sub(m);
    }

    @Override
    default public DenseMatrix operator_minus(SparseMatrix m) {
        return this.sub(m);
    }

    @Override
    default public DenseMatrix sub(Matrix m) {
        Matrix _sub = Matrix.super.sub(m);
        return (DenseMatrix)_sub;
    }

    @Override
    default public DenseMatrix sub(DenseMatrix m) {
        return StaticUtils.subtract(this, m);
    }

    @Override
    default public DenseMatrix sub(SparseMatrix m) {
        return StaticUtils.subtract(this, m);
    }

    @Override
    default public void subInPlace(DenseMatrix m) {
        StaticUtils.subtractInPlace(this, m);
    }

    @Override
    default public void subInPlace(SparseMatrix m) {
        StaticUtils.subtractInPlace(this, m);
    }

    @Override
    public DenseMatrix slice(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    default public DenseMatrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Excl) {
        Matrix _slice = Matrix.super.slice(row0Incl, row1Excl, col0Incl, col1Excl);
        return (DenseMatrix)_slice;
    }

    @Override
    default public DenseMatrix row(int index) {
        Matrix _row = Matrix.super.row(index);
        return (DenseMatrix)_row;
    }

    @Override
    default public DenseMatrix col(int index) {
        Matrix _col = Matrix.super.col(index);
        return (DenseMatrix)_col;
    }

    @Override
    default public DenseMatrix readOnlyView() {
        Matrix _readOnlyView = Matrix.super.readOnlyView();
        return (DenseMatrix)_readOnlyView;
    }
}

