/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding
extends TypeVariableBinding {
    public TypeBinding lowerBound;
    public WildcardBinding wildcard;
    public int captureID;
    public ReferenceBinding sourceType;
    public int position;

    public CaptureBinding(WildcardBinding wildcard, ReferenceBinding sourceType, int position, int captureID) {
        super(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX, null, 0, wildcard.environment);
        this.wildcard = wildcard;
        this.modifiers = 0x40000001;
        this.fPackage = wildcard.fPackage;
        this.sourceType = sourceType;
        this.position = position;
        this.captureID = captureID;
        this.tagBits |= 0x2000000000000000L;
        if (wildcard.hasTypeAnnotations()) {
            this.setTypeAnnotations(wildcard.getTypeAnnotations(), wildcard.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
            if (wildcard.hasNullTypeAnnotations()) {
                this.tagBits |= 0x100000L;
            }
        }
    }

    protected CaptureBinding(ReferenceBinding sourceType, char[] sourceName, int position, int captureID, LookupEnvironment environment) {
        super(sourceName, null, 0, environment);
        this.modifiers = 0x40000001;
        this.sourceType = sourceType;
        this.position = position;
        this.captureID = captureID;
    }

    public CaptureBinding(CaptureBinding prototype) {
        super(prototype);
        this.wildcard = prototype.wildcard;
        this.sourceType = prototype.sourceType;
        this.position = prototype.position;
        this.captureID = prototype.captureID;
        this.lowerBound = prototype.lowerBound;
        this.tagBits |= prototype.tagBits & 0x2000000000000000L;
    }

    @Override
    public TypeBinding clone(TypeBinding enclosingType) {
        return new CaptureBinding(this);
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        if (isLeaf) {
            buffer.append(this.sourceType.computeUniqueKey(false));
            buffer.append('&');
        }
        buffer.append(TypeConstants.WILDCARD_CAPTURE);
        buffer.append(this.wildcard.computeUniqueKey(false));
        buffer.append(this.position);
        buffer.append(';');
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    @Override
    public String debugName() {
        if (this.wildcard != null) {
            StringBuffer buffer = new StringBuffer(10);
            AnnotationBinding[] annotations = this.getTypeAnnotations();
            int i = 0;
            int length = annotations == null ? 0 : annotations.length;
            while (i < length) {
                buffer.append(annotations[i]);
                buffer.append(' ');
                ++i;
            }
            buffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.debugName());
            return buffer.toString();
        }
        return super.debugName();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            this.genericTypeSignature = CharOperation.concat(TypeConstants.WILDCARD_CAPTURE, this.wildcard.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public void initializeBounds(Scope scope, ParameterizedTypeBinding capturedParameterizedType) {
        ReferenceBinding[] originalVariableInterfaces;
        ReferenceBinding[] substitutedVariableInterfaces;
        TypeVariableBinding wildcardVariable = this.wildcard.typeVariable();
        if (wildcardVariable == null) {
            TypeBinding originalWildcardBound = this.wildcard.bound;
            switch (this.wildcard.boundKind) {
                case 1: {
                    TypeBinding capturedWildcardBound = originalWildcardBound.capture(scope, this.position);
                    if (originalWildcardBound.isInterface()) {
                        this.setSuperClass(scope.getJavaLangObject());
                        this.setSuperInterfaces(new ReferenceBinding[]{(ReferenceBinding)capturedWildcardBound});
                    } else {
                        if (capturedWildcardBound.isArrayType() || TypeBinding.equalsEquals(capturedWildcardBound, this)) {
                            this.setSuperClass(scope.getJavaLangObject());
                        } else {
                            this.setSuperClass((ReferenceBinding)capturedWildcardBound);
                        }
                        this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    }
                    this.setFirstBound(capturedWildcardBound);
                    if ((capturedWildcardBound.tagBits & 0x20000000L) != 0L) break;
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                    break;
                }
                case 0: {
                    this.setSuperClass(scope.getJavaLangObject());
                    this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                    break;
                }
                case 2: {
                    this.setSuperClass(scope.getJavaLangObject());
                    this.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                    this.lowerBound = this.wildcard.bound;
                    if ((originalWildcardBound.tagBits & 0x20000000L) != 0L) break;
                    this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                }
            }
            return;
        }
        ReferenceBinding originalVariableSuperclass = wildcardVariable.superclass;
        ReferenceBinding substitutedVariableSuperclass = (ReferenceBinding)Scope.substitute((Substitution)capturedParameterizedType, originalVariableSuperclass);
        if (TypeBinding.equalsEquals(substitutedVariableSuperclass, this)) {
            substitutedVariableSuperclass = originalVariableSuperclass;
        }
        if ((substitutedVariableInterfaces = Scope.substitute((Substitution)capturedParameterizedType, originalVariableInterfaces = wildcardVariable.superInterfaces())) != originalVariableInterfaces) {
            int i = 0;
            int length = substitutedVariableInterfaces.length;
            while (i < length) {
                if (TypeBinding.equalsEquals(substitutedVariableInterfaces[i], this)) {
                    substitutedVariableInterfaces[i] = originalVariableInterfaces[i];
                }
                ++i;
            }
        }
        TypeBinding originalWildcardBound = this.wildcard.bound;
        switch (this.wildcard.boundKind) {
            case 1: {
                TypeBinding capturedWildcardBound = originalWildcardBound.capture(scope, this.position);
                if (originalWildcardBound.isInterface()) {
                    this.setSuperClass(substitutedVariableSuperclass);
                    if (substitutedVariableInterfaces == Binding.NO_SUPERINTERFACES) {
                        this.setSuperInterfaces(new ReferenceBinding[]{(ReferenceBinding)capturedWildcardBound});
                    } else {
                        int length = substitutedVariableInterfaces.length;
                        ReferenceBinding[] referenceBindingArray = substitutedVariableInterfaces;
                        substitutedVariableInterfaces = new ReferenceBinding[length + 1];
                        System.arraycopy(referenceBindingArray, 0, substitutedVariableInterfaces, 1, length);
                        substitutedVariableInterfaces[0] = (ReferenceBinding)originalWildcardBound;
                        ReferenceBinding[] glb = Scope.greaterLowerBound(substitutedVariableInterfaces);
                        if (glb != null) {
                            int i = 0;
                            while (i < glb.length) {
                                glb[i] = (ReferenceBinding)glb[i].capture(scope, this.position);
                                ++i;
                            }
                        }
                        this.setSuperInterfaces(glb);
                    }
                } else {
                    if (capturedWildcardBound.isArrayType() || TypeBinding.equalsEquals(capturedWildcardBound, this)) {
                        this.setSuperClass(substitutedVariableSuperclass);
                    } else {
                        this.setSuperClass((ReferenceBinding)capturedWildcardBound);
                        if (this.superclass.isSuperclassOf(substitutedVariableSuperclass)) {
                            this.setSuperClass(substitutedVariableSuperclass);
                        }
                    }
                    this.setSuperInterfaces(substitutedVariableInterfaces);
                }
                this.setFirstBound(capturedWildcardBound);
                if ((capturedWildcardBound.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 0: {
                this.setSuperClass(substitutedVariableSuperclass);
                this.setSuperInterfaces(substitutedVariableInterfaces);
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 2: {
                this.setSuperClass(substitutedVariableSuperclass);
                if (TypeBinding.equalsEquals(wildcardVariable.firstBound, substitutedVariableSuperclass) || TypeBinding.equalsEquals(originalWildcardBound, substitutedVariableSuperclass)) {
                    this.setFirstBound(substitutedVariableSuperclass);
                }
                this.setSuperInterfaces(substitutedVariableInterfaces);
                this.lowerBound = originalWildcardBound;
                if ((originalWildcardBound.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
            }
        }
    }

    @Override
    public boolean isCapture() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding otherType) {
        if (CaptureBinding.equalsEquals(this, otherType)) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (this.firstBound != null && this.firstBound.isArrayType() && this.firstBound.isCompatibleWith(otherType)) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
        }
        return false;
    }

    @Override
    public char[] readableName() {
        if (this.wildcard != null) {
            StringBuffer buffer = new StringBuffer(10);
            buffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.readableName());
            int length = buffer.length();
            char[] name = new char[length];
            buffer.getChars(0, length, name, 0);
            return name;
        }
        return super.readableName();
    }

    @Override
    public char[] shortReadableName() {
        if (this.wildcard != null) {
            StringBuffer buffer = new StringBuffer(10);
            buffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard.shortReadableName());
            int length = buffer.length();
            char[] name = new char[length];
            buffer.getChars(0, length, name, 0);
            return name;
        }
        return super.shortReadableName();
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions options, boolean shortNames) {
        StringBuffer nameBuffer = new StringBuffer(10);
        this.appendNullAnnotation(nameBuffer, options);
        nameBuffer.append(this.sourceName());
        if (!this.inRecursiveFunction) {
            this.inRecursiveFunction = true;
            try {
                if (this.wildcard != null) {
                    nameBuffer.append("of ");
                    nameBuffer.append(this.wildcard.nullAnnotatedReadableName(options, shortNames));
                } else if (this.lowerBound != null) {
                    nameBuffer.append(" super ");
                    nameBuffer.append(this.lowerBound.nullAnnotatedReadableName(options, shortNames));
                } else if (this.firstBound != null) {
                    nameBuffer.append(" extends ");
                    nameBuffer.append(this.firstBound.nullAnnotatedReadableName(options, shortNames));
                    TypeBinding[] otherUpperBounds = this.otherUpperBounds();
                    if (otherUpperBounds != NO_TYPES) {
                        nameBuffer.append(" & ...");
                    }
                }
            }
            finally {
                this.inRecursiveFunction = false;
            }
        }
        int nameLength = nameBuffer.length();
        char[] readableName = new char[nameLength];
        nameBuffer.getChars(0, nameLength, readableName, 0);
        return readableName;
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        return this.wildcard;
    }

    @Override
    public String toString() {
        if (this.wildcard != null) {
            StringBuffer buffer = new StringBuffer(10);
            AnnotationBinding[] annotations = this.getTypeAnnotations();
            int i = 0;
            int length = annotations == null ? 0 : annotations.length;
            while (i < length) {
                buffer.append(annotations[i]);
                buffer.append(' ');
                ++i;
            }
            buffer.append(TypeConstants.WILDCARD_CAPTURE_NAME_PREFIX).append(this.captureID).append(TypeConstants.WILDCARD_CAPTURE_NAME_SUFFIX).append(this.wildcard);
            return buffer.toString();
        }
        return super.toString();
    }
}

