/*
 * Decompiled with CFR 0.152.
 */
package binc.lookup;

import binc.BinCallUtils;
import binc.Command;
import binc.Commands;
import binc.GlobalSettings;
import binc.lookup.BinLookupStrategy;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectoryListLookup
implements BinLookupStrategy {
    private final List<File> directories;
    public static final List<String> defaultUnixPaths = Arrays.asList("/bin/", "/sbin/", "/usr/bin/", "/usr/local/bin/", "/usr/sbin/", "~/bin/");

    public DirectoryListLookup(List<File> directories) {
        this.directories = directories;
    }

    public static String getPathFromBash() {
        return Commands.bash.withArgs("-l -s").callWithInputStreamContents("echo $PATH;");
    }

    public static DirectoryListLookup fromPathEnvironmentVariable() {
        String value = System.getenv("PATH");
        ArrayList directories = Lists.newArrayList();
        for (String item : value.split("[:]")) {
            directories.add(new File(item));
        }
        return new DirectoryListLookup(directories);
    }

    public static DirectoryListLookup fromListWithUserHomeToResolve(List<String> paths) {
        ArrayList directories = Lists.newArrayList();
        for (String path : paths) {
            directories.add(BinCallUtils.resolveUserHome(path));
        }
        return new DirectoryListLookup(directories);
    }

    @Override
    public File lookup(Command bin) {
        boolean found = false;
        File result = null;
        for (File directory : this.directories) {
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.canExecute() || !file.getName().equals(bin.getName())) continue;
                if (found) {
                    if (!GlobalSettings.warnIfMultipleMatchesFound) continue;
                    System.err.println("Duplicate binaries found in path: " + bin.getName() + " is in both " + file.getAbsolutePath() + " and " + result.getAbsolutePath());
                    continue;
                }
                found = true;
                result = file;
            }
        }
        return result;
    }

    public String toString() {
        return "DirectoryListLookup [directories=" + this.directories + "]";
    }
}

