/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Set;
import java.util.TreeSet;
import spoon.Launcher;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.reference.CtVariableReferenceImpl;
import spoon.support.util.RtHelper;

public class CtFieldReferenceImpl<T>
extends CtVariableReferenceImpl<T>
implements CtFieldReference<T> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<?> declaringType;
    boolean fina = false;
    boolean stat = false;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtFieldReference(this);
    }

    @Override
    public Member getActualField() {
        try {
            if (this.getDeclaringType().getActualClass().isAnnotation()) {
                return this.getDeclaringType().getActualClass().getDeclaredMethod(this.getSimpleName(), new Class[0]);
            }
            return this.getDeclaringType().getActualClass().getDeclaredField(this.getSimpleName());
        }
        catch (Exception e) {
            Launcher.logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        return (AnnotatedElement)((Object)this.getActualField());
    }

    @Override
    public CtField<T> getDeclaration() {
        CtType type = (CtType)this.declaringType.getDeclaration();
        if (this.declaringType != null && type != null) {
            return type.getField(this.getSimpleName());
        }
        return null;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getQualifiedName() {
        return this.getDeclaringType().getQualifiedName() + "#" + this.getSimpleName();
    }

    @Override
    public boolean isFinal() {
        return this.fina;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public void setDeclaringType(CtTypeReference<?> declaringType) {
        this.declaringType = declaringType;
    }

    @Override
    public void setFinal(boolean b) {
        this.fina = b;
    }

    @Override
    public void setStatic(boolean stat) {
        this.stat = stat;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtVariable v = this.getDeclaration();
        if (v != null) {
            return v.getModifiers();
        }
        Member m = this.getActualField();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        return new TreeSet<ModifierKind>();
    }
}

