/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.ColumnsIterator;
import org.ojalgo.access.RowsIterator;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;

public interface Access2D<N extends Number>
extends Structure2D,
Access1D<N> {
    @Override
    default public double doubleValue(long index) {
        long tmpStructure = this.countRows();
        return this.doubleValue(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure));
    }

    public double doubleValue(long var1, long var3);

    @Override
    default public N get(long index) {
        long tmpStructure = this.countRows();
        return this.get(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure));
    }

    public N get(long var1, long var3);

    default public double[][] toRawCopy2D() {
        return ArrayUtils.toRawCopyOf(this);
    }

    public static interface Visitable<N extends Number>
    extends Structure2D,
    Access1D.Visitable<N> {
        public void visitColumn(long var1, long var3, VoidFunction<N> var5);

        public void visitDiagonal(long var1, long var3, VoidFunction<N> var5);

        public void visitOne(long var1, long var3, VoidFunction<N> var5);

        @Override
        default public void visitOne(long index, VoidFunction<N> visitor) {
            long tmpStructure = this.countRows();
            this.visitOne(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), visitor);
        }

        public void visitRow(long var1, long var3, VoidFunction<N> var5);
    }

    public static interface Special<N extends Number>
    extends Structure2D {
        public void exchangeColumns(long var1, long var3);

        public void exchangeRows(long var1, long var3);
    }

    public static interface Sliceable<N extends Number>
    extends Structure2D,
    Access1D.Sliceable<N> {
        public Access1D<N> sliceColumn(long var1, long var3);

        public Access1D<N> sliceDiagonal(long var1, long var3);

        public Access1D<N> sliceRow(long var1, long var3);
    }

    public static interface Settable<N extends Number>
    extends Structure2D,
    Access1D.Settable<N> {
        @Override
        default public void add(long index, double addend) {
            long tmpStructure = this.countRows();
            this.add(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), addend);
        }

        public void add(long var1, long var3, double var5);

        public void add(long var1, long var3, Number var5);

        @Override
        default public void add(long index, Number addend) {
            long tmpStructure = this.countRows();
            this.add(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), addend);
        }

        @Override
        default public void set(long index, double addend) {
            long tmpStructure = this.countRows();
            this.set(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), addend);
        }

        public void set(long var1, long var3, double var5);

        public void set(long var1, long var3, Number var5);

        @Override
        default public void set(long index, Number addend) {
            long tmpStructure = this.countRows();
            this.set(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), addend);
        }
    }

    public static interface Modifiable<N extends Number>
    extends Settable<N>,
    Access1D.Modifiable<N> {
        public void modifyColumn(long var1, long var3, UnaryFunction<N> var5);

        public void modifyDiagonal(long var1, long var3, UnaryFunction<N> var5);

        public void modifyOne(long var1, long var3, UnaryFunction<N> var5);

        @Override
        default public void modifyOne(long index, UnaryFunction<N> function) {
            long tmpStructure = this.countRows();
            this.modifyOne(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), function);
        }

        @Override
        default public void modifyRange(long first, long limit, UnaryFunction<N> function) {
            for (long i = first; i < limit; ++i) {
                this.modifyOne(i, function);
            }
        }

        public void modifyRow(long var1, long var3, UnaryFunction<N> var5);
    }

    public static interface Iterable2D<N extends Number>
    extends Access2D<N> {
        default public Iterable<Access1D<N>> columns() {
            return ColumnsIterator.make(this);
        }

        default public Iterable<Access1D<N>> rows() {
            return RowsIterator.make(this);
        }
    }

    public static interface Fillable<N extends Number>
    extends Settable<N>,
    Access1D.Fillable<N> {
        default public void fillColumn(long row, long column, Access1D<N> values) {
            long tmpCount = values.count();
            for (long i = 0L; i < tmpCount; ++i) {
                this.set(row + i, column, (Number)values.get(i));
            }
        }

        public void fillColumn(long var1, long var3, N var5);

        public void fillColumn(long var1, long var3, NullaryFunction<N> var5);

        default public void fillDiagonal(long row, long column, Access1D<N> values) {
            for (long ij = 0L; ij < values.count(); ++ij) {
                this.set(row + ij, column + ij, (Number)values.get(ij));
            }
        }

        public void fillDiagonal(long var1, long var3, N var5);

        public void fillDiagonal(long var1, long var3, NullaryFunction<N> var5);

        public void fillOne(long var1, long var3, N var5);

        public void fillOne(long var1, long var3, NullaryFunction<N> var5);

        @Override
        default public void fillOne(long index, N value) {
            long tmpStructure = this.countRows();
            this.fillOne(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), value);
        }

        @Override
        default public void fillOne(long index, NullaryFunction<N> supplier) {
            long tmpStructure = this.countRows();
            this.fillOne(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), supplier);
        }

        @Override
        default public void fillOneMatching(long index, Access1D<?> values, long valueIndex) {
            long tmpStructure = this.countRows();
            this.fillOneMatching(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), values, valueIndex);
        }

        public void fillOneMatching(long var1, long var3, Access1D<?> var5, long var6);

        @Override
        default public void fillRange(long first, long limit, N value) {
            for (long i = first; i < limit; ++i) {
                this.fillOne(i, value);
            }
        }

        @Override
        default public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
            for (long i = first; i < limit; ++i) {
                this.fillOne(i, supplier);
            }
        }

        default public void fillRow(long row, long column, Access1D<N> values) {
            for (long j = 0L; j < values.count(); ++j) {
                this.set(row, column + j, (Number)values.get(j));
            }
        }

        public void fillRow(long var1, long var3, N var5);

        public void fillRow(long var1, long var3, NullaryFunction<N> var5);
    }

    public static interface Factory<I extends Access2D<?>> {
        public I columns(Access1D<?> ... var1);

        public I columns(double[] ... var1);

        public I columns(List<? extends Number> ... var1);

        public I columns(Number[] ... var1);

        public I copy(Access2D<?> var1);

        public I makeEye(long var1, long var3);

        public I makeFilled(long var1, long var3, NullaryFunction<?> var5);

        public I makeZero(long var1, long var3);

        public I rows(Access1D<?> ... var1);

        public I rows(double[] ... var1);

        public I rows(List<? extends Number> ... var1);

        public I rows(Number[] ... var1);
    }

    public static interface IndexOf
    extends Structure2D,
    Access1D.IndexOf {
        public long indexOfLargestInColumn(long var1, long var3);

        public long indexOfLargestInDiagonal(long var1, long var3);

        public long indexOfLargestInRow(long var1, long var3);
    }

    public static interface Elements
    extends Structure2D,
    Access1D.Elements {
        @Override
        default public boolean isAbsolute(long index) {
            long tmpStructure = this.countRows();
            return this.isAbsolute(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure));
        }

        public boolean isAbsolute(long var1, long var3);

        @Override
        default public boolean isSmall(long index, double comparedTo) {
            long tmpStructure = this.countRows();
            return this.isSmall(AccessUtils.row(index, tmpStructure), AccessUtils.column(index, tmpStructure), comparedTo);
        }

        public boolean isSmall(long var1, long var3, double var5);

        @Deprecated
        default public boolean isZero(long row, long column) {
            return this.isSmall(row, column, PrimitiveMath.ONE);
        }
    }

    public static interface Builder<I extends Access2D<?>>
    extends Structure2D,
    Access1D.Builder<I> {
        @Override
        public I build();

        public Builder<I> fillColumn(long var1, long var3, Number var5);

        public Builder<I> fillDiagonal(long var1, long var3, Number var5);

        public Builder<I> fillRow(long var1, long var3, Number var5);

        public Builder<I> set(long var1, long var3, double var5);

        public Builder<I> set(long var1, long var3, Number var5);
    }
}

