/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;

public class ColumnsIterator<N extends Number>
implements Access1D<N>,
Iterator<Access1D<N>> {
    public long column = -1L;
    private final Access2D<N> myAccess2D;
    final ColumnIterable iterable = new ColumnIterable();

    public static <S extends Number> Iterable<Access1D<S>> make(Access2D<S> access) {
        return new ColumnsIterator<S>(access).iterable;
    }

    public ColumnsIterator(Access2D<N> access) {
        this.myAccess2D = access;
    }

    private ColumnsIterator() {
        this(null);
    }

    @Override
    public long count() {
        return this.myAccess2D.countRows();
    }

    @Override
    public double doubleValue(long index) {
        return this.myAccess2D.doubleValue(index, this.column);
    }

    @Override
    public N get(long index) {
        return this.myAccess2D.get(index, this.column);
    }

    @Override
    public boolean hasNext() {
        return this.column + 1L < this.myAccess2D.countColumns();
    }

    @Override
    public Access1D<N> next() {
        ++this.column;
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    final class ColumnIterable
    implements Iterable<Access1D<N>> {
        ColumnIterable() {
        }

        @Override
        public Iterator<Access1D<N>> iterator() {
            return ColumnsIterator.this;
        }
    }
}

