/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public class ComplexArray
extends ReferenceTypeArray<ComplexNumber> {
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(ComplexNumber.class);
    static final DenseArray.DenseFactory<ComplexNumber> FACTORY = new DenseArray.DenseFactory<ComplexNumber>(){

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        DenseArray<ComplexNumber> make(int size) {
            return ComplexArray.make(size);
        }

        @Override
        Scalar<ComplexNumber> zero() {
            return ComplexNumber.ZERO;
        }
    };

    public static final ComplexArray make(int size) {
        return new ComplexArray(size);
    }

    public static final SegmentedArray<ComplexNumber> makeSegmented(long count) {
        return SegmentedArray.make(FACTORY, count);
    }

    public static final ComplexArray wrap(ComplexNumber[] data) {
        return new ComplexArray(data);
    }

    protected ComplexArray(ComplexNumber[] data) {
        super((Number[])data);
    }

    protected ComplexArray(int size) {
        super((Number[])new ComplexNumber[size]);
        this.fill(0, size, 1, ComplexNumber.ZERO);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof ComplexArray) {
            return Arrays.equals(this.data, ((ComplexArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((ComplexNumber[])this.data)[i] = ComplexNumber.valueOf(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((ComplexNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((ComplexNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = first; i < limit; i += step) {
            double tmpValue = ((ComplexNumber[])this.data)[i].norm();
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return ComplexNumber.isAbsolute(((ComplexNumber[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return ComplexNumber.isSmall(comparedTo, ((ComplexNumber[])this.data)[index]);
    }

    @Override
    DenseArray<ComplexNumber> newInstance(int capacity) {
        return new ComplexArray(capacity);
    }

    @Override
    ComplexNumber valueOf(double value) {
        return ComplexNumber.valueOf(value);
    }

    @Override
    ComplexNumber valueOf(Number number) {
        return ComplexNumber.valueOf(number);
    }
}

