/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.ArrayFactory;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public final class SparseArray<N extends Number>
extends BasicArray<N> {
    static final SparseFactory<BigDecimal> BIG = new SparseFactory<BigDecimal>(){

        @Override
        long getElementSize() {
            return BigArray.ELEMENT_SIZE;
        }

        @Override
        SparseArray<BigDecimal> make(long count) {
            return SparseArray.makeBig(count);
        }
    };
    static final SparseFactory<ComplexNumber> COMPLEX = new SparseFactory<ComplexNumber>(){

        @Override
        long getElementSize() {
            return ComplexArray.ELEMENT_SIZE;
        }

        @Override
        SparseArray<ComplexNumber> make(long count) {
            return SparseArray.makeComplex(count);
        }
    };
    static final SparseFactory<Double> PRIMITIVE = new SparseFactory<Double>(){

        @Override
        long getElementSize() {
            return PrimitiveArray.ELEMENT_SIZE;
        }

        @Override
        SparseArray<Double> make(long count) {
            return SparseArray.makePrimitive(count);
        }
    };
    static final SparseFactory<Quaternion> QUATERNION = new SparseFactory<Quaternion>(){

        @Override
        long getElementSize() {
            return QuaternionArray.ELEMENT_SIZE;
        }

        @Override
        SparseArray<Quaternion> make(long count) {
            return SparseArray.makeQuaternion(count);
        }
    };
    static final SparseFactory<RationalNumber> RATIONAL = new SparseFactory<RationalNumber>(){

        @Override
        long getElementSize() {
            return RationalArray.ELEMENT_SIZE;
        }

        @Override
        SparseArray<RationalNumber> make(long count) {
            return SparseArray.makeRational(count);
        }
    };
    private int myActualLength = 0;
    private final long myCount;
    private long[] myIndices;
    private DenseArray<N> myValues;
    private final N myZeroNumber;
    private final Scalar<N> myZeroScalar;
    private final double myZeroValue;

    public static SparseArray<BigDecimal> makeBig(long count) {
        return new SparseArray<BigDecimal>(count, BigArray.FACTORY);
    }

    public static final SegmentedArray<BigDecimal> makeBigSegmented(long count) {
        return SegmentedArray.make(BIG, count);
    }

    public static SparseArray<ComplexNumber> makeComplex(long count) {
        return new SparseArray<ComplexNumber>(count, ComplexArray.FACTORY);
    }

    public static final SegmentedArray<ComplexNumber> makeComplexSegmented(long count) {
        return SegmentedArray.make(COMPLEX, count);
    }

    public static SparseArray<Double> makePrimitive(long count) {
        return new SparseArray<Double>(count, PrimitiveArray.FACTORY);
    }

    public static final SegmentedArray<Double> makePrimitiveSegmented(long count) {
        return SegmentedArray.make(PRIMITIVE, count);
    }

    public static SparseArray<Quaternion> makeQuaternion(long count) {
        return new SparseArray<Quaternion>(count, QuaternionArray.FACTORY);
    }

    public static final SegmentedArray<Quaternion> makeQuaternionSegmented(long count) {
        return SegmentedArray.make(QUATERNION, count);
    }

    public static SparseArray<RationalNumber> makeRational(long count) {
        return new SparseArray<RationalNumber>(count, RationalArray.FACTORY);
    }

    public static final SegmentedArray<RationalNumber> makeRationalSegmented(long count) {
        return SegmentedArray.make(RATIONAL, count);
    }

    SparseArray(long count, DenseArray.DenseFactory<N> factory) {
        this.myCount = count;
        double tmpInitialCapacity = count;
        while ((tmpInitialCapacity = Math.sqrt(tmpInitialCapacity)) > 2.147483639E9) {
        }
        int tmpLength = 2 * (int)tmpInitialCapacity;
        this.myIndices = new long[tmpLength];
        this.myValues = factory.make(tmpLength);
        this.myZeroScalar = factory.zero();
        this.myZeroNumber = this.myZeroScalar.getNumber();
        this.myZeroValue = ((Number)this.myZeroNumber).doubleValue();
    }

    @Override
    public void add(long index, double addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add(tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public void add(long index, Number addend) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.add(tmpIndex, addend);
        } else {
            this.set(index, addend);
        }
    }

    @Override
    public final long count() {
        return this.myCount;
    }

    @Override
    public double doubleValue(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.doubleValue(tmpIndex);
        }
        return this.myZeroValue;
    }

    @Override
    public void fillAll(N value) {
        if (TypeUtils.isZero(((Number)value).doubleValue())) {
            this.myValues.fillAll(this.myZeroNumber);
        } else {
            int tmpSize = (int)this.count();
            if (tmpSize != this.myIndices.length) {
                this.myIndices = AccessUtils.makeIncreasingRange(0L, tmpSize);
                this.myValues = this.myValues.newInstance(tmpSize);
                this.myActualLength = tmpSize;
            }
            this.myValues.fillAll(value);
        }
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        int tmpSize = (int)this.count();
        if (tmpSize != this.myIndices.length) {
            this.myIndices = AccessUtils.makeIncreasingRange(0L, tmpSize);
            this.myValues = this.myValues.newInstance(tmpSize);
            this.myActualLength = tmpSize;
        }
        this.myValues.fillAll(supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        this.set(index, (Number)value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.set(index, (Number)supplier.get());
    }

    @Override
    public void fillOneMatching(long index, Access1D<?> values, long valueIndex) {
        if (this.isPrimitive()) {
            this.set(index, values.doubleValue(valueIndex));
        } else {
            this.set(index, (Number)values.get(valueIndex));
        }
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.fill(first, limit, 1L, supplier);
    }

    public long firstInRange(long rangeFirst, long rangeLimit) {
        int tmpFoundAt = this.index(rangeFirst);
        if (tmpFoundAt < 0) {
            return Math.min(this.myIndices[-tmpFoundAt + 1], rangeLimit);
        }
        return rangeFirst;
    }

    @Override
    public N get(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.get(tmpIndex);
        }
        return this.myZeroNumber;
    }

    @Override
    public boolean isAbsolute(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.isAbsolute(tmpIndex);
        }
        return true;
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.isSmall(tmpIndex, comparedTo);
        }
        return true;
    }

    @Override
    public boolean isZero(long index) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            return this.myValues.isZero(tmpIndex);
        }
        return true;
    }

    public long limitOfRange(long rangeFirst, long rangeLimit) {
        int tmpFoundAt = this.index(rangeLimit - 1L);
        if (tmpFoundAt < 0) {
            return Math.max(rangeFirst, this.myIndices[-tmpFoundAt] + 1L);
        }
        return rangeLimit;
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> function) {
        this.set(index, (Number)function.invoke(this.get(index)));
    }

    @Override
    public void set(long index, double value) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.set(tmpIndex, value);
        } else {
            long[] tmpOldIndeces = this.myIndices;
            int tmpInsInd = -(tmpIndex + 1);
            if (this.myActualLength + 1 <= tmpOldIndeces.length) {
                for (int i = this.myActualLength; i > tmpInsInd; --i) {
                    tmpOldIndeces[i] = tmpOldIndeces[i - 1];
                    this.myValues.set(i, this.myValues.doubleValue(i - 1));
                }
                tmpOldIndeces[tmpInsInd] = index;
                this.myValues.set(tmpInsInd, value);
                ++this.myActualLength;
            } else {
                int i;
                int tmpCapacity = tmpOldIndeces.length * 2;
                long[] tmpIndices = new long[tmpCapacity];
                DenseArray<N> tmpValues = this.myValues.newInstance(tmpCapacity);
                for (i = 0; i < tmpInsInd; ++i) {
                    tmpIndices[i] = tmpOldIndeces[i];
                    tmpValues.set(i, this.myValues.doubleValue(i));
                }
                tmpIndices[tmpInsInd] = index;
                tmpValues.set(tmpInsInd, value);
                for (i = tmpInsInd; i < tmpOldIndeces.length; ++i) {
                    tmpIndices[i + 1] = tmpOldIndeces[i];
                    tmpValues.set(i + 1, this.myValues.doubleValue(i));
                }
                for (i = tmpOldIndeces.length + 1; i < tmpIndices.length; ++i) {
                    tmpIndices[i] = Long.MAX_VALUE;
                }
                this.myIndices = tmpIndices;
                this.myValues = tmpValues;
                ++this.myActualLength;
            }
        }
    }

    @Override
    public void set(long index, Number value) {
        int tmpIndex = this.index(index);
        if (tmpIndex >= 0) {
            this.myValues.set(tmpIndex, value);
        } else {
            long[] tmpOldIndeces = this.myIndices;
            int tmpInsInd = -(tmpIndex + 1);
            if (this.myActualLength + 1 <= tmpOldIndeces.length) {
                for (int i = this.myActualLength; i > tmpInsInd; --i) {
                    tmpOldIndeces[i] = tmpOldIndeces[i - 1];
                    this.myValues.set(i, (Number)this.myValues.get(i - 1));
                }
                tmpOldIndeces[tmpInsInd] = index;
                this.myValues.set(tmpInsInd, value);
                ++this.myActualLength;
            } else {
                int i;
                int tmpCapacity = tmpOldIndeces.length * 2;
                long[] tmpIndices = new long[tmpCapacity];
                DenseArray<N> tmpValues = this.myValues.newInstance(tmpCapacity);
                for (i = 0; i < tmpInsInd; ++i) {
                    tmpIndices[i] = tmpOldIndeces[i];
                    tmpValues.set(i, (Number)this.myValues.get(i));
                }
                tmpIndices[tmpInsInd] = index;
                tmpValues.set(tmpInsInd, value);
                for (i = tmpInsInd; i < tmpOldIndeces.length; ++i) {
                    tmpIndices[i + 1] = tmpOldIndeces[i];
                    tmpValues.set(i + 1, (Number)this.myValues.get(i));
                }
                for (i = tmpOldIndeces.length + 1; i < tmpIndices.length; ++i) {
                    tmpIndices[i] = Long.MAX_VALUE;
                }
                this.myIndices = tmpIndices;
                this.myValues = tmpValues;
                ++this.myActualLength;
            }
        }
    }

    public void supplyNonZerosTo(Access1D.Settable<N> consumer) {
        this.supplyNonZerosTo(consumer, LongUnaryOperator.identity());
    }

    public void supplyNonZerosTo(Access1D.Settable<N> consumer, LongUnaryOperator indexRemapper) {
        if (this.isPrimitive()) {
            for (int n = 0; n < this.myActualLength; ++n) {
                long tmpMappedIndex = indexRemapper.applyAsLong(this.myIndices[n]);
                if (tmpMappedIndex < 0L) continue;
                consumer.set(tmpMappedIndex, this.myValues.doubleValue(n));
            }
        } else {
            for (int n = 0; n < this.myActualLength; ++n) {
                long tmpMappedIndex = indexRemapper.applyAsLong(this.myIndices[n]);
                if (tmpMappedIndex < 0L) continue;
                consumer.set(tmpMappedIndex, (Number)this.myValues.get(n));
            }
        }
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        if (this.isPrimitive()) {
            visitor.invoke(this.doubleValue(index));
        } else {
            visitor.invoke(this.get(index));
        }
    }

    @Override
    protected void exchange(long firstA, long firstB, long step, long count) {
        if (this.isPrimitive()) {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                double tmpVal = this.doubleValue(tmpIndexA);
                this.set(tmpIndexA, this.doubleValue(tmpIndexB));
                this.set(tmpIndexB, tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        } else {
            long tmpIndexA = firstA;
            long tmpIndexB = firstB;
            for (long i = 0L; i < count; ++i) {
                N tmpVal = this.get(tmpIndexA);
                this.set(tmpIndexA, (Number)this.get(tmpIndexB));
                this.set(tmpIndexB, (Number)tmpVal);
                tmpIndexA += step;
                tmpIndexB += step;
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, N value) {
        int tmpLimit;
        int tmpFirst = this.index(first);
        if (tmpFirst < 0) {
            tmpFirst = -tmpFirst + 1;
        }
        if ((tmpLimit = this.index(limit)) < 0) {
            tmpLimit = -tmpLimit + 1;
        }
        if (this.isPrimitive()) {
            double tmpValue = ((Number)value).doubleValue();
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set(i, tmpValue);
            }
        } else {
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set(i, (Number)value);
            }
        }
    }

    @Override
    protected void fill(long first, long limit, long step, NullaryFunction<N> supplier) {
        int tmpLimit;
        int tmpFirst = this.index(first);
        if (tmpFirst < 0) {
            tmpFirst = -tmpFirst + 1;
        }
        if ((tmpLimit = this.index(limit)) < 0) {
            tmpLimit = -tmpLimit + 1;
        }
        if (this.isPrimitive()) {
            double tmpValue = supplier.doubleValue();
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set(i, tmpValue);
            }
        } else {
            for (int i = tmpFirst; i < tmpLimit; ++i) {
                this.myValues.set(i, (Number)supplier.invoke());
            }
        }
    }

    @Override
    protected long indexOfLargest(long first, long limit, long step) {
        double tmpVal = PrimitiveMath.ZERO;
        long retVal = Long.MIN_VALUE;
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L || !(this.myValues.doubleValue(i) > tmpVal)) continue;
            tmpVal = Math.abs(this.myValues.doubleValue(i));
            retVal = tmpIndex;
        }
        return retVal;
    }

    @Override
    protected boolean isSmall(long first, long limit, long step, double comparedTo) {
        boolean retVal = true;
        for (int i = 0; retVal && i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
            retVal &= this.myValues.isSmall(i, comparedTo);
        }
        return retVal;
    }

    @Override
    protected void modify(long first, long limit, long step, Access1D<N> left, BinaryFunction<N> function) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        if (TypeUtils.isZero(tmpZeroValue)) {
            for (int i = 0; i < this.myIndices.length; ++i) {
                long tmpIndex = this.myIndices[i];
                if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
                this.myValues.modify(i, left, function);
            }
        } else {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
    }

    @Override
    protected void modify(long first, long limit, long step, BinaryFunction<N> function, Access1D<N> right) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
        if (TypeUtils.isZero(tmpZeroValue)) {
            for (int i = 0; i < this.myIndices.length; ++i) {
                long tmpIndex = this.myIndices[i];
                if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
                this.myValues.modify(i, function, right);
            }
        } else {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
    }

    @Override
    protected void modify(long first, long limit, long step, UnaryFunction<N> function) {
        double tmpZeroValue = function.invoke(PrimitiveMath.ZERO);
        if (TypeUtils.isZero(tmpZeroValue)) {
            for (int i = 0; i < this.myIndices.length; ++i) {
                long tmpIndex = this.myIndices[i];
                if (tmpIndex < first || tmpIndex >= limit || (tmpIndex - first) % step != 0L) continue;
                this.myValues.modify(i, function);
            }
        } else {
            throw new IllegalArgumentException("SparseArray zero modification!");
        }
    }

    @Override
    protected void visit(long first, long limit, long step, VoidFunction<N> visitor) {
        boolean tmpOnlyOnce = true;
        for (int i = 0; i < this.myIndices.length; ++i) {
            long tmpIndex = this.myIndices[i];
            if (tmpIndex >= first && tmpIndex < limit && (tmpIndex - first) % step == 0L) {
                this.myValues.visitOne(i, visitor);
                continue;
            }
            if (!tmpOnlyOnce) continue;
            visitor.invoke(this.myZeroValue);
            tmpOnlyOnce = false;
        }
    }

    final DenseArray<N> densify() {
        DenseArray<N> retVal = this.myValues.newInstance((int)this.count());
        if (this.isPrimitive()) {
            for (int i = 0; i < this.myActualLength; ++i) {
                retVal.set(this.myIndices[i], this.myValues.doubleValue(i));
            }
        } else {
            for (int i = 0; i < this.myActualLength; ++i) {
                retVal.set(this.myIndices[i], (Number)this.myValues.get(i));
            }
        }
        return retVal;
    }

    final int index(long index) {
        return Arrays.binarySearch(this.myIndices, 0, this.myActualLength, index);
    }

    @Override
    boolean isPrimitive() {
        return this.myValues.isPrimitive();
    }

    static abstract class SparseFactory<N extends Number>
    extends ArrayFactory<N> {
        SparseFactory() {
        }

        abstract SparseArray<N> make(long var1);

        @Override
        final SparseArray<N> makeStructuredZero(long ... structure) {
            return this.make(AccessUtils.count(structure));
        }

        @Override
        final SparseArray<N> makeToBeFilled(long ... structure) {
            return this.make(AccessUtils.count(structure));
        }
    }
}

