/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.data;

import java.util.Calendar;
import java.util.Date;
import org.ojalgo.finance.data.DataSource;
import org.ojalgo.finance.data.DatePrice;
import org.ojalgo.type.CalendarDateUnit;

public class YahooSymbol
extends DataSource<Data> {
    private static final String CSV = ".csv";
    private static final String D = "d";
    private static final String G = "g";
    private static final String ICHART_FINANCE_YAHOO_COM = "ichart.finance.yahoo.com";
    private static final String IGNORE = "ignore";
    private static final String M = "m";
    private static final String S = "s";
    private static final String TABLE_CSV = "/table.csv";
    private static final String W = "w";

    public YahooSymbol(String aSymbol) {
        this(aSymbol, CalendarDateUnit.DAY);
    }

    public YahooSymbol(String aSymbol, CalendarDateUnit aResolution) {
        super(aSymbol, aResolution);
        this.setHost(ICHART_FINANCE_YAHOO_COM);
        this.setPath(TABLE_CSV);
        this.addQueryParameter(S, aSymbol);
        switch (aResolution) {
            case MONTH: {
                this.addQueryParameter(G, M);
                break;
            }
            case WEEK: {
                this.addQueryParameter(G, W);
                break;
            }
            default: {
                this.addQueryParameter(G, D);
            }
        }
        this.addQueryParameter(IGNORE, CSV);
    }

    @Override
    protected Data parse(String aLine) {
        Data retVal = null;
        int tmpInclusiveBegin = 0;
        int tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        String tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        retVal = new Data(tmpString);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        retVal.open = Double.parseDouble(tmpString);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        retVal.high = Double.parseDouble(tmpString);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        retVal.low = Double.parseDouble(tmpString);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        retVal.close = Double.parseDouble(tmpString);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpExclusiveEnd = aLine.indexOf(44, tmpInclusiveBegin);
        tmpString = aLine.substring(tmpInclusiveBegin, tmpExclusiveEnd);
        retVal.volume = Double.parseDouble(tmpString);
        tmpInclusiveBegin = tmpExclusiveEnd + 1;
        tmpString = aLine.substring(tmpInclusiveBegin);
        retVal.adjustedClose = Double.parseDouble(tmpString);
        return retVal;
    }

    public static final class Data
    extends DatePrice {
        public double adjustedClose;
        public double close;
        public double high;
        public double low;
        public double open;
        public double volume;

        protected Data(Date aDate) {
            super(aDate);
        }

        protected Data(long aDate) {
            super(aDate);
        }

        protected Data(String sqlString) {
            super(sqlString);
        }

        protected Data(Calendar aDate) {
            super(aDate);
        }

        @Override
        public double getPrice() {
            return this.adjustedClose;
        }
    }
}

