/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;

public class PrimitivePolynomial
extends AbstractPolynomial<Double> {
    public PrimitivePolynomial(int aDegree) {
        super(Array1D.PRIMITIVE.makeZero(aDegree + 1));
    }

    PrimitivePolynomial(Array1D<Double> someCoefficients) {
        super(someCoefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        int tmpRowDim = (int)Math.min(x.count(), y.count());
        int tmpColDim = this.size();
        PhysicalStore tmpBody = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRowDim, tmpColDim);
        PhysicalStore tmpRHS = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero(tmpRowDim, 1L);
        for (int i = 0; i < tmpRowDim; ++i) {
            double tmpX = PrimitiveMath.ONE;
            double tmpXfactor = x.doubleValue(i);
            double tmpY = y.doubleValue(i);
            for (int j = 0; j < tmpColDim; ++j) {
                tmpBody.set((long)i, (long)j, tmpX);
                tmpX *= tmpXfactor;
            }
            tmpRHS.set((long)i, 0L, tmpY);
        }
        QR<Double> tmpQR = QR.makePrimitive();
        tmpQR.decompose(tmpBody);
        this.set(tmpQR.solve(tmpRHS));
    }

    @Override
    public Double integrate(Double fromPoint, Double toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        double tmpFromVal = tmpPrim.invoke(fromPoint);
        double tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal - tmpFromVal;
    }

    @Override
    public Double invoke(Double arg) {
        return this.invoke((double)arg);
    }

    @Override
    public void set(Access1D<?> someCoefficient) {
        int tmpLimit = (int)Math.min(this.count(), someCoefficient.count());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, someCoefficient.doubleValue(p));
        }
    }

    @Override
    protected Double getDerivativeFactor(int aPower) {
        int tmpNextIndex = aPower + 1;
        return (double)tmpNextIndex * this.doubleValue(tmpNextIndex);
    }

    @Override
    protected Double getPrimitiveFactor(int aPower) {
        if (aPower <= 0) {
            return PrimitiveMath.ZERO;
        }
        return this.doubleValue(aPower - 1) / (double)aPower;
    }

    @Override
    protected AbstractPolynomial<Double> makeInstance(int aSize) {
        return new PrimitivePolynomial((Array1D<Double>)Array1D.PRIMITIVE.makeZero(aSize));
    }
}

