/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public final class BigMatrix
extends AbstractMatrix<BigDecimal, BigMatrix> {
    public static final BasicMatrix.Factory<BigMatrix> FACTORY = new MatrixFactory<BigDecimal, BigMatrix>(BigMatrix.class, BigDenseStore.FACTORY);

    public static Access2D.Builder<BigMatrix> getBuilder(int aLength) {
        return FACTORY.getBuilder(aLength);
    }

    public static Access2D.Builder<BigMatrix> getBuilder(int aRowDim, int aColDim) {
        return FACTORY.getBuilder(aRowDim, aColDim);
    }

    BigMatrix(MatrixStore<BigDecimal> aStore) {
        super(aStore);
    }

    @Override
    public BigMatrix enforce(NumberContext context) {
        return (BigMatrix)this.modify(context.getBigFunction());
    }

    @Override
    public BigDecimal toBigDecimal(int row, int column) {
        return (BigDecimal)this.getStore().get(row, column);
    }

    @Override
    public PhysicalStore<BigDecimal> toBigStore() {
        return this.getStore().copy();
    }

    @Override
    public ComplexNumber toComplexNumber(int row, int column) {
        return ComplexNumber.valueOf(this.getStore().doubleValue(row, column));
    }

    @Override
    public String toString(int row, int col) {
        return this.toBigDecimal(row, col).toPlainString();
    }

    @Override
    MatrixFactory<BigDecimal, BigMatrix> getFactory() {
        return (MatrixFactory)FACTORY;
    }

    @Override
    MatrixStore<BigDecimal> getStoreFrom(Access1D<?> aMtrx) {
        if (aMtrx instanceof BigMatrix) {
            return ((BigMatrix)aMtrx).getStore();
        }
        if (aMtrx instanceof BigDenseStore) {
            return (BigDenseStore)aMtrx;
        }
        if (aMtrx instanceof MatrixStore && !this.isEmpty() && aMtrx.get(0L) instanceof BigDecimal) {
            return (MatrixStore)aMtrx;
        }
        if (aMtrx instanceof Access2D) {
            return (MatrixStore)this.getPhysicalFactory().copy((Access2D)aMtrx);
        }
        return (MatrixStore)this.getPhysicalFactory().columns(aMtrx);
    }
}

