/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class GeneralEvD<N extends Number>
extends EigenvalueDecomposition<N> {
    protected GeneralEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public final boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public final N getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return this.scalar().cast(tmpVisitor.getNumber());
    }

    public MatrixStore<N> getInverse() {
        throw new UnsupportedOperationException();
    }

    public MatrixStore<N> getInverse(DecompositionStore<N> newPreallocated) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return tmpVisitor.getNumber();
    }

    @Override
    public final boolean isHermitian() {
        return false;
    }

    @Override
    public final boolean isOrdered() {
        return true;
    }

    public final boolean isSolvable() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    protected boolean doNonsymmetric(ElementsSupplier<N> aMtrx, boolean eigenvaluesOnly) {
        int tmpDiagDim = (int)aMtrx.countRows();
        DecompositionStore tmpMtrxA = this.copy((Access2D<?>)aMtrx.get());
        DecompositionStore tmpV = this.makeEye(tmpDiagDim, tmpDiagDim);
        Array1D<ComplexNumber> tmpEigenvalues = tmpMtrxA.computeInPlaceSchur(tmpV, true);
        this.setV(tmpV);
        this.setEigenvalues(tmpEigenvalues);
        DecompositionStore tmpD = this.makeZero(tmpDiagDim, tmpDiagDim);
        for (int ij = 0; ij < tmpDiagDim; ++ij) {
            ComplexNumber tmpValue = (ComplexNumber)tmpEigenvalues.get(ij);
            tmpD.set((long)ij, (long)ij, tmpValue.doubleValue());
            double tmpImaginary = tmpValue.i;
            if (tmpImaginary > PrimitiveMath.ZERO) {
                tmpD.set((long)ij, (long)(ij + 1), tmpImaginary);
                continue;
            }
            if (!(tmpImaginary < PrimitiveMath.ZERO)) continue;
            tmpD.set((long)ij, (long)(ij - 1), tmpImaginary);
        }
        this.setD(tmpD);
        tmpEigenvalues.sortDescending();
        return this.computed(true);
    }

    @Override
    protected boolean doSymmetric(ElementsSupplier<N> aMtrx, boolean eigenvaluesOnly) {
        return this.doNonsymmetric(aMtrx, eigenvaluesOnly);
    }

    @Override
    protected final MatrixStore<N> makeD() {
        return null;
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        return null;
    }

    protected final MatrixStore<N> makeInverse() {
        MatrixStore tmpV = this.getV();
        MatrixStore tmpD = this.getD();
        int tmpDim = (int)tmpD.countRows();
        PhysicalStore tmpMtrx = tmpV.transpose().copy();
        Object tmpZero = this.scalar().zero().getNumber();
        BinaryFunction tmpDivide = this.function().divide();
        for (int i = 0; i < tmpDim; ++i) {
            if (tmpD.isZero(i, i)) {
                tmpMtrx.fillRow((long)i, 0L, tmpZero);
                continue;
            }
            tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
        }
        return tmpV.multiply(tmpMtrx);
    }

    @Override
    protected MatrixStore<N> makeV() {
        return null;
    }

    static final class Primitive
    extends GeneralEvD<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }
    }
}

