/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.store.operation.DotProduct;
import org.ojalgo.type.context.NumberContext;

final class RawCholesky
extends RawDecomposition
implements Cholesky<Double> {
    private boolean mySPD = false;

    RawCholesky() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, false);
        this.doDecompose(retVal, matrix);
        return this.getDeterminant();
    }

    @Override
    public boolean checkAndCompute(MatrixStore<Double> matrix) {
        this.mySPD = MatrixUtils.isHermitian(matrix);
        if (this.mySPD) {
            double[][] retVal = this.reset(matrix, false);
            return this.doDecompose(retVal, matrix);
        }
        return this.computed(false);
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        double[][] retVal = this.reset(matrix, false);
        RawStore tmpRawInPlaceStore = this.getRawInPlaceStore();
        matrix.supplyTo(tmpRawInPlaceStore);
        return this.doDecompose(retVal, tmpRawInPlaceStore);
    }

    @Override
    public boolean equals(MatrixStore<Double> matrix, NumberContext context) {
        return MatrixUtils.equals(matrix, this, context);
    }

    @Override
    public Double getDeterminant() {
        double[][] tmpData = this.getRawInPlaceData();
        int tmpMinDim = this.getMinDim();
        double retVal = PrimitiveMath.ONE;
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            double tmpVal = tmpData[ij][ij];
            retVal *= tmpVal * tmpVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getL() {
        return this.getRawInPlaceStore().builder().triangular(false, false).build();
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, DecompositionStore<Double> preallocated) {
        double[][] retVal = this.reset(original, false);
        this.doDecompose(retVal, original);
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed() && this.isSPD();
    }

    @Override
    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<Double> preallocated) {
        double[][] retVal = this.reset(body, false);
        this.doDecompose(retVal, body);
        preallocated.fillMatching(rhs);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> solve(ElementsSupplier<Double> rhs, DecompositionStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        preallocated.fillMatching(rhs);
        return this.doSolve(preallocated);
    }

    @Override
    protected MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, false, false, true);
        preallocated.substituteBackwards(tmpBody, false, true, true);
        return preallocated.builder().hermitian(false).get();
    }

    MatrixStore<Double> doSolve(DecompositionStore<Double> preallocated) {
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, false, false, false);
        preallocated.substituteBackwards(tmpBody, false, true, false);
        return preallocated;
    }

    boolean doDecompose(double[][] data, Access2D<?> input) {
        int tmpDiagDim = this.getRowDim();
        this.mySPD = this.getColDim() == tmpDiagDim;
        for (int ij = 0; ij < tmpDiagDim; ++ij) {
            double[] tmpRowIJ;
            (tmpRowIJ = data[ij])[ij] = Math.sqrt(Math.max(input.doubleValue(ij, ij) - DotProduct.invoke(tmpRowIJ, 0, tmpRowIJ, 0, 0, ij), PrimitiveMath.ZERO));
            double tmpD = (tmpRowIJ = data[ij])[ij];
            this.mySPD &= tmpD > PrimitiveMath.ZERO;
            for (int i = ij + 1; i < tmpDiagDim; ++i) {
                double[] tmpRowI = data[i];
                tmpRowI[ij] = (input.doubleValue(i, ij) - DotProduct.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij)) / tmpD;
            }
        }
        return this.computed(true);
    }
}

