/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.BidiagonalDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

abstract class SVDold30<N extends Number>
extends SingularValueDecomposition<N> {
    private Future<PhysicalStore<N>> myFutureQ1;
    private Future<PhysicalStore<N>> myFutureQ2;
    private final List<Rotation<N>> myQ1Rotations = new ArrayList<Rotation<N>>();
    private final List<Rotation<N>> myQ2Rotations = new ArrayList<Rotation<N>>();

    protected SVDold30(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory, BidiagonalDecomposition<N> aBidiagonal) {
        super(aFactory, aBidiagonal);
    }

    @Override
    public boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isSolvable() {
        return this.isComputed();
    }

    @Override
    public void reset() {
        super.reset();
        this.myQ1Rotations.clear();
        this.myQ2Rotations.clear();
        this.myFutureQ1 = null;
        this.myFutureQ2 = null;
    }

    @Override
    protected boolean doCompute(ElementsSupplier<N> aStore, boolean singularValuesOnly, boolean fullSize) {
        int tmpMinDim = (int)Math.min(aStore.countRows(), aStore.countColumns());
        this.computeBidiagonal(aStore, fullSize);
        DecompositionStore tmpSimilar = this.copy(this.getBidiagonalAccessD());
        this.setD(tmpSimilar);
        this.setSingularValues((Array1D<Double>)Array1D.PRIMITIVE.makeZero(tmpMinDim));
        Rotation[] tmpRotations = new Rotation[2];
        Object tmpZero = this.scalar().zero().getNumber();
        boolean tmpNotAllZeros = true;
        for (int l = 0; tmpNotAllZeros && l < tmpMinDim; ++l) {
            tmpNotAllZeros = false;
            for (int i0 = 1; i0 < tmpMinDim; ++i0) {
                for (int j = 0; j < tmpMinDim - i0; ++j) {
                    int i = i0 + j;
                    if (!tmpSimilar.isZero(i, j) || !tmpSimilar.isZero(j, i)) {
                        tmpNotAllZeros = true;
                        tmpRotations = this.rotations(tmpSimilar, j, i, tmpRotations);
                        tmpSimilar.transformLeft(tmpRotations[0]);
                        tmpSimilar.transformRight(tmpRotations[1]);
                        this.myQ1Rotations.add(tmpRotations[0].invert());
                        this.myQ2Rotations.add(tmpRotations[1]);
                    }
                    tmpSimilar.set((long)i, (long)j, (Number)tmpZero);
                    tmpSimilar.set((long)j, (long)i, (Number)tmpZero);
                }
            }
        }
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            double tmpSingularValue;
            if (tmpSimilar.isZero(ij, ij)) {
                tmpSingularValue = PrimitiveMath.ZERO;
            } else if (tmpSimilar.isAbsolute(ij, ij)) {
                tmpSingularValue = tmpSimilar.doubleValue(ij, ij);
            } else {
                Scalar tmpDiagSclr = tmpSimilar.toScalar(ij, ij);
                Object tmpSignum = ((Scalar)tmpDiagSclr.signum()).getNumber();
                tmpSingularValue = ((Scalar)tmpDiagSclr.divide(tmpSignum)).norm();
                tmpSimilar.set((long)ij, (long)ij, tmpSingularValue);
                this.myQ2Rotations.add(this.makeRotation(ij, ij, tmpSignum, tmpSignum));
            }
            this.getSingularValues().set((long)ij, tmpSingularValue);
        }
        this.getSingularValues().sortDescending();
        this.myFutureQ1 = DaemonPoolExecutor.invoke(new Callable<PhysicalStore<N>>(){

            @Override
            public PhysicalStore<N> call() throws Exception {
                DecompositionStore retVal = SVDold30.this.getBidiagonalQ1();
                List tmpRotations = SVDold30.this.myQ1Rotations;
                int tmpLimit = tmpRotations.size();
                for (int r = 0; r < tmpLimit; ++r) {
                    retVal.transformRight((Rotation)tmpRotations.get(r));
                }
                return retVal;
            }
        });
        this.myFutureQ2 = DaemonPoolExecutor.invoke(new Callable<PhysicalStore<N>>(){

            @Override
            public PhysicalStore<N> call() throws Exception {
                DecompositionStore retVal = SVDold30.this.getBidiagonalQ2();
                List tmpRotations = SVDold30.this.myQ2Rotations;
                int tmpLimit = tmpRotations.size();
                for (int r = 0; r < tmpLimit; ++r) {
                    retVal.transformRight((Rotation)tmpRotations.get(r));
                }
                return retVal;
            }
        });
        return this.computed(true);
    }

    protected DiagonalAccess<N> extractSimilar(PhysicalStore<N> aStore, boolean aNormalAspectRatio) {
        Array2D tmpArray2D = ((DecompositionStore)aStore).asArray2D();
        Access1D tmpMain = tmpArray2D.sliceDiagonal(0L, 0L);
        if (aNormalAspectRatio) {
            Access1D tmpSuper = tmpArray2D.sliceDiagonal(0L, 1L);
            return new DiagonalAccess(tmpMain, tmpSuper, null, this.scalar().zero().getNumber());
        }
        Access1D tmpSub = tmpArray2D.sliceDiagonal(1L, 0L);
        return new DiagonalAccess(tmpMain, null, tmpSub, this.scalar().zero().getNumber());
    }

    @Override
    protected MatrixStore<N> makeD() {
        return null;
    }

    @Override
    protected MatrixStore<N> makeQ1() {
        try {
            return this.myFutureQ1.get();
        }
        catch (InterruptedException anException) {
            throw new ProgrammingError(anException.getMessage());
        }
        catch (ExecutionException anException) {
            throw new ProgrammingError(anException.getMessage());
        }
    }

    @Override
    protected MatrixStore<N> makeQ2() {
        try {
            return this.myFutureQ2.get();
        }
        catch (InterruptedException anException) {
            throw new ProgrammingError(anException.getMessage());
        }
        catch (ExecutionException anException) {
            throw new ProgrammingError(anException.getMessage());
        }
    }

    @Override
    protected Array1D<Double> makeSingularValues() {
        return null;
    }

    protected abstract Rotation<N>[] rotations(PhysicalStore<N> var1, int var2, int var3, Rotation<N>[] var4);

    static final class Primitive
    extends SVDold30<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY, new BidiagonalDecomposition.Primitive());
        }

        @Override
        protected Rotation<Double>[] rotations(PhysicalStore<Double> aStore, int aLowInd, int aHighInd, Rotation<Double>[] retVal) {
            double t;
            double sg;
            double cg;
            double a00 = aStore.doubleValue(aLowInd, aLowInd);
            double a01 = aStore.doubleValue(aLowInd, aHighInd);
            double a10 = aStore.doubleValue(aHighInd, aLowInd);
            double a11 = aStore.doubleValue(aHighInd, aHighInd);
            double x = a00 + a11;
            double y = a10 - a01;
            if (TypeUtils.isZero(y)) {
                cg = Math.signum(x);
                sg = PrimitiveMath.ZERO;
            } else if (TypeUtils.isZero(x)) {
                sg = Math.signum(y);
                cg = PrimitiveMath.ZERO;
            } else if (Math.abs(y) > Math.abs(x)) {
                t = x / y;
                sg = Math.signum(y) / PrimitiveFunction.SQRT1PX2.invoke(t);
                cg = sg * t;
            } else {
                t = y / x;
                cg = Math.signum(x) / PrimitiveFunction.SQRT1PX2.invoke(t);
                sg = cg * t;
            }
            double b00 = cg * a00 + sg * a10;
            double b11 = cg * a11 - sg * a01;
            double b2 = cg * (a01 + a10) + sg * (a11 - a00);
            t = (b11 - b00) / b2;
            t = Math.signum(t) / (PrimitiveFunction.SQRT1PX2.invoke(t) + Math.abs(t));
            double cj = PrimitiveMath.ONE / PrimitiveFunction.SQRT1PX2.invoke(t);
            double sj = cj * t;
            retVal[1] = new Rotation.Primitive(aLowInd, aHighInd, cj, sj);
            retVal[0] = new Rotation.Primitive(aLowInd, aHighInd, cj * cg + sj * sg, cj * sg - sj * cg);
            return retVal;
        }
    }

    static final class Complex
    extends SVDold30<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY, new BidiagonalDecomposition.Complex());
        }

        @Override
        protected Rotation<ComplexNumber>[] rotations(PhysicalStore<ComplexNumber> aStore, int aLowInd, int aHighInd, Rotation<ComplexNumber>[] retVal) {
            ComplexNumber t;
            ComplexNumber sg;
            ComplexNumber cg;
            ComplexNumber a00 = (ComplexNumber)aStore.get(aLowInd, aLowInd);
            ComplexNumber a01 = (ComplexNumber)aStore.get(aLowInd, aHighInd);
            ComplexNumber a10 = (ComplexNumber)aStore.get(aHighInd, aLowInd);
            ComplexNumber a11 = (ComplexNumber)aStore.get(aHighInd, aHighInd);
            ComplexNumber x = a00.add(a11);
            ComplexNumber y = a10.subtract(a01);
            if (ComplexNumber.isSmall(PrimitiveMath.ONE, y)) {
                cg = x.signum();
                sg = ComplexNumber.ZERO;
            } else if (ComplexNumber.isSmall(PrimitiveMath.ONE, x)) {
                sg = y.signum();
                cg = ComplexNumber.ZERO;
            } else if (y.compareTo(x) == 1) {
                t = x.divide(y);
                sg = y.signum().divide(ComplexFunction.SQRT1PX2.invoke(t));
                cg = sg.multiply(t);
            } else {
                t = y.divide(x);
                cg = x.signum().divide(ComplexFunction.SQRT1PX2.invoke(t));
                sg = cg.multiply(t);
            }
            ComplexNumber b00 = cg.multiply(a00).add(sg.multiply(a10));
            ComplexNumber b11 = cg.multiply(a11).subtract(sg.multiply(a01));
            ComplexNumber b2 = cg.multiply(a01.add(a10)).add(sg.multiply(a11.subtract(a00)));
            t = b11.subtract(b00).divide(b2);
            t = t.signum().divide(ComplexFunction.SQRT1PX2.invoke(t).add(t.norm()));
            ComplexNumber cj = ComplexFunction.SQRT1PX2.invoke(t).invert();
            ComplexNumber sj = cj.multiply(t);
            retVal[1] = new Rotation.Complex(aLowInd, aHighInd, cj, sj);
            retVal[0] = new Rotation.Complex(aLowInd, aHighInd, cj.multiply(cg).add(sj.multiply(sg)), cj.multiply(sg).subtract(sj.multiply(cg)));
            return retVal;
        }
    }

    static final class Big
    extends SVDold30<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY, new BidiagonalDecomposition.Big());
        }

        @Override
        protected Rotation<BigDecimal>[] rotations(PhysicalStore<BigDecimal> aStore, int aLowInd, int aHighInd, Rotation<BigDecimal>[] retVal) {
            BigDecimal t;
            BigDecimal sg;
            BigDecimal cg;
            BigDecimal a00 = (BigDecimal)aStore.get(aLowInd, aLowInd);
            BigDecimal a01 = (BigDecimal)aStore.get(aLowInd, aHighInd);
            BigDecimal a10 = (BigDecimal)aStore.get(aHighInd, aLowInd);
            BigDecimal a11 = (BigDecimal)aStore.get(aHighInd, aHighInd);
            BigDecimal x = a00.add(a11);
            BigDecimal y = a10.subtract(a01);
            if (y.signum() == 0) {
                cg = BigFunction.SIGNUM.invoke(x);
                sg = BigMath.ZERO;
            } else if (x.signum() == 0) {
                sg = BigFunction.SIGNUM.invoke(y);
                cg = BigMath.ZERO;
            } else if (y.abs().compareTo(x.abs()) == 1) {
                t = BigFunction.DIVIDE.invoke(x, y);
                sg = BigFunction.DIVIDE.invoke(BigFunction.SIGNUM.invoke(y), BigFunction.SQRT1PX2.invoke(t));
                cg = sg.multiply(t);
            } else {
                t = BigFunction.DIVIDE.invoke(y, x);
                cg = BigFunction.DIVIDE.invoke(BigFunction.SIGNUM.invoke(x), BigFunction.SQRT1PX2.invoke(t));
                sg = cg.multiply(t);
            }
            BigDecimal b00 = cg.multiply(a00).add(sg.multiply(a10));
            BigDecimal b11 = cg.multiply(a11).subtract(sg.multiply(a01));
            BigDecimal b2 = cg.multiply(a01.add(a10)).add(sg.multiply(a11.subtract(a00)));
            t = BigFunction.DIVIDE.invoke(b11.subtract(b00), b2);
            t = BigFunction.DIVIDE.invoke(BigFunction.SIGNUM.invoke(t), BigFunction.SQRT1PX2.invoke(t).add(t.abs()));
            BigDecimal cj = BigFunction.DIVIDE.invoke(BigMath.ONE, BigFunction.SQRT1PX2.invoke(t));
            BigDecimal sj = cj.multiply(t);
            retVal[1] = new Rotation.Big(aLowInd, aHighInd, cj, sj);
            retVal[0] = new Rotation.Big(aLowInd, aHighInd, cj.multiply(cg).add(sj.multiply(sg)), cj.multiply(sg).subtract(sj.multiply(cg)));
            return retVal;
        }
    }
}

