/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.io.Serializable;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.type.context.NumberContext;

abstract class AbstractStore<N extends Number>
implements MatrixStore<N>,
Serializable {
    private final int myColDim;
    private transient Class<?> myComponentType = null;
    private final int myRowDim;

    private AbstractStore() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected AbstractStore(int rowsCount, int columnsCount) {
        this.myRowDim = rowsCount;
        this.myColDim = columnsCount;
    }

    @Override
    public N aggregateAll(Aggregator aggregator) {
        AggregatorFunction tmpFunction = aggregator.getFunction(this.getComponentType());
        this.visitAll(tmpFunction);
        return tmpFunction.getNumber();
    }

    @Override
    public final MatrixStore.Builder<N> builder() {
        return new MatrixStore.Builder(this);
    }

    @Override
    public final PhysicalStore<N> copy() {
        PhysicalStore retVal = (PhysicalStore)this.factory().makeZero(this.countRows(), this.countColumns());
        this.supplyNonZerosTo(retVal);
        return retVal;
    }

    @Override
    public long count() {
        return this.myRowDim * this.myColDim;
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public final boolean equals(MatrixStore<N> other, NumberContext context) {
        return AccessUtils.equals(this, other, context);
    }

    public final boolean equals(Object someObj) {
        if (someObj instanceof MatrixStore) {
            return this.equals((MatrixStore)someObj, NumberContext.getGeneral(6));
        }
        return super.equals(someObj);
    }

    @Override
    public final MatrixStore<N> get() {
        return this;
    }

    public final int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public boolean isAbsolute(long row, long column) {
        return this.toScalar(row, column).isAbsolute();
    }

    @Override
    public boolean isSmall(long row, long column, double comparedTo) {
        return this.toScalar(row, column).isSmall(comparedTo);
    }

    @Override
    public int limitOfColumn(int col) {
        return this.myRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myColDim;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)this.factory().makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)this.factory().makeZero(1L, 1L);
        if (this.isPrimitive()) {
            tmpStep1.fillByMultiplying(leftAndRight, this);
        } else {
            PhysicalStore tmpLeft = (PhysicalStore)this.factory().rows(leftAndRight);
            tmpLeft.fillMatching(this.factory().function().conjugate(), leftAndRight);
            tmpStep1.fillByMultiplying(tmpLeft, this);
        }
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return tmpStep2.get(0L);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        consumer.fillAll(this.factory().scalar().zero().getNumber());
        this.supplyNonZerosTo(consumer);
    }

    public final String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        for (int j = 0; j < tmpColDim; ++j) {
            for (int i = 0; i < tmpRowDim; ++i) {
                visitor.invoke(this.get(i, j));
            }
        }
    }

    @Override
    public void visitColumn(long row, long column, VoidFunction<N> visitor) {
        long tmpRowDim = this.countRows();
        for (long i = row; i < tmpRowDim; ++i) {
            visitor.invoke(this.get(i, column));
        }
    }

    @Override
    public void visitDiagonal(long row, long column, VoidFunction<N> visitor) {
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int ij = 0;
        while (row + (long)ij < (long)tmpRowDim && column + (long)ij < (long)tmpColDim) {
            visitor.invoke(this.get(row + (long)ij, column + (long)ij));
            ++ij;
        }
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        for (long i = first; i < limit; ++i) {
            visitor.invoke(this.get(i));
        }
    }

    @Override
    public void visitRow(long row, long column, VoidFunction<N> visitor) {
        long tmpColDim = this.countColumns();
        for (long j = column; j < tmpColDim; ++j) {
            visitor.invoke(this.get(row, j));
        }
    }

    protected final int getColDim() {
        return this.myColDim;
    }

    protected final int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    protected final int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    protected final int getRowDim() {
        return this.myRowDim;
    }

    protected abstract void supplyNonZerosTo(ElementsConsumer<N> var1);

    final Class<?> getComponentType() {
        if (this.myComponentType == null) {
            this.myComponentType = this.get(0L, 0L).getClass();
        }
        return this.myComponentType;
    }

    final boolean isPrimitive() {
        return this.getComponentType().equals(Double.class);
    }
}

