/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.machine.JavaType;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.operation.AXPY;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLDL;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillMatchingLeft;
import org.ojalgo.matrix.store.operation.FillMatchingRight;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.FillTransposed;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HouseholderHermitian;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.MAXPY;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class PrimitiveDenseStore
extends PrimitiveArray
implements PhysicalStore<Double>,
DecompositionStore<Double> {
    public static final PhysicalStore.Factory<Double, PrimitiveDenseStore> FACTORY = new PhysicalStore.Factory<Double, PrimitiveDenseStore>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public MatrixStore.Factory<Double> builder() {
            return MatrixStore.PRIMITIVE;
        }

        @Override
        public PrimitiveDenseStore columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn.doubleValue(i);
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn[i];
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore columns(List<? extends Number> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn.get(i).doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore columns(Number[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn[i].doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore conjugate(Access2D<?> source) {
            return this.transpose((Access2D)source);
        }

        @Override
        public PrimitiveDenseStore copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final PrimitiveDenseStore retVal = new PrimitiveDenseStore(tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.invoke(retVal.data, tmpRowDim, aFirst, aLimit, (Access1D<? extends Number>)source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.invoke(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        public PrimitiveArray makeArray(int length) {
            return PrimitiveArray.make(length);
        }

        @Override
        public PrimitiveDenseStore makeEye(long rows, long columns) {
            PrimitiveDenseStore retVal = this.makeZero(rows, columns);
            retVal.myUtility.fillDiagonal(0L, 0L, PrimitiveMath.ONE);
            return retVal;
        }

        @Override
        public PrimitiveDenseStore makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            int tmpRowDim = (int)rows;
            int tmpColDim = (int)columns;
            int tmpLength = tmpRowDim * tmpColDim;
            double[] tmpData = new double[tmpLength];
            for (int i = 0; i < tmpLength; ++i) {
                tmpData[i] = supplier.doubleValue();
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        public Householder.Primitive makeHouseholder(int length) {
            return new Householder.Primitive(length);
        }

        public Rotation.Primitive makeRotation(int low, int high, double cos, double sin) {
            return new Rotation.Primitive(low, high, cos, sin);
        }

        public Rotation.Primitive makeRotation(int low, int high, Double cos, Double sin) {
            return this.makeRotation(low, high, cos != null ? cos : Double.NaN, sin != null ? sin : Double.NaN);
        }

        @Override
        public PrimitiveDenseStore makeZero(long rows, long columns) {
            return new PrimitiveDenseStore((int)rows, (int)columns);
        }

        @Override
        public PrimitiveDenseStore rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow.doubleValue(j);
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow[j];
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore rows(List<? extends Number> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow.get(j).doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public PrimitiveDenseStore rows(Number[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow[j].doubleValue();
                }
            }
            return new PrimitiveDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        public PrimitiveDenseStore transpose(final Access2D<?> source) {
            final PrimitiveDenseStore retVal = new PrimitiveDenseStore((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillTransposed.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillTransposed.invoke(retVal.data, tmpRowDim, first, limit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillTransposed.THRESHOLD);
            } else {
                FillTransposed.invoke(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }
    };
    static final long ELEMENT_SIZE = JavaType.DOUBLE.memory();
    static final long SHALLOW_SIZE = MemoryEstimator.estimateObject(PrimitiveDenseStore.class);
    private final PrimitiveMultiplyBoth multiplyBoth;
    private final PrimitiveMultiplyLeft multiplyLeft;
    private final PrimitiveMultiplyRight multiplyRight;
    private final int myColDim;
    private final int myRowDim;
    private final Array2D<Double> myUtility;
    private transient double[] myWorkerColumn;

    static PrimitiveDenseStore cast(Access1D<Double> matrix) {
        if (matrix instanceof PrimitiveDenseStore) {
            return (PrimitiveDenseStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return (PrimitiveDenseStore)FACTORY.copy((Access2D)matrix);
        }
        return (PrimitiveDenseStore)FACTORY.columns(matrix);
    }

    static Householder.Primitive cast(Householder<Double> transformation) {
        if (transformation instanceof Householder.Primitive) {
            return (Householder.Primitive)transformation;
        }
        if (transformation instanceof DecompositionStore.HouseholderReference) {
            return ((DecompositionStore.HouseholderReference)transformation).getPrimitiveWorker().copy(transformation);
        }
        return new Householder.Primitive(transformation);
    }

    static Rotation.Primitive cast(Rotation<Double> transformation) {
        if (transformation instanceof Rotation.Primitive) {
            return (Rotation.Primitive)transformation;
        }
        return new Rotation.Primitive(transformation);
    }

    static void doAfter(double[] aMtrxH, double[] aMtrxV, double[] tmpMainDiagonal, double[] tmpOffDiagonal, double r, double s, double z, double aNorm1) {
        int tmpDiagDimMinusOne;
        int tmpDiagDim = (int)Math.sqrt(aMtrxH.length);
        for (int ij = tmpDiagDimMinusOne = tmpDiagDim - 1; ij >= 0; --ij) {
            double t;
            double y;
            double x;
            double w;
            int i;
            int l;
            double p = tmpMainDiagonal[ij];
            double q = tmpOffDiagonal[ij];
            if (q == 0.0) {
                l = ij;
                aMtrxH[ij + tmpDiagDim * ij] = 1.0;
                for (i = ij - 1; i >= 0; --i) {
                    int j;
                    w = aMtrxH[i + tmpDiagDim * i] - p;
                    r = PrimitiveMath.ZERO;
                    for (j = l; j <= ij; ++j) {
                        r += aMtrxH[i + tmpDiagDim * j] * aMtrxH[j + tmpDiagDim * ij];
                    }
                    if (tmpOffDiagonal[i] < PrimitiveMath.ZERO) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (tmpOffDiagonal[i] == PrimitiveMath.ZERO) {
                        aMtrxH[i + tmpDiagDim * ij] = w != PrimitiveMath.ZERO ? -r / w : -r / (PrimitiveMath.MACHINE_EPSILON * aNorm1);
                    } else {
                        x = aMtrxH[i + tmpDiagDim * (i + 1)];
                        y = aMtrxH[i + 1 + tmpDiagDim * i];
                        q = (tmpMainDiagonal[i] - p) * (tmpMainDiagonal[i] - p) + tmpOffDiagonal[i] * tmpOffDiagonal[i];
                        aMtrxH[i + tmpDiagDim * ij] = t = (x * s - z * r) / q;
                        aMtrxH[i + 1 + tmpDiagDim * ij] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(aMtrxH[i + tmpDiagDim * ij]);
                    if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                    for (j = i; j <= ij; ++j) {
                        aMtrxH[j + tmpDiagDim * ij] = aMtrxH[j + tmpDiagDim * ij] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = ij - 1;
            if (Math.abs(aMtrxH[ij + tmpDiagDim * (ij - 1)]) > Math.abs(aMtrxH[ij - 1 + tmpDiagDim * ij])) {
                aMtrxH[ij - 1 + tmpDiagDim * (ij - 1)] = q / aMtrxH[ij + tmpDiagDim * (ij - 1)];
                aMtrxH[ij - 1 + tmpDiagDim * ij] = -(aMtrxH[ij + tmpDiagDim * ij] - p) / aMtrxH[ij + tmpDiagDim * (ij - 1)];
            } else {
                ComplexNumber tmpX = ComplexNumber.of(PrimitiveMath.ZERO, -aMtrxH[ij - 1 + tmpDiagDim * ij]);
                double imaginary = q;
                ComplexNumber tmpY = ComplexNumber.of(aMtrxH[ij - 1 + tmpDiagDim * (ij - 1)] - p, imaginary);
                ComplexNumber tmpZ = tmpX.divide(tmpY);
                aMtrxH[ij - 1 + tmpDiagDim * (ij - 1)] = tmpZ.doubleValue();
                aMtrxH[ij - 1 + tmpDiagDim * ij] = tmpZ.i;
            }
            aMtrxH[ij + tmpDiagDim * (ij - 1)] = PrimitiveMath.ZERO;
            aMtrxH[ij + tmpDiagDim * ij] = 1.0;
            for (i = ij - 2; i >= 0; --i) {
                ComplexNumber tmpZ;
                ComplexNumber tmpY;
                double imaginary;
                double real;
                ComplexNumber tmpX;
                double ra = PrimitiveMath.ZERO;
                double sa = PrimitiveMath.ZERO;
                for (int j = l; j <= ij; ++j) {
                    ra += aMtrxH[i + tmpDiagDim * j] * aMtrxH[j + tmpDiagDim * (ij - 1)];
                    sa += aMtrxH[i + tmpDiagDim * j] * aMtrxH[j + tmpDiagDim * ij];
                }
                w = aMtrxH[i + tmpDiagDim * i] - p;
                if (tmpOffDiagonal[i] < PrimitiveMath.ZERO) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (tmpOffDiagonal[i] == 0.0) {
                    tmpX = ComplexNumber.of(-ra, -sa);
                    real = w;
                    imaginary = q;
                    tmpY = ComplexNumber.of(real, imaginary);
                    tmpZ = tmpX.divide(tmpY);
                    aMtrxH[i + tmpDiagDim * (ij - 1)] = tmpZ.doubleValue();
                    aMtrxH[i + tmpDiagDim * ij] = tmpZ.i;
                } else {
                    double vi;
                    x = aMtrxH[i + tmpDiagDim * (i + 1)];
                    y = aMtrxH[i + 1 + tmpDiagDim * i];
                    double vr = (tmpMainDiagonal[i] - p) * (tmpMainDiagonal[i] - p) + tmpOffDiagonal[i] * tmpOffDiagonal[i] - q * q;
                    if (vr == PrimitiveMath.ZERO & (vi = (tmpMainDiagonal[i] - p) * 2.0 * q) == PrimitiveMath.ZERO) {
                        vr = PrimitiveMath.MACHINE_EPSILON * aNorm1 * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    tmpX = ComplexNumber.of(x * r - z * ra + q * sa, x * s - z * sa - q * ra);
                    real = vr;
                    imaginary = vi;
                    tmpY = ComplexNumber.of(real, imaginary);
                    tmpZ = tmpX.divide(tmpY);
                    aMtrxH[i + tmpDiagDim * (ij - 1)] = tmpZ.doubleValue();
                    aMtrxH[i + tmpDiagDim * ij] = tmpZ.i;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        aMtrxH[i + 1 + tmpDiagDim * (ij - 1)] = (-ra - w * aMtrxH[i + tmpDiagDim * (ij - 1)] + q * aMtrxH[i + tmpDiagDim * ij]) / x;
                        aMtrxH[i + 1 + tmpDiagDim * ij] = (-sa - w * aMtrxH[i + tmpDiagDim * ij] - q * aMtrxH[i + tmpDiagDim * (ij - 1)]) / x;
                    } else {
                        ComplexNumber tmpX1 = ComplexNumber.of(-r - y * aMtrxH[i + tmpDiagDim * (ij - 1)], -s - y * aMtrxH[i + tmpDiagDim * ij]);
                        double real1 = z;
                        double imaginary1 = q;
                        ComplexNumber tmpY1 = ComplexNumber.of(real1, imaginary1);
                        ComplexNumber tmpZ1 = tmpX1.divide(tmpY1);
                        aMtrxH[i + 1 + tmpDiagDim * (ij - 1)] = tmpZ1.doubleValue();
                        aMtrxH[i + 1 + tmpDiagDim * ij] = tmpZ1.i;
                    }
                }
                t = Math.max(Math.abs(aMtrxH[i + tmpDiagDim * (ij - 1)]), Math.abs(aMtrxH[i + tmpDiagDim * ij]));
                if (!(PrimitiveMath.MACHINE_EPSILON * t * t > 1.0)) continue;
                for (int j = i; j <= ij; ++j) {
                    aMtrxH[j + tmpDiagDim * (ij - 1)] = aMtrxH[j + tmpDiagDim * (ij - 1)] / t;
                    aMtrxH[j + tmpDiagDim * ij] = aMtrxH[j + tmpDiagDim * ij] / t;
                }
            }
        }
        for (int j = tmpDiagDimMinusOne; j >= 0; --j) {
            for (int i = 0; i <= tmpDiagDimMinusOne; ++i) {
                z = PrimitiveMath.ZERO;
                for (int k = 0; k <= j; ++k) {
                    z += aMtrxV[i + tmpDiagDim * k] * aMtrxH[k + tmpDiagDim * j];
                }
                aMtrxV[i + tmpDiagDim * j] = z;
            }
        }
    }

    static int doHessenberg(double[] aMtrxH, double[] aMtrxV) {
        int ij;
        int tmpDiagDim = (int)Math.sqrt(aMtrxH.length);
        int tmpDiagDimMinusTwo = tmpDiagDim - 2;
        double[] tmpWorkCopy = new double[tmpDiagDim];
        for (ij = 0; ij < tmpDiagDimMinusTwo; ++ij) {
            double f;
            double tmpColNorm1 = PrimitiveMath.ZERO;
            for (int i = ij + 1; i < tmpDiagDim; ++i) {
                tmpColNorm1 += Math.abs(aMtrxH[i + tmpDiagDim * ij]);
            }
            if (tmpColNorm1 == PrimitiveMath.ZERO) continue;
            double tmpInvBeta = PrimitiveMath.ZERO;
            for (int i = tmpDiagDim - 1; i >= ij + 1; --i) {
                tmpWorkCopy[i] = aMtrxH[i + tmpDiagDim * ij] / tmpColNorm1;
                tmpInvBeta += tmpWorkCopy[i] * tmpWorkCopy[i];
            }
            double g = Math.sqrt(tmpInvBeta);
            if (tmpWorkCopy[ij + 1] > 0.0) {
                g = -g;
            }
            tmpInvBeta -= tmpWorkCopy[ij + 1] * g;
            tmpWorkCopy[ij + 1] = tmpWorkCopy[ij + 1] - g;
            for (int j = ij + 1; j < tmpDiagDim; ++j) {
                int i;
                f = PrimitiveMath.ZERO;
                for (i = tmpDiagDim - 1; i >= ij + 1; --i) {
                    f += tmpWorkCopy[i] * aMtrxH[i + tmpDiagDim * j];
                }
                f /= tmpInvBeta;
                for (i = ij + 1; i <= tmpDiagDim - 1; ++i) {
                    int n = i + tmpDiagDim * j;
                    aMtrxH[n] = aMtrxH[n] - f * tmpWorkCopy[i];
                }
            }
            for (int i = 0; i < tmpDiagDim; ++i) {
                int j;
                f = PrimitiveMath.ZERO;
                for (j = tmpDiagDim - 1; j >= ij + 1; --j) {
                    f += tmpWorkCopy[j] * aMtrxH[i + tmpDiagDim * j];
                }
                f /= tmpInvBeta;
                for (j = ij + 1; j < tmpDiagDim; ++j) {
                    int n = i + tmpDiagDim * j;
                    aMtrxH[n] = aMtrxH[n] - f * tmpWorkCopy[j];
                }
            }
            tmpWorkCopy[ij + 1] = tmpColNorm1 * tmpWorkCopy[ij + 1];
            aMtrxH[ij + 1 + tmpDiagDim * ij] = tmpColNorm1 * g;
        }
        for (ij = tmpDiagDimMinusTwo; ij >= 1; --ij) {
            int tmpIndex = ij + tmpDiagDim * (ij - 1);
            if (aMtrxH[tmpIndex] == PrimitiveMath.ZERO) continue;
            for (int i = ij + 1; i <= tmpDiagDim - 1; ++i) {
                tmpWorkCopy[i] = aMtrxH[i + tmpDiagDim * (ij - 1)];
            }
            for (int j = ij; j <= tmpDiagDim - 1; ++j) {
                int i;
                double g = PrimitiveMath.ZERO;
                for (i = ij; i <= tmpDiagDim - 1; ++i) {
                    g += tmpWorkCopy[i] * aMtrxV[i + tmpDiagDim * j];
                }
                g = g / tmpWorkCopy[ij] / aMtrxH[tmpIndex];
                for (i = ij; i <= tmpDiagDim - 1; ++i) {
                    int n = i + tmpDiagDim * j;
                    aMtrxV[n] = aMtrxV[n] + g * tmpWorkCopy[i];
                }
            }
        }
        return tmpDiagDim;
    }

    static double[][] doSchur(double[] aMtrxH, double[] aMtrxV, boolean allTheWay) {
        int tmpDiagDim = (int)Math.sqrt(aMtrxH.length);
        int tmpDiagDimMinusOne = tmpDiagDim - 1;
        double tmpVal = PrimitiveMath.ZERO;
        for (int j = 0; j < tmpDiagDim; ++j) {
            for (int i = Math.min(j + 1, tmpDiagDim - 1); i >= 0; --i) {
                tmpVal += Math.abs(aMtrxH[i + tmpDiagDim * j]);
            }
        }
        double tmpNorm1 = tmpVal;
        double[] tmpMainDiagonal = new double[tmpDiagDim];
        double[] tmpOffDiagonal = new double[tmpDiagDim];
        double exshift = PrimitiveMath.ZERO;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        int tmpIterCount = 0;
        int tmpMainIterIndex = tmpDiagDimMinusOne;
        while (tmpMainIterIndex >= 0) {
            int m;
            int i;
            double x;
            double w;
            int l;
            for (l = tmpMainIterIndex; l > 0; --l) {
                s = Math.abs(aMtrxH[l - 1 + tmpDiagDim * (l - 1)]) + Math.abs(aMtrxH[l + tmpDiagDim * l]);
                if (s == PrimitiveMath.ZERO) {
                    s = tmpNorm1;
                }
                if (Math.abs(aMtrxH[l + tmpDiagDim * (l - 1)]) < PrimitiveMath.MACHINE_EPSILON * s) break;
            }
            if (l == tmpMainIterIndex) {
                aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] = aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] + exshift;
                tmpMainDiagonal[tmpMainIterIndex] = aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex];
                tmpOffDiagonal[tmpMainIterIndex] = PrimitiveMath.ZERO;
                --tmpMainIterIndex;
                tmpIterCount = 0;
                continue;
            }
            if (l == tmpMainIterIndex - 1) {
                w = aMtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)] * aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * tmpMainIterIndex];
                p = (aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)] - aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] = aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex] + exshift;
                aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)] = aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)] + exshift;
                x = aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    tmpMainDiagonal[tmpMainIterIndex - 1] = x + z;
                    tmpMainDiagonal[tmpMainIterIndex] = tmpMainDiagonal[tmpMainIterIndex - 1];
                    if (z != PrimitiveMath.ZERO) {
                        tmpMainDiagonal[tmpMainIterIndex] = x - w / z;
                    }
                    tmpOffDiagonal[tmpMainIterIndex - 1] = PrimitiveMath.ZERO;
                    tmpOffDiagonal[tmpMainIterIndex] = PrimitiveMath.ZERO;
                    x = aMtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j = tmpMainIterIndex - 1; j < tmpDiagDim; ++j) {
                        z = aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * j];
                        aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * j] = q * z + p * aMtrxH[tmpMainIterIndex + tmpDiagDim * j];
                        aMtrxH[tmpMainIterIndex + tmpDiagDim * j] = q * aMtrxH[tmpMainIterIndex + tmpDiagDim * j] - p * z;
                    }
                    for (i = 0; i <= tmpMainIterIndex; ++i) {
                        z = aMtrxH[i + tmpDiagDim * (tmpMainIterIndex - 1)];
                        aMtrxH[i + tmpDiagDim * (tmpMainIterIndex - 1)] = q * z + p * aMtrxH[i + tmpDiagDim * tmpMainIterIndex];
                        aMtrxH[i + tmpDiagDim * tmpMainIterIndex] = q * aMtrxH[i + tmpDiagDim * tmpMainIterIndex] - p * z;
                    }
                    for (i = 0; i <= tmpDiagDimMinusOne; ++i) {
                        z = aMtrxV[i + tmpDiagDim * (tmpMainIterIndex - 1)];
                        aMtrxV[i + tmpDiagDim * (tmpMainIterIndex - 1)] = q * z + p * aMtrxV[i + tmpDiagDim * tmpMainIterIndex];
                        aMtrxV[i + tmpDiagDim * tmpMainIterIndex] = q * aMtrxV[i + tmpDiagDim * tmpMainIterIndex] - p * z;
                    }
                } else {
                    tmpMainDiagonal[tmpMainIterIndex - 1] = x + p;
                    tmpMainDiagonal[tmpMainIterIndex] = x + p;
                    tmpOffDiagonal[tmpMainIterIndex - 1] = z;
                    tmpOffDiagonal[tmpMainIterIndex] = -z;
                }
                tmpMainIterIndex -= 2;
                tmpIterCount = 0;
                continue;
            }
            x = aMtrxH[tmpMainIterIndex + tmpDiagDim * tmpMainIterIndex];
            double y = PrimitiveMath.ZERO;
            w = PrimitiveMath.ZERO;
            if (l < tmpMainIterIndex) {
                y = aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 1)];
                w = aMtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)] * aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * tmpMainIterIndex];
            }
            if (tmpIterCount == 10) {
                exshift += x;
                for (i = 0; i <= tmpMainIterIndex; ++i) {
                    int n = i + tmpDiagDim * i;
                    aMtrxH[n] = aMtrxH[n] - x;
                }
                s = Math.abs(aMtrxH[tmpMainIterIndex + tmpDiagDim * (tmpMainIterIndex - 1)]) + Math.abs(aMtrxH[tmpMainIterIndex - 1 + tmpDiagDim * (tmpMainIterIndex - 2)]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (tmpIterCount == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    for (i = 0; i <= tmpMainIterIndex; ++i) {
                        int n = i + tmpDiagDim * i;
                        aMtrxH[n] = aMtrxH[n] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++tmpIterCount;
            for (m = tmpMainIterIndex - 2; m >= l; --m) {
                z = aMtrxH[m + tmpDiagDim * m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / aMtrxH[m + 1 + tmpDiagDim * m] + aMtrxH[m + tmpDiagDim * (m + 1)];
                q = aMtrxH[m + 1 + tmpDiagDim * (m + 1)] - z - r - s;
                r = aMtrxH[m + 2 + tmpDiagDim * (m + 1)];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(aMtrxH[m + tmpDiagDim * (m - 1)]) * (Math.abs(q /= s) + Math.abs(r /= s)) < PrimitiveMath.MACHINE_EPSILON * (Math.abs(p /= s) * (Math.abs(aMtrxH[m - 1 + tmpDiagDim * (m - 1)]) + Math.abs(z) + Math.abs(aMtrxH[m + 1 + tmpDiagDim * (m + 1)])))) break;
            }
            for (int i2 = m + 2; i2 <= tmpMainIterIndex; ++i2) {
                aMtrxH[i2 + tmpDiagDim * (i2 - 2)] = PrimitiveMath.ZERO;
                if (i2 <= m + 2) continue;
                aMtrxH[i2 + tmpDiagDim * (i2 - 3)] = PrimitiveMath.ZERO;
            }
            for (int k = m; k <= tmpMainIterIndex - 1; ++k) {
                int i3;
                boolean notlast;
                boolean bl = notlast = k != tmpMainIterIndex - 1;
                if (k != m) {
                    p = aMtrxH[k + tmpDiagDim * (k - 1)];
                    q = aMtrxH[k + 1 + tmpDiagDim * (k - 1)];
                    r = notlast ? aMtrxH[k + 2 + tmpDiagDim * (k - 1)] : PrimitiveMath.ZERO;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x == PrimitiveMath.ZERO) continue;
                    p /= x;
                    q /= x;
                    r /= x;
                }
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    aMtrxH[k + tmpDiagDim * (k - 1)] = -s * x;
                } else if (l != m) {
                    aMtrxH[k + tmpDiagDim * (k - 1)] = -aMtrxH[k + tmpDiagDim * (k - 1)];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j = k; j < tmpDiagDim; ++j) {
                    p = aMtrxH[k + tmpDiagDim * j] + q * aMtrxH[k + 1 + tmpDiagDim * j];
                    if (notlast) {
                        aMtrxH[k + 2 + tmpDiagDim * j] = aMtrxH[k + 2 + tmpDiagDim * j] - (p += r * aMtrxH[k + 2 + tmpDiagDim * j]) * z;
                    }
                    aMtrxH[k + tmpDiagDim * j] = aMtrxH[k + tmpDiagDim * j] - p * x;
                    aMtrxH[k + 1 + tmpDiagDim * j] = aMtrxH[k + 1 + tmpDiagDim * j] - p * y;
                }
                for (i3 = 0; i3 <= Math.min(tmpMainIterIndex, k + 3); ++i3) {
                    p = x * aMtrxH[i3 + tmpDiagDim * k] + y * aMtrxH[i3 + tmpDiagDim * (k + 1)];
                    if (notlast) {
                        aMtrxH[i3 + tmpDiagDim * (k + 2)] = aMtrxH[i3 + tmpDiagDim * (k + 2)] - (p += z * aMtrxH[i3 + tmpDiagDim * (k + 2)]) * r;
                    }
                    aMtrxH[i3 + tmpDiagDim * k] = aMtrxH[i3 + tmpDiagDim * k] - p;
                    aMtrxH[i3 + tmpDiagDim * (k + 1)] = aMtrxH[i3 + tmpDiagDim * (k + 1)] - p * q;
                }
                for (i3 = 0; i3 <= tmpDiagDimMinusOne; ++i3) {
                    p = x * aMtrxV[i3 + tmpDiagDim * k] + y * aMtrxV[i3 + tmpDiagDim * (k + 1)];
                    if (notlast) {
                        aMtrxV[i3 + tmpDiagDim * (k + 2)] = aMtrxV[i3 + tmpDiagDim * (k + 2)] - (p += z * aMtrxV[i3 + tmpDiagDim * (k + 2)]) * r;
                    }
                    aMtrxV[i3 + tmpDiagDim * k] = aMtrxV[i3 + tmpDiagDim * k] - p;
                    aMtrxV[i3 + tmpDiagDim * (k + 1)] = aMtrxV[i3 + tmpDiagDim * (k + 1)] - p * q;
                }
            }
        }
        if (allTheWay && tmpNorm1 != PrimitiveMath.ZERO) {
            PrimitiveDenseStore.doAfter(aMtrxH, aMtrxV, tmpMainDiagonal, tmpOffDiagonal, r, s, z, tmpNorm1);
        }
        return new double[][]{tmpMainDiagonal, tmpOffDiagonal};
    }

    PrimitiveDenseStore(double[] anArray) {
        super(anArray);
        this.myRowDim = anArray.length;
        this.myColDim = 1;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getPrimitive(this.myRowDim, this.myColDim);
    }

    PrimitiveDenseStore(int aLength) {
        super(aLength);
        this.myRowDim = aLength;
        this.myColDim = 1;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getPrimitive(this.myRowDim, this.myColDim);
    }

    PrimitiveDenseStore(int aRowDim, int aColDim) {
        super(aRowDim * aColDim);
        this.myRowDim = aRowDim;
        this.myColDim = aColDim;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getPrimitive(this.myRowDim, this.myColDim);
    }

    PrimitiveDenseStore(int aRowDim, int aColDim, double[] anArray) {
        super(anArray);
        this.myRowDim = aRowDim;
        this.myColDim = aColDim;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getPrimitive(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getPrimitive(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<Double> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, supplied.doubleValue(i, j));
            }
        }
    }

    @Override
    public void add(long row, long column, double addend) {
        this.myUtility.add(row, column, addend);
    }

    @Override
    public void add(long row, long column, Number addend) {
        this.myUtility.add(row, column, addend);
    }

    @Override
    public Double aggregateAll(final Aggregator aggregator) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        final AggregatorFunction<Double> tmpMainAggr = aggregator.getPrimitiveFunction();
        if (tmpColDim > AggregateAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void conquer(int first, int limit) {
                    AggregatorFunction<Double> tmpPartAggr = aggregator.getPrimitiveFunction();
                    PrimitiveDenseStore.this.visit(tmpRowDim * first, tmpRowDim * limit, 1, tmpPartAggr);
                    AggregatorFunction aggregatorFunction = tmpMainAggr;
                    synchronized (aggregatorFunction) {
                        tmpMainAggr.merge(tmpPartAggr.getNumber());
                    }
                }
            };
            tmpConquerer.invoke(0, tmpColDim, AggregateAll.THRESHOLD);
        } else {
            this.visit(0, this.size(), 1, (VoidFunction<Double>)tmpMainAggr);
        }
        return tmpMainAggr.getNumber();
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((PrimitiveArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyCholesky.invoke(tmpData, PrimitiveDenseStore.this.myRowDim, first, limit, tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((PrimitiveArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke(tmpData, PrimitiveDenseStore.this.myRowDim, first, limit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((PrimitiveArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLU.invoke(tmpData, PrimitiveDenseStore.this.myRowDim, first, limit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public Array2D<Double> asArray2D() {
        return this.myUtility;
    }

    @Override
    public Array1D<Double> asList() {
        return this.myUtility.asArray1D();
    }

    @Override
    public final MatrixStore.Builder<Double> builder() {
        return new MatrixStore.Builder<Double>(this);
    }

    @Override
    public void caxpy(double aSclrA, int aColX, int aColY, int aFirstRow) {
        AXPY.invoke(this.data, aColY * this.myRowDim + aFirstRow, 1, aSclrA, this.data, aColX * this.myRowDim + aFirstRow, 1, this.myRowDim - aFirstRow);
    }

    @Override
    public void caxpy(Double scalarA, int columnX, int columnY, int firstRow) {
        AXPY.invoke(this.data, columnY * this.myRowDim + firstRow, 1, scalarA, this.data, columnX * this.myRowDim + firstRow, 1, this.myRowDim - firstRow);
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<Double> transformationCollector, boolean eigenvalue) {
        double[] tmpData = this.data;
        double[] tmpCollectorData = ((PrimitiveDenseStore)transformationCollector).data;
        PrimitiveDenseStore.doHessenberg(tmpData, tmpCollectorData);
        double[][] tmpDiags = PrimitiveDenseStore.doSchur(tmpData, tmpCollectorData, eigenvalue);
        double[] aRawReal = tmpDiags[0];
        double[] aRawImag = tmpDiags[1];
        int tmpLength = Math.min(aRawReal.length, aRawImag.length);
        ComplexArray retVal = ComplexArray.make(tmpLength);
        ComplexNumber[] tmpRaw = (ComplexNumber[])retVal.data;
        for (int i = 0; i < tmpLength; ++i) {
            tmpRaw[i] = ComplexNumber.of(aRawReal[i], aRawImag[i]);
        }
        return Array1D.COMPLEX.wrap(retVal);
    }

    @Override
    public MatrixStore<Double> conjugate() {
        return this.transpose();
    }

    public PrimitiveDenseStore copy() {
        return new PrimitiveDenseStore(this.myRowDim, this.myColDim, this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<Double> destination) {
        double[] tmpData = this.data;
        int tmpRowDim = this.myRowDim;
        double[] tmpDestination = ((PrimitiveArray)destination).data;
        int tmpIndex = row + column * tmpRowDim;
        double tmpDenominator = tmpData[tmpIndex];
        for (int i = row + 1; i < tmpRowDim; ++i) {
            int n = ++tmpIndex;
            double d = tmpData[n] / tmpDenominator;
            tmpData[n] = d;
            tmpDestination[i] = d;
        }
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myUtility.doubleValue(aRow, aCol);
    }

    @Override
    public boolean equals(MatrixStore<Double> other, NumberContext context) {
        return AccessUtils.equals(this, other, context);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof MatrixStore) {
            return this.equals((MatrixStore)anObj, NumberContext.getGeneral(6));
        }
        return super.equals(anObj);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        double tmpVal;
        int tmpMin = Math.min(indexA, indexB);
        int tmpMax = Math.max(indexA, indexB);
        for (int j = 0; j < tmpMin; ++j) {
            tmpVal = this.doubleValue(tmpMin, j);
            this.set((long)tmpMin, (long)j, this.doubleValue(tmpMax, j));
            this.set((long)tmpMax, (long)j, tmpVal);
        }
        tmpVal = this.doubleValue(tmpMin, tmpMin);
        this.set((long)tmpMin, (long)tmpMin, this.doubleValue(tmpMax, tmpMax));
        this.set((long)tmpMax, (long)tmpMax, tmpVal);
        for (int ij = tmpMin + 1; ij < tmpMax; ++ij) {
            tmpVal = this.doubleValue(ij, tmpMin);
            this.set((long)ij, (long)tmpMin, this.doubleValue(tmpMax, ij));
            this.set((long)tmpMax, (long)ij, tmpVal);
        }
        for (int i = tmpMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.doubleValue(i, tmpMin);
            this.set((long)i, (long)tmpMin, this.doubleValue(i, tmpMax));
            this.set((long)i, (long)tmpMax, tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public PhysicalStore.Factory<Double, PrimitiveDenseStore> factory() {
        return FACTORY;
    }

    @Override
    public void fillByMultiplying(Access1D<Double> left, Access1D<Double> right) {
        int tmpComplexity = (int)left.count() / this.myRowDim;
        if (right instanceof PrimitiveDenseStore) {
            this.multiplyLeft.invoke(this.data, left, tmpComplexity, PrimitiveDenseStore.cast(right).data);
        } else if (left instanceof PrimitiveDenseStore) {
            this.multiplyRight.invoke(this.data, PrimitiveDenseStore.cast(left).data, tmpComplexity, right);
        } else {
            this.multiplyBoth.invoke(this, left, tmpComplexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long column, Access1D<Double> values) {
        long tmpOffset = row + column * (long)this.myRowDim;
        long tmpCount = values.count();
        for (long i = 0L; i < tmpCount; ++i) {
            this.set(tmpOffset + i, values.doubleValue(i));
        }
    }

    @Override
    public void fillColumn(long row, long column, Double value) {
        this.myUtility.fillColumn(row, column, value);
    }

    @Override
    public void fillColumn(long row, long column, NullaryFunction<Double> supplier) {
        this.myUtility.fillColumn(row, column, supplier);
    }

    @Override
    public void fillDiagonal(long row, long column, Double value) {
        this.myUtility.fillDiagonal(row, column, value);
    }

    @Override
    public void fillDiagonal(long row, long column, NullaryFunction<Double> supplier) {
        this.myUtility.fillDiagonal(row, column, supplier);
    }

    public void fillMatching(final Access1D<Double> left, final BinaryFunction<Double> function, final Double right) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > FillMatchingLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    PrimitiveDenseStore.this.fill(tmpRowDim * first, tmpRowDim * limit, (Access1D<Double>)left, (BinaryFunction<Double>)function, right);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, FillMatchingLeft.THRESHOLD);
        } else {
            this.fill(0, tmpRowDim * tmpColDim, left, function, right);
        }
    }

    public void fillMatching(final Double left, final BinaryFunction<Double> function, final Access1D<Double> right) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > FillMatchingRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    PrimitiveDenseStore.this.fill(tmpRowDim * first, tmpRowDim * limit, left, (BinaryFunction<Double>)function, (Access1D<Double>)right);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, FillMatchingRight.THRESHOLD);
        } else {
            this.fill(0, tmpRowDim * tmpColDim, left, function, right);
        }
    }

    @Override
    public void fillOne(long row, long column, Double value) {
        this.myUtility.fillOne(row, column, value);
    }

    @Override
    public void fillOne(long row, long column, NullaryFunction<Double> supplier) {
        this.myUtility.fillOne(row, column, supplier);
    }

    @Override
    public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
        this.set(row, column, values.doubleValue(valueIndex));
    }

    @Override
    public void fillRow(long row, long column, Double value) {
        this.myUtility.fillRow(row, column, value);
    }

    @Override
    public void fillRow(long row, long column, NullaryFunction<Double> supplier) {
        this.myUtility.fillRow(row, column, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<Double> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke(this.data, this.myRowDim, row, column, (Householder.Primitive)destination);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<Double> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke(this.data, this.myRowDim, row, column, (Householder.Primitive)destination);
    }

    @Override
    public final MatrixStore<Double> get() {
        return this;
    }

    @Override
    public Double get(long aRow, long aCol) {
        return this.myUtility.get(aRow, aCol);
    }

    @Override
    public int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public int indexOfLargestInColumn(int row, int column) {
        return (int)this.myUtility.indexOfLargestInColumn(row, column);
    }

    @Override
    public long indexOfLargestInColumn(long row, long column) {
        return this.myUtility.indexOfLargestInColumn(row, column);
    }

    @Override
    public int indexOfLargestInDiagonal(int row, int column) {
        return (int)this.myUtility.indexOfLargestInDiagonal(row, column);
    }

    @Override
    public long indexOfLargestInDiagonal(long row, long column) {
        return this.myUtility.indexOfLargestInDiagonal(row, column);
    }

    @Override
    public long indexOfLargestInRow(long row, long column) {
        return this.myUtility.indexOfLargestInRow(row, column);
    }

    @Override
    public boolean isAbsolute(long row, long column) {
        return this.myUtility.isAbsolute(row, column);
    }

    @Override
    public boolean isSmall(long row, long column, double comparedTo) {
        return this.myUtility.isSmall(row, column, comparedTo);
    }

    @Override
    public boolean isZero(long row, long column) {
        return this.myUtility.isZero(row, column);
    }

    @Override
    public void maxpy(final Double aSclrA, final MatrixStore<Double> aMtrxX) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > MAXPY.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    MAXPY.invoke(PrimitiveDenseStore.this.data, tmpRowDim, first, limit, aSclrA, aMtrxX);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, MAXPY.THRESHOLD);
        } else {
            MAXPY.invoke(this.data, tmpRowDim, 0, tmpColDim, aSclrA, aMtrxX);
        }
    }

    @Override
    public void modifyAll(final UnaryFunction<Double> function) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > ModifyAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    PrimitiveDenseStore.this.modify(tmpRowDim * first, tmpRowDim * limit, 1, function);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, ModifyAll.THRESHOLD);
        } else {
            this.modify(tmpRowDim * 0, tmpRowDim * tmpColDim, 1, function);
        }
    }

    @Override
    public void modifyColumn(long row, long column, UnaryFunction<Double> function) {
        this.myUtility.modifyColumn(row, column, function);
    }

    @Override
    public void modifyDiagonal(long row, long column, UnaryFunction<Double> function) {
        this.myUtility.modifyDiagonal(row, column, function);
    }

    @Override
    public void modifyOne(long row, long column, UnaryFunction<Double> function) {
        double tmpValue = this.doubleValue(row, column);
        tmpValue = function.invoke(tmpValue);
        this.set(row, column, tmpValue);
    }

    @Override
    public void modifyRow(long row, long column, UnaryFunction<Double> function) {
        this.myUtility.modifyRow(row, column, function);
    }

    @Override
    public MatrixStore<Double> multiply(Access1D<Double> right) {
        PrimitiveDenseStore retVal = (PrimitiveDenseStore)FACTORY.makeZero(this.myRowDim, right.count() / (long)this.myColDim);
        if (right instanceof PrimitiveDenseStore) {
            retVal.multiplyLeft.invoke(retVal.data, this, this.myColDim, ((PrimitiveDenseStore)right).data);
        } else {
            retVal.multiplyRight.invoke(retVal.data, this.data, this.myColDim, right);
        }
        return retVal;
    }

    @Override
    public Double multiplyBoth(Access1D<Double> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.makeZero(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (Double)tmpStep2.get(0L);
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, PrimitiveFunction.NEGATE);
    }

    @Override
    public void raxpy(Double scalarA, int rowX, int rowY, int firstColumn) {
        AXPY.invoke(this.data, rowY + firstColumn * (this.data.length / this.myColDim), this.data.length / this.myColDim, scalarA, this.data, rowX + firstColumn * (this.data.length / this.myColDim), this.data.length / this.myColDim, this.myColDim - firstColumn);
    }

    @Override
    public final ElementsConsumer<Double> regionByColumns(int ... columns) {
        return new PhysicalStore.ColumnsRegion<Double>(this, this.multiplyBoth, columns);
    }

    @Override
    public final ElementsConsumer<Double> regionByLimits(int rowLimit, int columnLimit) {
        return new PhysicalStore.LimitRegion<Double>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public final ElementsConsumer<Double> regionByOffsets(int rowOffset, int columnOffset) {
        return new PhysicalStore.OffsetRegion<Double>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public final ElementsConsumer<Double> regionByRows(int ... rows) {
        return new PhysicalStore.RowsRegion<Double>(this, this.multiplyBoth, rows);
    }

    @Override
    public final ElementsConsumer<Double> regionByTransposing() {
        return new PhysicalStore.TransposedRegion<Double>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int aLow, int aHigh, double aCos, double aSin) {
        RotateRight.invoke(this.data, this.myRowDim, aLow, aHigh, aCos, aSin);
    }

    @Override
    public void set(long aRow, long aCol, double aNmbr) {
        this.myUtility.set(aRow, aCol, aNmbr);
    }

    @Override
    public void set(long aRow, long aCol, Number aNmbr) {
        this.myUtility.set(aRow, aCol, aNmbr);
    }

    @Override
    public void setToIdentity(int aCol) {
        this.myUtility.set((long)aCol, (long)aCol, PrimitiveMath.ONE);
        this.myUtility.fillColumn((long)(aCol + 1), (long)aCol, PrimitiveMath.ZERO);
    }

    @Override
    public Array1D<Double> sliceColumn(long row, long column) {
        return this.myUtility.sliceColumn(row, column);
    }

    @Override
    public Array1D<Double> sliceDiagonal(long row, long column) {
        return this.myUtility.sliceDiagonal(row, column);
    }

    @Override
    public Array1D<Double> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<Double> sliceRow(long row, long column) {
        return this.myUtility.sliceRow(row, column);
    }

    @Override
    public void substituteBackwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteBackwards.invoke(PrimitiveDenseStore.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, hermitian);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, hermitian);
        }
    }

    @Override
    public void substituteForwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteForwards.invoke(PrimitiveDenseStore.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, identity);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, identity);
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<Double> consumer) {
        consumer.fillMatching(this);
    }

    public PrimitiveScalar toScalar(long row, long column) {
        return PrimitiveScalar.of(this.doubleValue(row, column));
    }

    @Override
    public final String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public void transformLeft(Householder<Double> transformation, int firstColumn) {
        final Householder.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        final double[] tmpData = this.data;
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim - firstColumn > HouseholderLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    HouseholderLeft.invoke(tmpData, tmpRowDim, first, limit, tmpTransf);
                }
            };
            tmpConquerer.invoke(firstColumn, tmpColDim, HouseholderLeft.THRESHOLD);
        } else {
            HouseholderLeft.invoke(tmpData, tmpRowDim, firstColumn, tmpColDim, tmpTransf);
        }
    }

    @Override
    public void transformLeft(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateLeft.invoke(this.data, this.myColDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveFunction.MULTIPLY.second((Double)tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveFunction.DIVIDE.second((Double)tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveFunction.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<Double> transformation, int firstRow) {
        final Householder.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        final double[] tmpData = this.data;
        final int tmpRowDim = this.myRowDim;
        final int tmpColDim = this.myColDim;
        final double[] tmpWorker = this.getWorkerColumn();
        if (tmpRowDim - firstRow > HouseholderRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    HouseholderRight.invoke(tmpData, tmpRowDim, first, limit, tmpColDim, tmpTransf, tmpWorker);
                }
            };
            tmpConquerer.invoke(firstRow, tmpRowDim, HouseholderRight.THRESHOLD);
        } else {
            HouseholderRight.invoke(tmpData, tmpRowDim, firstRow, tmpRowDim, tmpColDim, tmpTransf, tmpWorker);
        }
    }

    @Override
    public void transformRight(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = PrimitiveDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateRight.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveFunction.MULTIPLY.second((Double)tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveFunction.DIVIDE.second((Double)tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveFunction.NEGATE);
        }
    }

    @Override
    public void transformSymmetric(Householder<Double> transformation) {
        HouseholderHermitian.invoke(this.data, PrimitiveDenseStore.cast(transformation), new double[(int)transformation.count()]);
    }

    @Override
    public MatrixStore<Double> transpose() {
        return new TransposedStore<Double>(this);
    }

    @Override
    public void tred2(BasicArray<Double> mainDiagonal, BasicArray<Double> offDiagonal, boolean yesvecs) {
        HouseholderHermitian.tred2j(this.data, ((PrimitiveArray)mainDiagonal).data, ((PrimitiveArray)offDiagonal).data, yesvecs);
    }

    @Override
    public void visitAll(VoidFunction<Double> visitor) {
        this.myUtility.visitAll(visitor);
    }

    @Override
    public void visitColumn(long row, long column, VoidFunction<Double> visitor) {
        this.myUtility.visitColumn(row, column, visitor);
    }

    @Override
    public void visitDiagonal(long row, long column, VoidFunction<Double> visitor) {
        this.myUtility.visitDiagonal(row, column, visitor);
    }

    @Override
    public void visitRow(long row, long column, VoidFunction<Double> visitor) {
        this.myUtility.visitRow(row, column, visitor);
    }

    int getColDim() {
        return this.myColDim;
    }

    int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    int getRowDim() {
        return this.myRowDim;
    }

    double[] getWorkerColumn() {
        if (this.myWorkerColumn != null) {
            Arrays.fill(this.myWorkerColumn, PrimitiveMath.ZERO);
        } else {
            this.myWorkerColumn = new double[this.myRowDim];
        }
        return this.myWorkerColumn;
    }

    public static interface PrimitiveMultiplyRight {
        public void invoke(double[] var1, double[] var2, int var3, Access1D<?> var4);
    }

    public static interface PrimitiveMultiplyLeft {
        public void invoke(double[] var1, Access1D<?> var2, int var3, double[] var4);
    }

    public static interface PrimitiveMultiplyBoth
    extends PhysicalStore.FillByMultiplying<Double> {
    }
}

