/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;
import org.ojalgo.scalar.Scalar;

final class RowsStore<N extends Number>
extends SelectingStore<N> {
    private final int myFirst;
    private final int[] myRows;

    private RowsStore(MatrixStore<N> aBase) {
        this(aBase, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    RowsStore(int aFirst, int aLimit, MatrixStore<N> aBase) {
        super(aLimit - aFirst, (int)aBase.countColumns(), aBase);
        this.myRows = null;
        this.myFirst = aFirst;
    }

    RowsStore(MatrixStore<N> aBase, int ... someRows) {
        super(someRows.length, (int)aBase.countColumns(), aBase);
        this.myRows = someRows;
        this.myFirst = 0;
    }

    @Override
    public double doubleValue(long row, long column) {
        if (this.myRows != null) {
            return this.getBase().doubleValue(this.myRows[(int)row], column);
        }
        return this.getBase().doubleValue((long)this.myFirst + row, column);
    }

    @Override
    public N get(long row, long column) {
        if (this.myRows != null) {
            return this.getBase().get(this.myRows[(int)row], column);
        }
        return this.getBase().get((long)this.myFirst + row, column);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        if (this.myRows != null) {
            return this.getBase().toScalar(this.myRows[(int)row], column);
        }
        return this.getBase().toScalar((long)this.myFirst + row, column);
    }
}

