/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.ContextSupplier;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;

final class UnaryOperatorSupplier<N extends Number>
extends ContextSupplier<N> {
    private final MatrixStore<N> myArguments;
    private final UnaryFunction<N> myFunction;

    private UnaryOperatorSupplier(MatrixStore<N> context) {
        super(context);
        this.myFunction = null;
        this.myArguments = null;
    }

    UnaryOperatorSupplier(UnaryFunction<N> function, MatrixStore<N> arguments) {
        super(arguments);
        this.myFunction = function;
        this.myArguments = arguments;
    }

    @Override
    public long count() {
        return this.myArguments.count();
    }

    @Override
    public long countColumns() {
        return this.myArguments.countColumns();
    }

    @Override
    public long countRows() {
        return this.myArguments.countRows();
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        consumer.fillMatching(this.myFunction, this.myArguments);
    }
}

