/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.BLAS1;
import org.ojalgo.scalar.ComplexNumber;

public abstract class AXPY
implements BLAS1 {
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] vectorY, int offsetY, int stepY, BigDecimal scalar, BigDecimal[] vectorX, int offsetX, int stepX, int count) {
        for (int i = 0; i < count; ++i) {
            vectorY[offsetY + i * stepY] = BigFunction.ADD.invoke(BigFunction.MULTIPLY.invoke(scalar, vectorX[offsetX + i * stepX]), vectorY[offsetY + i * stepY]);
        }
    }

    public static void invoke(ComplexNumber[] vectorY, int offsetY, int stepY, ComplexNumber scalar, ComplexNumber[] vectorX, int offsetX, int stepX, int count) {
        for (int i = 0; i < count; ++i) {
            vectorY[offsetY + i * stepY] = scalar.multiply(vectorX[offsetX + i * stepX]).add(vectorY[offsetY + i * stepY]);
        }
    }

    public static void invoke(double[] vectorY, int offsetY, int stepY, double scalar, double[] vectorX, int offsetX, int stepX, int count) {
        for (int i = 0; i < count; ++i) {
            int n = offsetY + i * stepY;
            vectorY[n] = vectorY[n] + scalar * vectorX[offsetX + i * stepX];
        }
    }
}

