/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class MAXPY
extends MatrixOperation {
    public static final MAXPY SETUP = new MAXPY();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] aData, int aRowDim, int aFirstCol, int aColLimit, BigDecimal aScale, MatrixStore<BigDecimal> aStore) {
        int tmpIndex = aRowDim * aFirstCol;
        for (int j = aFirstCol; j < aColLimit; ++j) {
            for (int i = 0; i < aRowDim; ++i) {
                aData[tmpIndex] = BigFunction.ADD.invoke(BigFunction.MULTIPLY.invoke(aScale, (BigDecimal)aStore.get(i, j)), aData[tmpIndex]);
                ++tmpIndex;
            }
        }
    }

    public static void invoke(ComplexNumber[] aData, int aRowDim, int aFirstCol, int aColLimit, ComplexNumber aScale, MatrixStore<ComplexNumber> aStore) {
        int tmpIndex = aRowDim * aFirstCol;
        for (int j = aFirstCol; j < aColLimit; ++j) {
            for (int i = 0; i < aRowDim; ++i) {
                aData[tmpIndex] = aScale.multiply((ComplexNumber)aStore.get(i, j)).add(aData[tmpIndex]);
                ++tmpIndex;
            }
        }
    }

    public static void invoke(double[] aData, int aRowDim, int aFirstCol, int aColLimit, double aScale, MatrixStore<Double> aStore) {
        int tmpIndex = aRowDim * aFirstCol;
        for (int j = aFirstCol; j < aColLimit; ++j) {
            for (int i = 0; i < aRowDim; ++i) {
                int n = tmpIndex++;
                aData[n] = aData[n] + aScale * aStore.doubleValue(i, j);
            }
        }
    }

    private MAXPY() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

