/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import org.ojalgo.access.Access1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.optimisation.AbstractModel;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.context.NumberContext;

public final class MathProgSysModel
extends AbstractModel<GenericSolver> {
    private static final String COMMENT = "*";
    private static final String EMPTY = "";
    private static final int[] FIELD_LIMITS = new int[]{3, 12, 22, 36, 47, 61};
    private static final String SPACE = " ";
    private final HashMap<String, Column> myColumns = new HashMap();
    private final ExpressionsBasedModel myDelegate;
    private final String[] myFields = new String[6];
    private boolean myIntegerMarker = false;
    private String myName;
    private final HashMap<String, Row> myRows = new HashMap();

    public static MathProgSysModel make(File file) {
        MathProgSysModel retVal = new MathProgSysModel();
        FileSection tmpSection = null;
        try {
            String tmpLine;
            BufferedReader tmpBufferedFileReader = new BufferedReader(new FileReader(file));
            while ((tmpLine = tmpBufferedFileReader.readLine()) != null) {
                if (tmpLine.length() == 0 || tmpLine.startsWith(COMMENT)) continue;
                if (tmpLine.startsWith(SPACE)) {
                    retVal.parseSectionLine(tmpSection, tmpLine);
                    continue;
                }
                tmpSection = retVal.identifySection(tmpLine);
            }
            tmpBufferedFileReader.close();
        }
        catch (FileNotFoundException anException) {
            anException.printStackTrace();
        }
        catch (IOException anException) {
            anException.printStackTrace();
        }
        return retVal;
    }

    MathProgSysModel() {
        this.myDelegate = new ExpressionsBasedModel(this.options);
        this.setMinimisation();
    }

    @Override
    public void dispose() {
        this.myDelegate.dispose();
        this.myRows.clear();
        this.myColumns.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MathProgSysModel)) {
            return false;
        }
        MathProgSysModel other = (MathProgSysModel)obj;
        return !(this.myDelegate == null ? other.myDelegate != null : !this.myDelegate.equals(other.myDelegate));
    }

    public ExpressionsBasedModel getExpressionsBasedModel() {
        return this.myDelegate;
    }

    public String getName() {
        return this.myName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDelegate == null ? 0 : this.myDelegate.hashCode());
        return result;
    }

    @Override
    public Optimisation.Result maximise() {
        return this.myDelegate.maximise();
    }

    @Override
    public Optimisation.Result minimise() {
        return this.myDelegate.minimise();
    }

    public Optimisation.Result solve() {
        if (this.isMaximisation()) {
            return this.myDelegate.maximise();
        }
        return this.myDelegate.minimise();
    }

    public String toString() {
        return this.myDelegate.toString();
    }

    @Override
    public boolean validate() {
        return this.myDelegate.validate();
    }

    public boolean validate(Access1D<BigDecimal> solution, NumberContext context) {
        return this.myDelegate.validate(solution, context);
    }

    private void extractFields(String line) {
        int tmpFirst;
        int tmpLength = line.length();
        int tmpLimit = tmpFirst = 0;
        for (int i = 0; i < this.myFields.length; ++i) {
            tmpLimit = Math.min(FIELD_LIMITS[i], tmpLength);
            this.myFields[i] = line.substring(tmpFirst, tmpLimit).trim();
            tmpFirst = tmpLimit;
        }
    }

    FileSection identifySection(String line) {
        String tmpArgument;
        String tmpSection;
        int tmpSplit = line.indexOf(SPACE);
        if (tmpSplit != -1) {
            tmpSection = line.substring(0, tmpSplit).trim();
            tmpArgument = line.substring(tmpSplit).trim();
        } else {
            tmpSection = line.trim();
            tmpArgument = EMPTY;
        }
        FileSection retVal = FileSection.valueOf(tmpSection);
        switch (retVal) {
            case NAME: {
                this.myName = tmpArgument;
                break;
            }
        }
        return retVal;
    }

    void parseSectionLine(FileSection section, String line) {
        this.extractFields(line);
        switch (section) {
            case NAME: {
                break;
            }
            case OBJSENSE: {
                if (this.myFields[0].equals("MAX")) {
                    this.setMaximisation();
                    break;
                }
                this.setMinimisation();
                break;
            }
            case OBJNAME: {
                break;
            }
            case ROWS: {
                Row tmpRow = new Row(this.myFields[1], RowType.valueOf(this.myFields[0]));
                this.myRows.put(this.myFields[1], tmpRow);
                break;
            }
            case COLUMNS: {
                if (this.myFields[2].indexOf("MARKER") != -1) {
                    if (this.myFields[4].indexOf("INTORG") != -1) {
                        this.myIntegerMarker = true;
                        break;
                    }
                    if (this.myFields[4].indexOf("INTEND") == -1) break;
                    this.myIntegerMarker = false;
                    break;
                }
                if (!this.myColumns.containsKey(this.myFields[1])) {
                    this.myColumns.put(this.myFields[1], new Column(this.myFields[1]));
                }
                Column tmpColumn = this.myColumns.get(this.myFields[1]);
                tmpColumn.setRowValue(this.myFields[2], new BigDecimal(this.myFields[3]));
                if (this.myFields[4].length() != 0) {
                    tmpColumn.setRowValue(this.myFields[4], new BigDecimal(this.myFields[5]));
                }
                if (!this.myIntegerMarker) break;
                tmpColumn.integer(this.myIntegerMarker);
                break;
            }
            case RHS: {
                this.myRows.get(this.myFields[2]).rhs(new BigDecimal(this.myFields[3]));
                if (this.myFields[4].length() == 0) break;
                this.myRows.get(this.myFields[4]).rhs(new BigDecimal(this.myFields[5]));
                break;
            }
            case RANGES: {
                this.myRows.get(this.myFields[2]).range(new BigDecimal(this.myFields[3]));
                if (this.myFields[4].length() == 0) break;
                this.myRows.get(this.myFields[4]).range(new BigDecimal(this.myFields[5]));
                break;
            }
            case BOUNDS: {
                this.myColumns.get(this.myFields[2]).bound(BoundType.valueOf(this.myFields[0]), this.myFields[3].length() == 0 ? null : new BigDecimal(this.myFields[3]));
                break;
            }
            case ENDATA: {
                break;
            }
        }
    }

    static enum RowType {
        E,
        G,
        L,
        N;

    }

    final class Row {
        private final Expression myExpression;
        private final RowType myType;

        Row(String name, RowType rowType) {
            this.myExpression = MathProgSysModel.this.myDelegate.addExpression(name);
            this.myType = rowType;
            if (this.myType == RowType.N) {
                this.myExpression.weight(BigMath.ONE);
            } else {
                this.myExpression.weight(null);
            }
            this.rhs(BigMath.ZERO);
        }

        public Row range(BigDecimal value) {
            switch (this.myType) {
                case E: {
                    int tmpSignum = value.signum();
                    if (tmpSignum == 1) {
                        this.myExpression.upper(this.myExpression.getLowerLimit().add(value));
                        break;
                    }
                    if (tmpSignum != -1) break;
                    this.myExpression.lower(this.myExpression.getUpperLimit().add(value));
                    break;
                }
                case L: {
                    this.myExpression.lower(this.myExpression.getUpperLimit().subtract(value.abs()));
                    break;
                }
                case G: {
                    this.myExpression.upper(this.myExpression.getLowerLimit().add(value.abs()));
                    break;
                }
                case N: {
                    this.myExpression.level(null);
                    this.myExpression.weight(BigMath.ONE);
                    break;
                }
            }
            return this;
        }

        public Row rhs(BigDecimal value) {
            switch (this.myType) {
                case E: {
                    this.myExpression.level(value);
                    break;
                }
                case L: {
                    this.myExpression.upper(value);
                    break;
                }
                case G: {
                    this.myExpression.lower(value);
                    break;
                }
                case N: {
                    this.myExpression.level(null);
                    this.myExpression.weight(BigMath.ONE);
                    break;
                }
            }
            return this;
        }

        public void setColumnValue(String columnName, BigDecimal value) {
            this.myExpression.set(((Column)MathProgSysModel.this.myColumns.get(columnName)).getVariable(), (Number)value);
        }

        Expression getExpression() {
            return this.myExpression;
        }

        RowType getType() {
            return this.myType;
        }
    }

    static enum FileSection {
        BOUNDS,
        COLUMNS,
        ENDATA,
        NAME,
        OBJNAME,
        OBJSENSE,
        RANGES,
        RHS,
        ROWS,
        SOS;

    }

    static enum ColumnMarker {
        INTEND,
        INTORG;

    }

    final class Column {
        private boolean mySemicontinuous = false;
        private final Variable myVariable;

        Column(String name) {
            this.myVariable = new Variable(name);
            MathProgSysModel.this.myDelegate.addVariable(this.myVariable);
            this.bound(BoundType.PL, null);
        }

        public Column bound(BoundType type, BigDecimal value) {
            switch (type) {
                case LO: {
                    this.myVariable.lower(value);
                    break;
                }
                case UP: {
                    this.myVariable.upper(value);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower(BigMath.ZERO);
                    break;
                }
                case FX: {
                    this.myVariable.level(value);
                    break;
                }
                case FR: {
                    this.myVariable.level(null);
                    break;
                }
                case MI: {
                    this.myVariable.lower(null);
                    if (this.myVariable.isUpperLimitSet()) break;
                    this.myVariable.upper(BigMath.ZERO);
                    break;
                }
                case PL: {
                    this.myVariable.upper(null);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower(BigMath.ZERO);
                    break;
                }
                case BV: {
                    ((Variable)((Variable)this.myVariable.lower(BigMath.ZERO)).upper(BigMath.ONE)).integer(true);
                    break;
                }
                case LI: {
                    ((Variable)((Variable)this.myVariable.lower(value)).upper(null)).integer(true);
                    break;
                }
                case UI: {
                    ((Variable)this.myVariable.upper(value)).integer(true);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower(BigMath.ZERO);
                    break;
                }
                case SC: {
                    this.mySemicontinuous = true;
                    this.myVariable.upper(value);
                    if (this.myVariable.isLowerLimitSet()) break;
                    this.myVariable.lower(BigMath.ONE);
                    break;
                }
            }
            return this;
        }

        public Column integer(boolean flag) {
            this.myVariable.setInteger(flag);
            return this;
        }

        public void setRowValue(String rowName, BigDecimal value) {
            ((Row)MathProgSysModel.this.myRows.get(rowName)).getExpression().set(this.myVariable, (Number)value);
        }

        Variable getVariable() {
            return this.myVariable;
        }

        boolean isSemicontinuous() {
            return this.mySemicontinuous;
        }
    }

    static enum BoundType {
        BV,
        FR,
        FX,
        LI,
        LO,
        MI,
        PL,
        SC,
        UI,
        UP;

    }

    public static abstract class Integration<S extends Optimisation.Solver>
    implements Optimisation.Integration<MathProgSysModel, S> {
    }
}

