/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.RandomNumber1D;

public final class Normal1D
extends RandomNumber1D {
    private final Array1D<Double> myLocations;
    private final Array1D<Double> myScales;

    static Access2D<?> correlations(Access2D<?> covariances) {
        int tmpDim = (int)covariances.countRows();
        Access2D retVal = Array2D.PRIMITIVE.makeZero(tmpDim, tmpDim);
        Access1D tmpStdDev = Array1D.PRIMITIVE.makeZero(tmpDim);
        for (int ij = 0; ij < tmpDim; ++ij) {
            ((Array1D)tmpStdDev).set((long)ij, Math.sqrt(covariances.doubleValue(ij, ij)));
        }
        for (int j = 0; j < tmpDim; ++j) {
            ((Array2D)retVal).set((long)j, (long)j, PrimitiveMath.ONE);
            for (int i = j + 1; i < tmpDim; ++i) {
                double tmpCorrelation = covariances.doubleValue(i, j) / (((Array1D)tmpStdDev).doubleValue(i) * ((Array1D)tmpStdDev).doubleValue(j));
                ((Array2D)retVal).set((long)i, (long)j, tmpCorrelation);
                ((Array2D)retVal).set((long)j, (long)i, tmpCorrelation);
            }
        }
        return retVal;
    }

    public Normal1D(Access1D<?> locations, Access2D<?> covariances) {
        super(Normal1D.correlations(covariances));
        int tmpDim = (int)covariances.countRows();
        this.myLocations = Array1D.PRIMITIVE.copy((Access1D)locations);
        this.myScales = Array1D.PRIMITIVE.makeZero(tmpDim);
        for (int ij = 0; ij < tmpDim; ++ij) {
            this.myScales.set((long)ij, Math.sqrt(covariances.doubleValue(ij, ij)));
        }
    }

    private Normal1D(Access2D<?> correlations) {
        super(correlations);
        this.myLocations = null;
        this.myScales = null;
    }

    public Array1D<Double> doubleValue() {
        Array1D<Double> retVal = this.random().nextGaussian();
        int i = 0;
        while ((long)i < retVal.length) {
            retVal.set((long)i, this.myLocations.doubleValue(i) + this.myScales.doubleValue(i) * retVal.doubleValue(i));
            ++i;
        }
        return retVal;
    }

    @Override
    public Array1D<Double> getExpected() {
        return this.myLocations;
    }

    @Override
    public Array1D<Double> getStandardDeviation() {
        return this.myScales;
    }
}

