/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.Arrays;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.RandomNumber;

public final class SampleSet
implements Access1D<Double> {
    private transient double myMean = Double.NaN;
    private transient double myMedian = Double.NaN;
    private Access1D<?> mySamples;
    private transient double myVariance = Double.NaN;

    public static SampleSet make(RandomNumber randomNumber, int size) {
        PrimitiveArray retVal = PrimitiveArray.make(size);
        for (int i = 0; i < size; ++i) {
            retVal.data[i] = randomNumber.doubleValue();
        }
        return new SampleSet(retVal);
    }

    public static SampleSet wrap(Access1D<?> someSamples) {
        return new SampleSet(someSamples);
    }

    private SampleSet() {
        this(null);
        ProgrammingError.throwForIllegalInvocation();
    }

    SampleSet(Access1D<?> samples) {
        this.mySamples = samples;
        this.reset();
    }

    @Override
    public long count() {
        return this.mySamples.count();
    }

    @Override
    public double doubleValue(long index) {
        return this.mySamples.doubleValue(index);
    }

    public Double get(int index) {
        return this.mySamples.doubleValue(index);
    }

    @Override
    public Double get(long index) {
        return this.mySamples.doubleValue(index);
    }

    public double getCorrelation(SampleSet anotherSampleSet) {
        double retVal = PrimitiveMath.ZERO;
        double tmpCovar = this.getCovariance(anotherSampleSet);
        if (tmpCovar != PrimitiveMath.ZERO) {
            double tmpThisStdDev = this.getStandardDeviation();
            double tmpThatStdDev = anotherSampleSet.getStandardDeviation();
            retVal = tmpCovar / (tmpThisStdDev * tmpThatStdDev);
        }
        return retVal;
    }

    public double getCovariance(SampleSet anotherSampleSet) {
        double retVal = PrimitiveMath.ZERO;
        double tmpThisMean = this.getMean();
        double tmpThatMean = anotherSampleSet.getMean();
        int tmpCount = (int)Math.min(this.mySamples.count(), anotherSampleSet.count());
        Access1D<?> tmpValues = anotherSampleSet.getSamples();
        for (int i = 0; i < tmpCount; ++i) {
            retVal += (this.mySamples.doubleValue(i) - tmpThisMean) * (tmpValues.doubleValue(i) - tmpThatMean);
        }
        return retVal /= (double)(tmpCount - 1);
    }

    public double getFirst() {
        return this.mySamples.doubleValue(0L);
    }

    public double getLargest() {
        double retVal = PrimitiveMath.ZERO;
        int i = 0;
        while ((long)i < this.mySamples.count()) {
            retVal = Math.max(retVal, Math.abs(this.mySamples.doubleValue(i)));
            ++i;
        }
        return retVal;
    }

    public double getLast() {
        return this.mySamples.doubleValue(this.mySamples.count() - 1L);
    }

    public double getMaximum() {
        double retVal = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.mySamples.count()) {
            retVal = Math.max(retVal, this.mySamples.doubleValue(i));
            ++i;
        }
        return retVal;
    }

    public double getMean() {
        if (Double.isNaN(this.myMean)) {
            this.myMean = PrimitiveMath.ZERO;
            int i = 0;
            while ((long)i < this.mySamples.count()) {
                this.myMean += this.mySamples.doubleValue(i);
                ++i;
            }
            this.myMean /= (double)this.mySamples.count();
        }
        return this.myMean;
    }

    public double getMedian() {
        if (Double.isNaN(this.myMedian)) {
            double[] tmpCopy = ArrayUtils.toRawCopyOf(this.mySamples);
            Arrays.sort(tmpCopy);
            this.myMedian = tmpCopy[(int)(this.mySamples.count() / 2L)];
        }
        return this.myMedian;
    }

    public double getMinimum() {
        double retVal = Double.POSITIVE_INFINITY;
        int i = 0;
        while ((long)i < this.mySamples.count()) {
            retVal = Math.min(retVal, this.mySamples.doubleValue(i));
            ++i;
        }
        return retVal;
    }

    public double getSmallest() {
        double retVal = Double.POSITIVE_INFINITY;
        int i = 0;
        while ((long)i < this.mySamples.count()) {
            retVal = Math.min(retVal, Math.abs(this.mySamples.doubleValue(i)));
            ++i;
        }
        return retVal;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getStandardScore(long index) {
        return (this.doubleValue(index) - this.getMean()) / this.getStandardDeviation();
    }

    public double getSumOfSquares() {
        double retVal = PrimitiveMath.ZERO;
        double tmpMean = this.getMean();
        int tmpLimit = (int)this.mySamples.count();
        for (int i = 0; i < tmpLimit; ++i) {
            double tmpVal = this.mySamples.doubleValue(i) - tmpMean;
            retVal += tmpVal * tmpVal;
        }
        return retVal;
    }

    public double[] getValues() {
        return ArrayUtils.toRawCopyOf(this.mySamples);
    }

    public double getVariance() {
        if (Double.isNaN(this.myVariance)) {
            this.myVariance = this.getCovariance(this);
        }
        return this.myVariance;
    }

    public void reset() {
        this.myMean = Double.NaN;
        this.myMedian = Double.NaN;
        this.myVariance = Double.NaN;
    }

    public int size() {
        return (int)this.mySamples.count();
    }

    public void swap(SampleSet samples) {
        this.mySamples = samples;
        this.reset();
    }

    public String toString() {
        return "Sample set size: " + this.count() + ", Mean: " + this.getMean() + ", Median: " + this.getMedian() + ", Variance: " + this.getVariance() + ", Standard Deviation: " + this.getStandardDeviation() + ", Minimum: " + this.getMinimum() + ", Maximum: " + this.getMaximum();
    }

    Access1D<?> getSamples() {
        return this.mySamples;
    }
}

