/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.random.Normal;
import org.ojalgo.random.Normal1D;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.GaussianField;

public final class GaussianProcess
extends AbstractProcess<Normal> {
    private static final Normal GENERATOR = new Normal();
    private final GaussianField<Double> myDelegate;

    public GaussianProcess(GaussianField.Covariance<Double> covarFunc) {
        this.myDelegate = new GaussianField<Double>(covarFunc, this.getObservations());
    }

    public GaussianProcess(GaussianField.Mean<Double> meanFunc, GaussianField.Covariance<Double> covarFunc) {
        this.myDelegate = new GaussianField<Double>(meanFunc, covarFunc, this.getObservations());
    }

    private GaussianProcess() {
        this(null, null);
    }

    public void calibrate() {
        this.myDelegate.calibrate();
    }

    @Override
    public Normal getDistribution(double evaluationPoint) {
        Normal1D tmpVal = this.getDistribution(new Double[]{evaluationPoint});
        double tmpLocation = tmpVal.getExpected().doubleValue(0L);
        double tmpScale = tmpVal.getStandardDeviation().doubleValue(0L);
        return new Normal(tmpLocation, tmpScale);
    }

    public Normal1D getDistribution(Double ... evaluationPoint) {
        return this.myDelegate.getDistribution(false, evaluationPoint);
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        Normal tmpDistr = this.getDistribution(stepSize);
        double retVal = normalisedRandomIncrement * tmpDistr.getStandardDeviation() + tmpDistr.getExpected();
        this.addObservation((Double)this.getObservations().last().key + stepSize, retVal);
        return retVal;
    }

    MatrixStore<Double> getCovariances() {
        return this.myDelegate.getC22().reconstruct();
    }

    @Override
    double getExpected(double aStepSize) {
        return this.getDistribution(aStepSize).getExpected();
    }

    @Override
    double getLowerConfidenceQuantile(double aStepSize, double aConfidence) {
        return this.getDistribution(aStepSize).getLowerConfidenceQuantile(aConfidence);
    }

    @Override
    double getStandardDeviation(double aStepSize) {
        return this.getDistribution(aStepSize).getStandardDeviation();
    }

    @Override
    double getUpperConfidenceQuantile(double aStepSize, double aConfidence) {
        return this.getDistribution(aStepSize).getUpperConfidenceQuantile(aConfidence);
    }

    @Override
    double getVariance(double aStepSize) {
        return this.getDistribution(aStepSize).getVariance();
    }
}

