/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.Exponential;
import org.ojalgo.random.Poisson;
import org.ojalgo.random.process.AbstractProcess;

public final class PoissonProcess
extends AbstractProcess<Poisson> {
    private final double myRate;
    private static final Poisson GENERATOR = new Poisson();

    protected PoissonProcess(double aRate) {
        this.setValue(PrimitiveMath.ZERO);
        this.myRate = aRate;
    }

    @Override
    public Poisson getDistribution(double evaluationPoint) {
        return new Poisson(this.myRate * evaluationPoint);
    }

    public Exponential getTimeBetweenConsecutiveEvents() {
        return new Exponential(this.myRate);
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double retVal = currentValue + this.myRate * stepSize * normalisedRandomIncrement;
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double aStepSize) {
        return this.myRate * aStepSize;
    }

    @Override
    double getLowerConfidenceQuantile(double aStepSize, double aConfidence) {
        throw new UnsupportedOperationException();
    }

    @Override
    double getStandardDeviation(double aStepSize) {
        return Math.sqrt(this.myRate * aStepSize);
    }

    @Override
    double getUpperConfidenceQuantile(double aStepSize, double aConfidence) {
        throw new UnsupportedOperationException();
    }

    @Override
    double getVariance(double aStepSize) {
        return this.myRate * aStepSize;
    }
}

