/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tshort;

import cern.colt.PersistentObject;
import cern.colt.buffer.tshort.ShortBuffer3DConsumer;
import cern.colt.list.tshort.ShortArrayList;

public class ShortBuffer3D
extends PersistentObject
implements ShortBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected ShortBuffer3DConsumer target;
    protected short[] xElements;
    protected short[] yElements;
    protected short[] zElements;
    protected ShortArrayList xList;
    protected ShortArrayList yList;
    protected ShortArrayList zList;
    protected int capacity;
    protected int size;

    public ShortBuffer3D(ShortBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new short[capacity];
        this.yElements = new short[capacity];
        this.zElements = new short[capacity];
        this.xList = new ShortArrayList(this.xElements);
        this.yList = new ShortArrayList(this.yElements);
        this.zList = new ShortArrayList(this.zElements);
        this.size = 0;
    }

    public void add(short x, short y, short z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    public void addAllOf(ShortArrayList xElements, ShortArrayList yElements, ShortArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

