/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.Timer;
import cern.colt.map.PrimeFinder;
import cern.colt.map.tint.QuickOpenIntIntHashMap;
import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;

public class BenchmarkMap {
    protected BenchmarkMap() {
    }

    public static void benchmark(int runs, int size, String kind) {
        System.out.println("initializing...");
        QuickOpenIntIntHashMap map = new QuickOpenIntIntHashMap();
        for (int i = 0; i < size; ++i) {
            map.put(i, i);
        }
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        System.out.println("Now benchmarking...");
        int s = 0;
        Timer timer0 = new Timer();
        Timer timer1 = new Timer();
        Timer timer2 = new Timer();
        int run = runs;
        while (--run >= 0) {
            int i;
            if (kind.equals("add")) {
                map.clear();
                timer0.start();
                i = size;
                while (--i >= 0) {
                    map.put(i, i);
                }
                timer0.stop();
            }
            if (kind.equals("get")) {
                timer0.start();
                i = size;
                while (--i >= 0) {
                    s += map.get(i);
                }
                timer0.stop();
                continue;
            }
            timer1.start();
            map.rehash(PrimeFinder.nextPrime(size * 2));
            timer1.stop();
            timer2.start();
            map.rehash(PrimeFinder.nextPrime((int)((double)size * 1.5)));
            timer2.stop();
        }
        System.out.println("adding: " + timer0);
        System.out.println("growing: " + timer1);
        System.out.println("shrinking: " + timer2);
        System.out.println("total: " + timer1.plus(timer2));
        System.out.print(s);
    }

    public static void main(String[] args) {
        int runs = Integer.parseInt(args[0]);
        int size = Integer.parseInt(args[1]);
        String kind = args[2];
        BenchmarkMap.benchmark(runs, size, kind);
    }

    public static void test2(int length) {
        DoubleUniform uniform = new DoubleUniform(new DoubleMersenneTwister());
        int[] keys = new int[length];
        int to = 10000000;
        for (int i = 0; i < length; ++i) {
            keys[i] = uniform.nextIntFromTo(0, to);
        }
        int[] values = (int[])keys.clone();
        int size = keys.length;
        OpenLongIntHashMap map = new OpenLongIntHashMap();
        for (int i = 0; i < keys.length; ++i) {
            ((AbstractLongIntMap)map).put(keys[i], values[i]);
        }
        int sum = 0;
        for (int i = 0; i < keys.length; ++i) {
            sum += ((AbstractLongIntMap)map).get(keys[i]);
        }
        System.out.println(map);
        System.out.println(sum);
        System.out.println("\n\n");
    }
}

