/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;

public class DenseDComplexAlgebra
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DenseDComplexAlgebra DEFAULT = new DenseDComplexAlgebra();
    public static final DenseDComplexAlgebra ZERO;
    protected DComplexProperty property;

    public DenseDComplexAlgebra() {
        this(DComplexProperty.DEFAULT.tolerance());
    }

    public DenseDComplexAlgebra(double tolerance) {
        this.setProperty(new DComplexProperty(tolerance));
    }

    public void setProperty(DComplexProperty property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public double normInfinity(DComplexMatrix1D x) {
        if (x.size() == 0L) {
            return 0.0;
        }
        DoubleMatrix1D d = x.assign(DComplexFunctions.abs).getRealPart();
        return d.aggregate(DoubleFunctions.max, DoubleFunctions.identity);
    }

    static {
        DenseDComplexAlgebra.DEFAULT.property = DComplexProperty.DEFAULT;
        ZERO = new DenseDComplexAlgebra();
        DenseDComplexAlgebra.ZERO.property = DComplexProperty.ZERO;
    }
}

