/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseDComplexMatrix2D
extends DComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseDComplexMatrix2D(int rows, int columns, ConcurrentHashMap<Long, double[]> elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    protected SelectedSparseDComplexMatrix2D(ConcurrentHashMap<Long, double[]> elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    public double[] getQuick(int row, int column) {
        return this.elements.get((long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride]);
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D other) {
        if (other instanceof SelectedSparseDComplexMatrix2D) {
            SelectedSparseDComplexMatrix2D otherMatrix = (SelectedSparseDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDComplexMatrix2D) {
            SparseDComplexMatrix2D otherMatrix = (SparseDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new SparseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new SparseDComplexMatrix1D(size);
    }

    @Override
    protected DComplexMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        long index = (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (value[0] == 0.0 && value[1] == 0.0) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public DComplexMatrix1D vectorize() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        long index = (long)this.offset + (long)this.rowOffsets[this.rowZero + row * this.rowStride] + (long)this.columnOffsets[this.columnZero + column * this.columnStride];
        if (re == 0.0 && im == 0.0) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, new double[]{re, im});
        }
    }

    @Override
    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    @Override
    public DComplexMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedSparseDComplexMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    public DComplexMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedSparseDComplexMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDComplexMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

