/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;

    public SparseDComplexMatrix3D(double[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public SparseDComplexMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new ConcurrentHashMap(slices * rows * (columns / 1000));
    }

    protected SparseDComplexMatrix3D(int slices, int rows, int columns, ConcurrentHashMap<Long, double[]> elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix3D assign(double[] value) {
        if (this.isNoView && value[0] == 0.0 && value[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized double[] getQuick(int slice, int row, int column) {
        double[] elem = this.elements.get((long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
        if (elem != null) {
            return new double[]{elem[0], elem[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix3D other) {
        if (other instanceof SelectedSparseDComplexMatrix3D) {
            SelectedSparseDComplexMatrix3D otherMatrix = (SelectedSparseDComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDComplexMatrix3D) {
            SparseDComplexMatrix3D otherMatrix = (SparseDComplexMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public DComplexMatrix3D like(int slices, int rows, int columns) {
        return new SparseDComplexMatrix3D(slices, rows, columns);
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        return new SparseDComplexMatrix2D(rows, columns);
    }

    @Override
    protected DComplexMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new SparseDComplexMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, double[] value) {
        long index = (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value[0] == 0.0 && value[1] == 0.0) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, double re, double im) {
        long index = (long)this.sliceZero + (long)slice * (long)this.sliceStride + (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (re == 0.0 && im == 0.0) {
            this.elements.remove(index);
        } else {
            this.elements.put(index, new double[]{re, im});
        }
    }

    @Override
    protected DComplexMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDComplexMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }

    @Override
    public DComplexMatrix1D vectorize() {
        SparseDComplexMatrix1D v = new SparseDComplexMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        for (int s = 0; s < this.slices; ++s) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
        }
        return v;
    }

    @Override
    public DoubleMatrix3D getImaginaryPart() {
        final SparseDoubleMatrix3D Im = new SparseDoubleMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < SparseDComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < SparseDComplexMatrix3D.this.columns; ++c) {
                                    Im.setQuick(s, r, c, SparseDComplexMatrix3D.this.getQuick(s, r, c)[1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        ((DoubleMatrix3D)Im).setQuick(s, r, c, this.getQuick(s, r, c)[1]);
                    }
                }
            }
        }
        return Im;
    }

    @Override
    public DoubleMatrix3D getRealPart() {
        final SparseDoubleMatrix3D Re = new SparseDoubleMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < SparseDComplexMatrix3D.this.rows; ++r) {
                                for (int c = 0; c < SparseDComplexMatrix3D.this.columns; ++c) {
                                    Re.setQuick(s, r, c, SparseDComplexMatrix3D.this.getQuick(s, r, c)[0]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        ((DoubleMatrix3D)Re).setQuick(s, r, c, this.getQuick(s, r, c)[0]);
                    }
                }
            }
        }
        return Re;
    }
}

