/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.PersistentObject;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix3D;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleFactory3D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final DoubleFactory3D dense = new DoubleFactory3D();
    public static final DoubleFactory3D sparse = new DoubleFactory3D();

    protected DoubleFactory3D() {
    }

    public DoubleMatrix3D ascending(int slices, int rows, int columns) {
        return this.descending(slices, rows, columns).assign(DoubleFunctions.chain(DoubleFunctions.neg, DoubleFunctions.minus(slices * rows * columns)));
    }

    public DoubleMatrix3D descending(int slices, int rows, int columns) {
        DoubleMatrix3D matrix = this.make(slices, rows, columns);
        int v = 0;
        int slice = slices;
        while (--slice >= 0) {
            int row = rows;
            while (--row >= 0) {
                int column = columns;
                while (--column >= 0) {
                    matrix.setQuick(slice, row, column, v++);
                }
            }
        }
        return matrix;
    }

    public DoubleMatrix3D make(double[][][] values) {
        if (this == sparse) {
            return new SparseDoubleMatrix3D(values);
        }
        return new DenseDoubleMatrix3D(values);
    }

    public DoubleMatrix3D make(int slices, int rows, int columns) {
        if (this == sparse) {
            return new SparseDoubleMatrix3D(slices, rows, columns);
        }
        return new DenseDoubleMatrix3D(slices, rows, columns);
    }

    public DoubleMatrix3D make(int slices, int rows, int columns, double initialValue) {
        return this.make(slices, rows, columns).assign(initialValue);
    }

    public DoubleMatrix3D random(int slices, int rows, int columns) {
        return this.make(slices, rows, columns).assign(DoubleFunctions.random());
    }
}

