/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleBlas;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class SmpDoubleBlas
implements DoubleBlas {
    public void assign(DoubleMatrix2D A, DoubleFunction function) {
        A.assign(function);
    }

    public void assign(DoubleMatrix2D A, DoubleMatrix2D B, DoubleDoubleFunction function) {
        A.assign(B, function);
    }

    public double dasum(DoubleMatrix1D x) {
        return x.aggregate(DoubleFunctions.plus, DoubleFunctions.abs);
    }

    public void daxpy(double alpha, DoubleMatrix1D x, DoubleMatrix1D y) {
        y.assign(x, DoubleFunctions.plusMultSecond(alpha));
    }

    public void daxpy(double alpha, DoubleMatrix2D A, DoubleMatrix2D B) {
        B.assign(A, DoubleFunctions.plusMultSecond(alpha));
    }

    public void dcopy(DoubleMatrix1D x, DoubleMatrix1D y) {
        y.assign(x);
    }

    public void dcopy(DoubleMatrix2D A, DoubleMatrix2D B) {
        B.assign(A);
    }

    public double ddot(DoubleMatrix1D x, DoubleMatrix1D y) {
        return x.zDotProduct(y);
    }

    public void dgemm(boolean transposeA, boolean transposeB, double alpha, DoubleMatrix2D A, DoubleMatrix2D B, double beta, DoubleMatrix2D C) {
        A.zMult(B, C, alpha, beta, transposeA, transposeB);
    }

    public void dgemv(boolean transposeA, double alpha, DoubleMatrix2D A, DoubleMatrix1D x, double beta, DoubleMatrix1D y) {
        A.zMult(x, y, alpha, beta, transposeA);
    }

    public void dger(double alpha, DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix2D A) {
        DoublePlusMultSecond fun = DoublePlusMultSecond.plusMult(0.0);
        int rows = A.rows();
        for (int i = 0; i < rows; ++i) {
            fun.multiplicator = alpha * x.getQuick(i);
            A.viewRow(i).assign(y, fun);
        }
    }

    public double dnrm2(DoubleMatrix1D x) {
        return DenseDoubleAlgebra.DEFAULT.norm2(x);
    }

    public void drot(DoubleMatrix1D x, DoubleMatrix1D y, double c, double s) {
        x.checkSize(y);
        DoubleMatrix1D tmp = x.copy();
        x.assign(DoubleFunctions.mult(c));
        x.assign(y, DoubleFunctions.plusMultSecond(s));
        y.assign(DoubleFunctions.mult(c));
        y.assign(tmp, DoubleFunctions.minusMult(s));
    }

    public void drotg(double a, double b, double[] rotvec) {
        double z;
        double s;
        double c;
        double r;
        double scale;
        double roe = b;
        if (Math.abs(a) > Math.abs(b)) {
            roe = a;
        }
        if ((scale = Math.abs(a) + Math.abs(b)) != 0.0) {
            double ra = a / scale;
            double rb = b / scale;
            r = scale * Math.sqrt(ra * ra + rb * rb);
            r = this.sign(1.0, roe) * r;
            c = a / r;
            s = b / r;
            z = 1.0;
            if (Math.abs(a) > Math.abs(b)) {
                z = s;
            }
            if (Math.abs(b) >= Math.abs(a) && c != 0.0) {
                z = 1.0 / c;
            }
        } else {
            c = 1.0;
            s = 0.0;
            r = 0.0;
            z = 0.0;
        }
        a = r;
        b = z;
        rotvec[0] = a;
        rotvec[1] = b;
        rotvec[2] = c;
        rotvec[3] = s;
    }

    public void dscal(double alpha, DoubleMatrix1D x) {
        x.assign(DoubleFunctions.mult(alpha));
    }

    public void dscal(double alpha, DoubleMatrix2D A) {
        A.assign(DoubleFunctions.mult(alpha));
    }

    public void dswap(DoubleMatrix1D x, DoubleMatrix1D y) {
        y.swap(x);
    }

    public void dswap(DoubleMatrix2D A, DoubleMatrix2D B) {
        A.checkShape(B);
        int rows = A.rows();
        for (int i = 0; i < rows; ++i) {
            A.viewRow(i).swap(B.viewRow(i));
        }
    }

    public void dsymv(boolean isUpperTriangular, final double alpha, DoubleMatrix2D A, final DoubleMatrix1D x, final double beta, final DoubleMatrix1D y) {
        final DoubleMatrix2D A_loc = isUpperTriangular ? A.viewDice() : A;
        DoubleProperty.DEFAULT.checkSquare(A_loc);
        int size = A_loc.rows();
        if ((long)size != x.size() || (long)size != y.size()) {
            throw new IllegalArgumentException(A_loc.toStringShort() + ", " + x.toStringShort() + ", " + y.toStringShort());
        }
        final DoubleMatrix1D tmp = x.like();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int j;
                            double sum = 0.0;
                            for (j = 0; j <= i; ++j) {
                                sum += A_loc.getQuick(i, j) * x.getQuick(j);
                            }
                            for (j = i + 1; j < lastIdx; ++j) {
                                sum += A_loc.getQuick(j, i) * x.getQuick(j);
                            }
                            tmp.setQuick(i, alpha * sum + beta * y.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int j;
                double sum = 0.0;
                for (j = 0; j <= i; ++j) {
                    sum += A_loc.getQuick(i, j) * x.getQuick(j);
                }
                for (j = i + 1; j < size; ++j) {
                    sum += A_loc.getQuick(j, i) * x.getQuick(j);
                }
                tmp.setQuick(i, alpha * sum + beta * y.getQuick(i));
            }
        }
        y.assign(tmp);
    }

    public void dtrmv(boolean isUpperTriangular, boolean transposeA, boolean isUnitTriangular, DoubleMatrix2D A, final DoubleMatrix1D x) {
        boolean isUpperTriangular_loc;
        DoubleMatrix2D A_loc;
        if (transposeA) {
            A_loc = A.viewDice();
            isUpperTriangular_loc = !isUpperTriangular;
        } else {
            A_loc = A;
            isUpperTriangular_loc = isUpperTriangular;
        }
        DoubleProperty.DEFAULT.checkSquare(A_loc);
        int size = A_loc.rows();
        if ((long)size != x.size()) {
            throw new IllegalArgumentException(A_loc.toStringShort() + ", " + x.toStringShort());
        }
        final DoubleMatrix1D b = x.like();
        final DoubleMatrix1D y = x.like();
        if (isUnitTriangular) {
            y.assign(1.0);
        } else {
            for (int i = 0; i < size; ++i) {
                y.setQuick(i, A_loc.getQuick(i, i));
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int j;
                            double sum = 0.0;
                            if (!isUpperTriangular_loc) {
                                for (j = 0; j < i; ++j) {
                                    sum += A_loc.getQuick(i, j) * x.getQuick(j);
                                }
                                sum += y.getQuick(i) * x.getQuick(i);
                            } else {
                                sum += y.getQuick(i) * x.getQuick(i);
                                for (j = i + 1; j < lastIdx; ++j) {
                                    sum += A_loc.getQuick(i, j) * x.getQuick(j);
                                }
                            }
                            b.setQuick(i, sum);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                int j;
                double sum = 0.0;
                if (!isUpperTriangular_loc) {
                    for (j = 0; j < i; ++j) {
                        sum += A_loc.getQuick(i, j) * x.getQuick(j);
                    }
                    sum += y.getQuick(i) * x.getQuick(i);
                } else {
                    sum += y.getQuick(i) * x.getQuick(i);
                    for (j = i + 1; j < size; ++j) {
                        sum += A_loc.getQuick(i, j) * x.getQuick(j);
                    }
                }
                b.setQuick(i, sum);
            }
        }
        x.assign(b);
    }

    public int idamax(DoubleMatrix1D x) {
        DoubleMatrix1D x_abs = x.copy();
        x_abs.assign(DoubleFunctions.abs);
        double[] maxAndLoc = x_abs.getMaxLocation();
        return (int)maxAndLoc[1];
    }

    private double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }
}

