/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import java.io.Serializable;

public class DenseDoubleCholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D Lt;
    private double[] elementsA;
    private boolean columnMatrix = false;
    private int n;

    public DenseDoubleCholeskyDecomposition(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.checkSquare(A);
        DoubleProperty.DEFAULT.checkDense(A);
        if (A instanceof DenseDoubleMatrix2D) {
            this.elementsA = (double[])A.viewDice().copy().elements();
        } else {
            this.columnMatrix = true;
            this.elementsA = (double[])A.copy().elements();
        }
        this.n = A.rows();
        Dplasma.plasma_Init((int)this.n, (int)this.n, (int)1);
        int info = Dplasma.plasma_DPOTRF((int)121, (int)this.n, (double[])this.elementsA, (int)0, (int)this.n);
        Dplasma.plasma_Finalize();
        if (info > 0) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        if (info < 0) {
            throw new IllegalArgumentException("Error occured while computing Cholesky decomposition: " + info);
        }
    }

    public DoubleMatrix2D getL() {
        if (this.Lt != null) {
            return this.Lt.viewDice().copy();
        }
        if (this.columnMatrix) {
            this.Lt = new DenseColumnDoubleMatrix2D(this.n, this.n);
            double[] Lelems = (double[])this.Lt.elements();
            int c = this.n;
            while (--c >= 0) {
                int r = this.n;
                while (--r >= c) {
                    Lelems[r * this.n + c] = this.elementsA[r * this.n + c];
                }
            }
        } else {
            this.Lt = new DenseDoubleMatrix2D(this.n, this.n);
            double[] Lelems = (double[])this.Lt.elements();
            int c = this.n;
            while (--c >= 0) {
                int r = this.n;
                while (--r >= c) {
                    Lelems[c * this.n + r] = this.elementsA[r * this.n + c];
                }
            }
        }
        return this.Lt.viewDice().copy();
    }

    public DoubleMatrix2D getLtranspose() {
        if (this.Lt != null) {
            return this.Lt;
        }
        if (this.columnMatrix) {
            this.Lt = new DenseColumnDoubleMatrix2D(this.n, this.n);
            double[] Lelems = (double[])this.Lt.elements();
            int c = this.n;
            while (--c >= 0) {
                int r = this.n;
                while (--r >= c) {
                    Lelems[r * this.n + c] = this.elementsA[r * this.n + c];
                }
            }
        } else {
            this.Lt = new DenseDoubleMatrix2D(this.n, this.n);
            double[] Lelems = (double[])this.Lt.elements();
            int c = this.n;
            while (--c >= 0) {
                int r = this.n;
                while (--r >= c) {
                    Lelems[c * this.n + r] = this.elementsA[r * this.n + c];
                }
            }
        }
        return this.Lt;
    }

    public void solve(DoubleMatrix2D B) {
        if (B.rows() != this.n) {
            throw new IllegalArgumentException("B.rows() != A.rows()");
        }
        DoubleProperty.DEFAULT.checkDense(B);
        double[] elementsX = B instanceof DenseDoubleMatrix2D ? (double[])B.viewDice().copy().elements() : (B.isView() ? (double[])B.copy().elements() : (double[])B.elements());
        int nrhs = B.columns();
        Dplasma.plasma_Init((int)this.n, (int)this.n, (int)nrhs);
        int info = Dplasma.plasma_DPOTRS((int)121, (int)this.n, (int)nrhs, (double[])this.elementsA, (int)0, (int)this.n, (double[])elementsX, (int)0, (int)this.n);
        Dplasma.plasma_Finalize();
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using Cholesky decomposition: " + info);
        }
        if (B instanceof DenseDoubleMatrix2D) {
            B.viewDice().assign(elementsX);
        } else if (B.isView()) {
            B.assign(elementsX);
        }
    }

    public void solve(DoubleMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        DoubleProperty.DEFAULT.checkDense(b);
        double[] elementsX = b.isView() ? (double[])b.copy().elements() : (double[])b.elements();
        Dplasma.plasma_Init((int)this.n, (int)this.n, (int)1);
        int info = Dplasma.plasma_DPOTRS((int)121, (int)this.n, (int)1, (double[])this.elementsA, (int)0, (int)this.n, (double[])elementsX, (int)0, (int)this.n);
        Dplasma.plasma_Finalize();
        if (info != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using Cholesky decomposition: " + info);
        }
        if (b.isView()) {
            b.assign(elementsX);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("CholeskyDecomposition(A) --> L, inverse(A)\n");
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("\nL = ");
        try {
            buf.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        try {
            DoubleMatrix2D X = DoubleFactory2D.dense.identity(this.n);
            this.solve(X);
            buf.append(String.valueOf(X));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        return buf.toString();
    }
}

