/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.Timer;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.DefaultDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;

public abstract class DoubleIterativeSolverBenchmark
extends TestCase {
    protected int repeat;
    protected int[] nthreads;
    protected int maxIter;
    protected DoubleMatrix2D A;
    protected DoubleMatrix1D b;
    protected DoubleMatrix1D x;
    protected DoubleIterativeSolver solver;
    protected DoublePreconditioner M;
    protected DoubleIterationMonitor monitor;
    protected static final Timer t = new Timer();

    public DoubleIterativeSolverBenchmark(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        this.readIterativeSolverBenchmarkSettings();
        int n = this.A.rows();
        this.x = new DenseDoubleMatrix1D(n);
        this.b = new DenseDoubleMatrix1D(n);
        this.createSolver();
        this.solver.setIterationMonitor(this.monitor);
        this.M.setMatrix(this.A);
        this.solver.setPreconditioner(this.M);
        this.x.assign(1.0);
        this.b = this.A.zMult(this.x, this.b);
        this.x = new DenseDoubleMatrix1D(n);
    }

    protected void tearDown() throws Exception {
        this.x = null;
        this.b = null;
        this.solver = null;
    }

    protected abstract void createSolver() throws Exception;

    public void testBenchmark() {
        System.out.println("Benchmarking " + this.solver.getClass().getName() + " with preconditioner " + this.solver.getPreconditioner().getClass().getName());
        for (int k = 0; k < this.nthreads.length; ++k) {
            System.out.println("\tNumber of threads = " + this.nthreads[k]);
            ConcurrencyUtils.setNumberOfThreads(this.nthreads[k]);
            IterativeSolverDoubleNotConvergedException ex = null;
            double elapsedTime = 0.0;
            for (int i = 0; i < this.repeat; ++i) {
                t.reset().start();
                try {
                    this.solver.solve(this.A, this.b, this.x);
                }
                catch (IterativeSolverDoubleNotConvergedException e) {
                    ex = e;
                }
                t.stop();
                elapsedTime += t.seconds();
                this.x.assign(0.0);
            }
            if (ex != null) {
                System.out.println("\t\tSolver did not converge: " + (Object)((Object)ex.getReason()) + ". Residual=" + ex.getResidual());
            }
            System.out.println("\t\tNumber of iterations performed = " + this.solver.getIterationMonitor().iterations());
            System.out.println("\t\tAverage execution time = " + elapsedTime / (double)this.repeat + " seconds");
        }
    }

    private void readIterativeSolverBenchmarkSettings() {
        String settingsPath = System.getProperty("iterativeSolverSettingsFile");
        if (settingsPath == null) {
            throw new IllegalArgumentException("Property iterativeSolverSettingsFile not found!");
        }
        File settingsFile = new File(settingsPath);
        if (settingsFile.exists()) {
            try {
                RandomAccessFile input = null;
                input = new RandomAccessFile(settingsPath, "r");
                String line = input.readLine();
                String matrixPath = line = input.readLine();
                MatrixVectorReader reader = new MatrixVectorReader(new BufferedReader(new FileReader(matrixPath)));
                SparseDoubleMatrix2D Aco = new SparseDoubleMatrix2D(reader);
                this.A = Aco.getRowCompressed(true);
                line = input.readLine();
                this.repeat = Integer.parseInt(line.trim());
                line = input.readLine();
                this.maxIter = Integer.parseInt(line.trim());
                this.monitor = new DefaultDoubleIterationMonitor(this.maxIter, 0.0, 0.0, Double.MAX_VALUE);
                line = input.readLine();
                String[] stringThreads = line.split(",");
                this.nthreads = new int[stringThreads.length];
                for (int i = 0; i < stringThreads.length; ++i) {
                    this.nthreads[i] = Integer.parseInt(stringThreads[i].trim());
                }
                input.close();
                System.out.println("Settings were loaded");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("The settings file does not exist!");
        }
    }
}

