/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import edu.emory.mathcs.utils.IOUtils;
import java.util.Random;

public class AccuracyCheckDoubleFFT {
    private static int[] sizesPrimes = new int[]{997, 4999, 9973, 49999, 99991, 249989};
    private static int[] sizesPower2 = new int[]{8192, 16384, 32768, 65536, 131072, 262144};
    private static final int niters = 10;
    private static Random r;

    private AccuracyCheckDoubleFFT() {
    }

    public static void checkAccuracyRealFFT_1D() {
        DenseDoubleMatrix1D Mr;
        DenseDComplexMatrix1D Mc;
        DenseDoubleMatrix1D M;
        int j;
        int i;
        System.out.println("Checking accuracy of 1D real forward full FFT (prime sizes)...");
        double[][] errors = new double[10][sizesPrimes.length];
        for (i = 0; i < sizesPrimes.length; ++i) {
            r = new Random(0L);
            for (j = 0; j < 10; ++j) {
                M = new DenseDoubleMatrix1D(sizesPrimes[i]);
                AccuracyCheckDoubleFFT.fillMatrix_1D(sizesPrimes[i], M.elements());
                Mc = M.getFft();
                Mc.ifft(true);
                Mr = (DenseDoubleMatrix1D)Mc.getRealPart();
                errors[j][i] = AccuracyCheckDoubleFFT.computeRMSE(M.elements(), Mr.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", errors, "pc_rmse_primes_double.txt");
        System.out.println("Checking accuracy of 1D real forward full FFT (power2 sizes)...");
        errors = new double[10][sizesPower2.length];
        for (i = 0; i < sizesPower2.length; ++i) {
            r = new Random(0L);
            for (j = 0; j < 10; ++j) {
                M = new DenseDoubleMatrix1D(sizesPower2[i]);
                AccuracyCheckDoubleFFT.fillMatrix_1D(sizesPower2[i], M.elements());
                Mc = M.getFft();
                Mc.ifft(true);
                Mr = (DenseDoubleMatrix1D)Mc.getRealPart();
                errors[j][i] = AccuracyCheckDoubleFFT.computeRMSE(M.elements(), Mr.elements());
            }
        }
        IOUtils.writeToFileReal_2D("%g", errors, "pc_rmse_power2_double.txt");
    }

    private static double computeRMSE(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double tmp = a[i] - b[i];
            rms += tmp * tmp;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    public static void main(String[] args) {
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_1D();
        System.exit(0);
    }

    private static void fillMatrix_1D(int N, double[] m) {
        for (int i = 0; i < N; ++i) {
            m[i] = r.nextDouble();
        }
    }
}

