/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix3D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeFComplexMatrix3D
extends WrapperFComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    private float[][][] elements;
    private FloatFFT_3D fft3;
    private FloatFFT_2D fft2Slices;

    public DenseLargeFComplexMatrix3D(int slices, int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new float[slices][rows][2 * columns];
    }

    public float[] getQuick(int slice, int row, int column) {
        return new float[]{this.elements[slice][row][2 * column], this.elements[slice][row][2 * column + 1]};
    }

    public void setQuick(int slice, int row, int column, float[] value) {
        this.elements[slice][row][2 * column] = value[0];
        this.elements[slice][row][2 * column + 1] = value[1];
    }

    public void setQuick(int slice, int row, int column, float re, float im) {
        this.elements[slice][row][2 * column] = re;
        this.elements[slice][row][2 * column + 1] = im;
    }

    public void fft2Slices() {
        int nthreads;
        if (this.fft2Slices == null) {
            this.fft2Slices = new FloatFFT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeFComplexMatrix3D.this.fft2Slices.complexForward(DenseLargeFComplexMatrix3D.this.elements[s]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.fft2Slices.complexForward(this.elements[s]);
            }
        }
    }

    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft2Slices(final boolean scale) {
        int nthreads;
        if (this.fft2Slices == null) {
            this.fft2Slices = new FloatFFT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeFComplexMatrix3D.this.fft2Slices.complexInverse(DenseLargeFComplexMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.fft2Slices.complexInverse(this.elements[s], scale);
            }
        }
    }

    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.complexInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[][][] elements() {
        return this.elements;
    }

    protected FComplexMatrix3D getContent() {
        return this;
    }

    public FComplexMatrix3D like(int slices, int rows, int columns) {
        return new DenseLargeFComplexMatrix3D(slices, rows, columns);
    }
}

