/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.PersistentObject;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.DenseIntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix3D;
import cern.jet.math.tint.IntFunctions;

public class IntFactory3D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntFactory3D dense = new IntFactory3D();
    public static final IntFactory3D sparse = new IntFactory3D();

    protected IntFactory3D() {
    }

    public IntMatrix3D ascending(int slices, int rows, int columns) {
        IntFunctions F = IntFunctions.intFunctions;
        return this.descending(slices, rows, columns).assign(IntFunctions.chain(IntFunctions.neg, IntFunctions.minus(slices * rows * columns)));
    }

    public IntMatrix3D descending(int slices, int rows, int columns) {
        IntMatrix3D matrix = this.make(slices, rows, columns);
        int v = 0;
        int slice = slices;
        while (--slice >= 0) {
            int row = rows;
            while (--row >= 0) {
                int column = columns;
                while (--column >= 0) {
                    matrix.setQuick(slice, row, column, v++);
                }
            }
        }
        return matrix;
    }

    public IntMatrix3D make(int[][][] values) {
        if (this == sparse) {
            return new SparseIntMatrix3D(values);
        }
        return new DenseIntMatrix3D(values);
    }

    public IntMatrix3D make(int slices, int rows, int columns) {
        if (this == sparse) {
            return new SparseIntMatrix3D(slices, rows, columns);
        }
        return new DenseIntMatrix3D(slices, rows, columns);
    }

    public IntMatrix3D make(int slices, int rows, int columns, int initialValue) {
        return this.make(slices, rows, columns).assign(initialValue);
    }

    public IntMatrix3D random(int slices, int rows, int columns) {
        return this.make(slices, rows, columns).assign(IntFunctions.random());
    }
}

