/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.algo.IntFormatter;
import cern.colt.matrix.tint.algo.IntProperty;
import cern.colt.matrix.tint.algo.IntSorting;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class IntMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected IntMatrix1D() {
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix1D.this.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(IntMatrix1D.this.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
            }
        }
        return a;
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix1D.this.getQuick(indexElements[firstIdx]));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            int elem = IntMatrix1D.this.getQuick(indexElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(indexElements[0]));
            for (int i = 1; i < size; ++i) {
                int elem = this.getQuick(indexElements[i]);
                a = aggr.apply(a, f.apply(elem));
            }
        }
        return a;
    }

    public int aggregate(final IntMatrix1D other, final IntIntFunction aggr, final IntIntFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(IntMatrix1D.this.getQuick(i), other.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < this.size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
            }
        }
        return a;
    }

    public IntMatrix1D assign(final IntFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            IntMatrix1D.this.setQuick(i, f.apply(IntMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, f.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntProcedure cond, final IntFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int elem = IntMatrix1D.this.getQuick(i);
                            if (!cond.apply(elem)) continue;
                            IntMatrix1D.this.setQuick(i, f.apply(elem));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                int elem = this.getQuick(i);
                if (!cond.apply(elem)) continue;
                this.setQuick(i, f.apply(elem));
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntProcedure cond, final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int elem = IntMatrix1D.this.getQuick(i);
                            if (!cond.apply(elem)) continue;
                            IntMatrix1D.this.setQuick(i, value);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                int elem = this.getQuick(i);
                if (!cond.apply(elem)) continue;
                this.setQuick(i, value);
            }
        }
        return this;
    }

    public IntMatrix1D assign(final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            IntMatrix1D.this.setQuick(i, value);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, value);
            }
        }
        return this;
    }

    public IntMatrix1D assign(final int[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            IntMatrix1D.this.setQuick(i, values[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, values[i]);
            }
        }
        return this;
    }

    public IntMatrix1D assign(IntMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final IntMatrix1D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            IntMatrix1D.this.setQuick(i, other_loc.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, other_loc.getQuick(i));
            }
        }
        return this;
    }

    public IntMatrix1D assign(final IntMatrix1D y, final IntIntFunction function) {
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            IntMatrix1D.this.setQuick(i, function.apply(IntMatrix1D.this.getQuick(i), y.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
            }
        }
        return this;
    }

    public IntMatrix1D assign(IntMatrix1D y, IntIntFunction function, IntArrayList nonZeroIndexes) {
        this.checkSize(y);
        int[] nonZeroElements = nonZeroIndexes.elements();
        if (function == IntFunctions.mult) {
            int j = 0;
            int index = nonZeroIndexes.size();
            while (--index >= 0) {
                int i = nonZeroElements[index];
                while (j < i) {
                    this.setQuick(j, 0);
                    ++j;
                }
                this.setQuick(i, this.getQuick(i) * y.getQuick(i));
                ++j;
            }
        } else if (function instanceof IntPlusMultSecond) {
            int multiplicator = ((IntPlusMultSecond)function).multiplicator;
            if (multiplicator == 0) {
                return this;
            }
            if (multiplicator == 1) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + y.getQuick(i));
                }
            } else if (multiplicator == -1) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) - y.getQuick(i));
                }
            } else {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + multiplicator * y.getQuick(i));
                }
            }
        } else {
            return this.assign(y, function);
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            if (IntMatrix1D.this.getQuick(i) == 0) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.getQuick(i) == 0) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (this.getQuick(i) == 0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public IntMatrix1D copy() {
        IntMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public abstract Object elements();

    public boolean equals(int value) {
        return IntProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntMatrix1D)) {
            return false;
        }
        return IntProperty.DEFAULT.equals(this, (IntMatrix1D)obj);
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    protected IntMatrix1D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList indexList, IntArrayList valueList) {
        int value;
        indexList.clear();
        valueList.clear();
        int rem = this.size % 2;
        if (rem == 1 && (value = this.getQuick(0)) < 0) {
            indexList.add(0);
            valueList.add(value);
        }
        for (int i = rem; i < this.size; i += 2) {
            int value2 = this.getQuick(i);
            if (value2 < 0) {
                indexList.add(i);
                valueList.add(value2);
            }
            if ((value2 = this.getQuick(i + 1)) >= 0) continue;
            indexList.add(i + 1);
            valueList.add(value2);
        }
    }

    public void getNonZeros(IntArrayList indexList, IntArrayList valueList) {
        int value;
        indexList.clear();
        valueList.clear();
        int rem = this.size % 2;
        if (rem == 1 && (value = this.getQuick(0)) != 0) {
            indexList.add(0);
            valueList.add(value);
        }
        for (int i = rem; i < this.size; i += 2) {
            int value2 = this.getQuick(i);
            if (value2 != 0) {
                indexList.add(i);
                valueList.add(value2);
            }
            if ((value2 = this.getQuick(i + 1)) == 0) continue;
            indexList.add(i + 1);
            valueList.add(value2);
        }
    }

    public void getNonZeros(IntArrayList indexList, IntArrayList valueList, int maxCardinality) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        int currentSize = 0;
        for (int i = 0; i < s; ++i) {
            int value = this.getQuick(i);
            if (value != 0) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
                ++currentSize;
            }
            if (currentSize >= maxCardinality) break;
        }
    }

    public void getPositiveValues(IntArrayList indexList, IntArrayList valueList) {
        int value;
        indexList.clear();
        valueList.clear();
        int rem = this.size % 2;
        if (rem == 1 && (value = this.getQuick(0)) > 0) {
            indexList.add(0);
            valueList.add(value);
        }
        for (int i = rem; i < this.size; i += 2) {
            int value2 = this.getQuick(i);
            if (value2 > 0) {
                indexList.add(i);
                valueList.add(value2);
            }
            if ((value2 = this.getQuick(i + 1)) <= 0) continue;
            indexList.add(i + 1);
            valueList.add(value2);
        }
    }

    public abstract int getQuick(int var1);

    protected boolean haveSharedCells(IntMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(IntMatrix1D other) {
        return false;
    }

    public IntMatrix1D like() {
        return this.like(this.size);
    }

    public abstract IntMatrix1D like(int var1);

    public abstract IntMatrix2D like2D(int var1, int var2);

    public int[] getMaxLocation() {
        int location = 0;
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int location = firstIdx;
                        int maxValue = IntMatrix1D.this.getQuick(location);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            int elem = IntMatrix1D.this.getQuick(i);
                            if (maxValue >= elem) continue;
                            maxValue = elem;
                            location = i;
                        }
                        return new int[]{maxValue, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (int[])futures[j].get();
                }
                maxValue = results[0][0];
                location = results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (maxValue >= results[j][0]) continue;
                    maxValue = results[j][0];
                    location = results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                int elem = this.getQuick(i);
                if (maxValue < elem) {
                    maxValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new int[]{maxValue, location};
    }

    public int[] getMinLocation() {
        int location = 0;
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int location = firstIdx;
                        int minValue = IntMatrix1D.this.getQuick(location);
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            int elem = IntMatrix1D.this.getQuick(i);
                            if (minValue <= elem) continue;
                            minValue = elem;
                            location = i;
                        }
                        return new int[]{minValue, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (int[])futures[j].get();
                }
                minValue = results[0][0];
                location = results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (minValue <= results[j][0]) continue;
                    minValue = results[j][0];
                    location = results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                int elem = this.getQuick(i);
                if (minValue > elem) {
                    minValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new int[]{minValue, location};
    }

    public abstract IntMatrix2D reshape(int var1, int var2);

    public abstract IntMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, int value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, int var2);

    public void setSize(int size) {
        this.size = size;
    }

    public void swap(final IntMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int tmp = IntMatrix1D.this.getQuick(i);
                            IntMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                int tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
            }
        }
    }

    public int[] toArray() {
        int[] values = new int[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(final int[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            values[i] = IntMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                values[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new IntFormatter().toString(this);
    }

    protected IntMatrix1D view() {
        return (IntMatrix1D)this.clone();
    }

    public IntMatrix1D viewFlip() {
        return (IntMatrix1D)this.view().vFlip();
    }

    public IntMatrix1D viewPart(int index, int width) {
        return (IntMatrix1D)this.view().vPart(index, width);
    }

    public IntMatrix1D viewSelection(IntProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!condition.apply(this.getQuick(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public IntMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            offsets[i] = (int)this.index(indexes[i]);
        }
        return this.viewSelectionLike(offsets);
    }

    protected abstract IntMatrix1D viewSelectionLike(int[] var1);

    public IntMatrix1D viewSorted() {
        return IntSorting.mergeSort.sort(this);
    }

    public IntMatrix1D viewStrides(int stride) {
        return (IntMatrix1D)this.view().vStrides(stride);
    }

    public int zDotProduct(IntMatrix1D y) {
        return this.zDotProduct(y, 0, this.size);
    }

    public int zDotProduct(final IntMatrix1D y, final int from, int length) {
        if (from < 0 || length <= 0) {
            return 0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        int sum = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int sum = 0;
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            int idx = k + from;
                            sum += IntMatrix1D.this.getQuick(idx) * y.getQuick(idx);
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = tail - 1;
            int k = length;
            while (--k >= 0) {
                sum += this.getQuick(i) * y.getQuick(i);
                --i;
            }
        }
        return sum;
    }

    public int zDotProduct(IntMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        int index;
        if (from < 0 || length <= 0) {
            return 0;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return 0;
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int s = indexesCopy.size();
        for (index = 0; index < s && nonZeroIndexElements[index] < from; ++index) {
        }
        int sum = 0;
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            sum += this.getQuick(i) * y.getQuick(i);
            ++index;
        }
        return sum;
    }

    protected int zDotProduct(IntMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, this.size, nonZeroIndexes);
    }

    public int zSum() {
        if (this.size() == 0L) {
            return 0;
        }
        return this.aggregate(IntFunctions.plus, IntFunctions.identity);
    }
}

