/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalLongMatrix2D(long[][] values, int dindex) {
        this(values.length, values.length == 0 ? 0 : values[0].length, dindex);
        this.assign(values);
    }

    public DiagonalLongMatrix2D(int rows, int columns, int dindex) {
        int diff;
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (dindex < -rows + 1 || dindex > columns - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = dindex;
        this.dlength = dindex == 0 ? Math.min(rows, columns) : (dindex > 0 ? (rows >= columns ? columns - dindex : (dindex <= (diff = columns - rows) ? rows : rows - (dindex - diff))) : (rows >= columns ? (-dindex <= (diff = rows - columns) ? columns : columns + dindex + diff) : rows + dindex));
        this.elements = new long[this.dlength];
    }

    public LongMatrix2D assign(LongFunction function) {
        if (function instanceof LongMult) {
            long alpha = ((LongMult)function).multiplicator;
            if (alpha == 1L) {
                return this;
            }
            if (alpha == 0L) {
                return this.assign(0L);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int j = this.dlength;
            while (--j >= 0) {
                int n = j;
                this.elements[n] = this.elements[n] * alpha;
            }
        } else {
            int j = this.dlength;
            while (--j >= 0) {
                this.elements[j] = function.apply(this.elements[j]);
            }
        }
        return this;
    }

    public LongMatrix2D assign(long value) {
        int i = this.dlength;
        while (--i >= 0) {
            this.elements[i] = value;
        }
        return this;
    }

    public LongMatrix2D assign(final long[] values) {
        if (values.length != this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            DiagonalLongMatrix2D.this.elements[r] = values[r];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = this.dlength;
            while (--r >= 0) {
                this.elements[r] = values[r];
            }
        }
        return this;
    }

    public LongMatrix2D assign(long[][] values) {
        int c;
        int r;
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            r = 0;
            c = this.dindex;
        } else {
            r = -this.dindex;
            c = 0;
        }
        for (int i = 0; i < this.dlength; ++i) {
            if (values[i].length != this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + values[r].length + "columns()=" + this.columns());
            }
            this.elements[i] = values[r++][c++];
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof DiagonalLongMatrix2D) {
            DiagonalLongMatrix2D other = (DiagonalLongMatrix2D)source;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("source is DiagonalLongMatrix2D with different diagonal stored.");
            }
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(source);
    }

    public LongMatrix2D assign(LongMatrix2D y, final LongLongFunction function) {
        this.checkShape(y);
        if (y instanceof DiagonalLongMatrix2D) {
            long alpha;
            DiagonalLongMatrix2D other = (DiagonalLongMatrix2D)y;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("y is DiagonalLongMatrix2D with different diagonal stored.");
            }
            if (function instanceof LongPlusMultSecond && (alpha = ((LongPlusMultSecond)function).multiplicator) == 0L) {
                return this;
            }
            final long[] otherElements = other.elements;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.dlength);
                Future[] futures = new Future[nthreads];
                int k = this.dlength / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int startrow = j * k;
                    final int stoprow = j == nthreads - 1 ? this.dlength : startrow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (function instanceof LongPlusMultSecond) {
                                long alpha = ((LongPlusMultSecond)function).multiplicator;
                                if (alpha == 1L) {
                                    for (int j = startrow; j < stoprow; ++j) {
                                        int n = j;
                                        DiagonalLongMatrix2D.this.elements[n] = DiagonalLongMatrix2D.this.elements[n] + otherElements[j];
                                    }
                                } else {
                                    for (int j = startrow; j < stoprow; ++j) {
                                        DiagonalLongMatrix2D.this.elements[j] = DiagonalLongMatrix2D.this.elements[j] + alpha * otherElements[j];
                                    }
                                }
                            } else if (function == LongFunctions.mult) {
                                for (int j = startrow; j < stoprow; ++j) {
                                    DiagonalLongMatrix2D.this.elements[j] = DiagonalLongMatrix2D.this.elements[j] * otherElements[j];
                                }
                            } else if (function == LongFunctions.div) {
                                for (int j = startrow; j < stoprow; ++j) {
                                    DiagonalLongMatrix2D.this.elements[j] = DiagonalLongMatrix2D.this.elements[j] / otherElements[j];
                                }
                            } else {
                                for (int j = startrow; j < stoprow; ++j) {
                                    DiagonalLongMatrix2D.this.elements[j] = function.apply(DiagonalLongMatrix2D.this.elements[j], otherElements[j]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else if (function instanceof LongPlusMultSecond) {
                long alpha2 = ((LongPlusMultSecond)function).multiplicator;
                if (alpha2 == 1L) {
                    int j = this.dlength;
                    while (--j >= 0) {
                        int n = j;
                        this.elements[n] = this.elements[n] + otherElements[j];
                    }
                } else {
                    int j = this.dlength;
                    while (--j >= 0) {
                        this.elements[j] = this.elements[j] + alpha2 * otherElements[j];
                    }
                }
            } else if (function == LongFunctions.mult) {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = this.elements[j] * otherElements[j];
                }
            } else if (function == LongFunctions.div) {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = this.elements[j] / otherElements[j];
                }
            } else {
                int j = this.dlength;
                while (--j >= 0) {
                    this.elements[j] = function.apply(this.elements[j], otherElements[j]);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        for (int r = firstRow; r < lastRow; ++r) {
                            if (DiagonalLongMatrix2D.this.elements[r] == 0L) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int r = 0; r < this.dlength; ++r) {
                if (this.elements[r] == 0L) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public long[] elements() {
        return this.elements;
    }

    public boolean equals(long value) {
        for (int r = 0; r < this.dlength; ++r) {
            long x = this.elements[r];
            long diff = value - x;
            if (diff == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DiagonalLongMatrix2D) {
            DiagonalLongMatrix2D other = (DiagonalLongMatrix2D)obj;
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            int rows = this.rows();
            int columns = this.columns();
            if (columns != other.columns() || rows != other.rows()) {
                return false;
            }
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                return false;
            }
            long[] otherElements = other.elements;
            for (int r = 0; r < this.dlength; ++r) {
                long value = otherElements[r];
                long x = this.elements[r];
                long diff = value - x;
                if (diff == 0L) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public LongMatrix2D forEachNonZero(IntIntLongFunction function) {
        int j = this.dlength;
        while (--j >= 0) {
            long value = this.elements[j];
            if (value == 0L) continue;
            this.elements[j] = function.apply(j, j, value);
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    public long[] getMaxLocation() {
        int columnLocation;
        int rowLocation;
        int location = 0;
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int location = firstRow;
                        long maxValue = DiagonalLongMatrix2D.this.elements[location];
                        for (int r = firstRow + 1; r < lastRow; ++r) {
                            long elem = DiagonalLongMatrix2D.this.elements[r];
                            if (maxValue >= elem) continue;
                            maxValue = elem;
                            location = r;
                        }
                        return new long[]{maxValue, location, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (maxValue >= results[j][0]) continue;
                    maxValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[0];
            for (int r = 1; r < this.dlength; ++r) {
                long elem = this.elements[r];
                if (maxValue >= elem) continue;
                maxValue = elem;
                location = r;
            }
        }
        if (this.dindex > 0) {
            rowLocation = location;
            columnLocation = location + this.dindex;
        } else if (this.dindex < 0) {
            rowLocation = location - this.dindex;
            columnLocation = location;
        } else {
            rowLocation = location;
            columnLocation = location;
        }
        return new long[]{maxValue, rowLocation, columnLocation};
    }

    public long[] getMinLocation() {
        int columnLocation;
        int rowLocation;
        int location = 0;
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.dlength / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.dlength : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int location = firstRow;
                        long minValue = DiagonalLongMatrix2D.this.elements[location];
                        for (int r = firstRow + 1; r < lastRow; ++r) {
                            long elem = DiagonalLongMatrix2D.this.elements[r];
                            if (minValue <= elem) continue;
                            minValue = elem;
                            location = r;
                        }
                        return new long[]{minValue, location, location};
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (long[])futures[j].get();
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                for (j = 1; j < nthreads; ++j) {
                    if (minValue <= results[j][0]) continue;
                    minValue = results[j][0];
                    location = (int)results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[0];
            for (int r = 1; r < this.dlength; ++r) {
                long elem = this.elements[r];
                if (minValue <= elem) continue;
                minValue = elem;
                location = r;
            }
        }
        if (this.dindex > 0) {
            rowLocation = location;
            columnLocation = location + this.dindex;
        } else if (this.dindex < 0) {
            rowLocation = location - this.dindex;
            columnLocation = location;
        } else {
            rowLocation = location;
            columnLocation = location;
        }
        return new long[]{minValue, rowLocation, columnLocation};
    }

    public long getQuick(int row, int column) {
        if (this.dindex >= 0) {
            if (column < this.dindex) {
                return 0L;
            }
            if (row < this.dlength && row + this.dindex == column) {
                return this.elements[row];
            }
            return 0L;
        }
        if (row < -this.dindex) {
            return 0L;
        }
        if (column < this.dlength && row + this.dindex == column) {
            return this.elements[column];
        }
        return 0L;
    }

    public LongMatrix2D like(int rows, int columns) {
        return new SparseLongMatrix2D(rows, columns);
    }

    public LongMatrix1D like1D(int size) {
        return new SparseLongMatrix1D(size);
    }

    public void setQuick(int row, int column, long value) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[row] = value;
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[column] = value;
        }
    }

    public LongMatrix1D zMult(LongMatrix1D y, LongMatrix1D z, long alpha, long beta, boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseLongMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseLongMatrix1D && z instanceof DenseLongMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore && beta != 1L) {
            z.assign(LongFunctions.mult(beta));
        }
        DenseLongMatrix1D zz = (DenseLongMatrix1D)z;
        long[] elementsZ = zz.elements;
        int strideZ = zz.stride();
        int zeroZ = (int)z.index(0);
        DenseLongMatrix1D yy = (DenseLongMatrix1D)y;
        long[] elementsY = yy.elements;
        int strideY = yy.stride();
        int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        if (!transposeA) {
            if (this.dindex >= 0) {
                int i = this.dlength;
                while (--i >= 0) {
                    int n = zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[this.dindex + zeroY + strideY * i];
                }
            } else {
                int i = this.dlength;
                while (--i >= 0) {
                    int n = -this.dindex + zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[zeroY + strideY * i];
                }
            }
        } else if (this.dindex >= 0) {
            int i = this.dlength;
            while (--i >= 0) {
                int n = this.dindex + zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[zeroY + strideY * i];
            }
        } else {
            int i = this.dlength;
            while (--i >= 0) {
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * this.elements[i] * elementsY[-this.dindex + zeroY + strideY * i];
            }
        }
        return z;
    }

    protected LongMatrix2D getContent() {
        return this;
    }
}

