/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseColumnObjectMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnObjectMatrix2D
extends ObjectMatrix2D {
    static final long serialVersionUID = 1020177651L;
    protected Object[] elements;

    public DenseColumnObjectMatrix2D(Object[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseColumnObjectMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 1, rows);
        this.elements = new Object[rows * columns];
    }

    public DenseColumnObjectMatrix2D(int rows, int columns, Object[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseColumnObjectMatrix2D.this.elements[zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnObjectMatrix2D.this.columnStride;
                            int r = DenseColumnObjectMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnObjectMatrix2D.this.elements[r * DenseColumnObjectMatrix2D.this.rowStride + cidx]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx]));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, final ObjectProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object elem = DenseColumnObjectMatrix2D.this.elements[zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride];
                        Object a = 0;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnObjectMatrix2D.this.columnStride;
                            int r = DenseColumnObjectMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                elem = DenseColumnObjectMatrix2D.this.elements[r * DenseColumnObjectMatrix2D.this.rowStride + cidx];
                                if (!cond.apply(elem)) continue;
                                a = aggr.apply(a, f.apply(elem));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            Object elem = this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (cond.apply(elem)) {
                a = f.apply(elem);
            }
            int d = 1;
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int r = this.rows - d;
                while (--r >= 0) {
                    elem = this.elements[r * this.rowStride + cidx];
                    if (!cond.apply(elem)) continue;
                    a = aggr.apply(a, f.apply(elem));
                }
                d = 0;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseColumnObjectMatrix2D.this.elements[zero + rowElements[firstIdx - 1] * DenseColumnObjectMatrix2D.this.rowStride + columnElements[firstIdx - 1] * DenseColumnObjectMatrix2D.this.columnStride]);
                        int i = firstIdx - 1;
                        while (--i >= lastIdx) {
                            a = aggr.apply(a, f.apply(DenseColumnObjectMatrix2D.this.elements[zero + rowElements[i] * DenseColumnObjectMatrix2D.this.rowStride + columnElements[i] * DenseColumnObjectMatrix2D.this.columnStride]));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[size - 1] * this.rowStride + columnElements[size - 1] * this.columnStride]);
            int i = size - 1;
            while (--i >= 0) {
                a = aggr.apply(a, f.apply(this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride]));
            }
        }
        return a;
    }

    public Object aggregate(ObjectMatrix2D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        if (!(other instanceof DenseColumnObjectMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final Object[] otherElements = (Object[])other.elements();
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseColumnObjectMatrix2D.this.elements[zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride], otherElements[zeroOther + (DenseColumnObjectMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther]);
                        int d = 1;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int cidx = zero + c * DenseColumnObjectMatrix2D.this.columnStride;
                            int cidxOther = zeroOther + c * columnStrideOther;
                            int r = DenseColumnObjectMatrix2D.this.rows - d;
                            while (--r >= 0) {
                                a = aggr.apply(a, f.apply(DenseColumnObjectMatrix2D.this.elements[r * DenseColumnObjectMatrix2D.this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], otherElements[zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther]);
            int c = this.columns;
            while (--c >= 0) {
                int cidx = zero + c * this.columnStride;
                int cidxOther = zeroOther + c * columnStrideOther;
                int r = this.rows - d;
                while (--r >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[r * this.rowStride + cidx], otherElements[r * rowStrideOther + cidxOther]));
                }
                d = 0;
            }
        }
        return a;
    }

    public ObjectMatrix2D assign(final ObjectFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[i] = function.apply(DenseColumnObjectMatrix2D.this.elements[i]);
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = function.apply(this.elements[i]);
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final ObjectFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                Object elem = DenseColumnObjectMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnObjectMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    Object elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final Object value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                Object elem = DenseColumnObjectMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseColumnObjectMatrix2D.this.elements[i] = value;
                                }
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    Object elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[i] = value;
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = value;
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                            int idxOther = DenseColumnObjectMatrix2D.this.rows - 1 + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.rows;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnObjectMatrix2D.this.rows;
                                while (--r >= 0) {
                                    DenseColumnObjectMatrix2D.this.elements[i] = values[idxOther--];
                                    i -= DenseColumnObjectMatrix2D.this.rowStride;
                                }
                                idx -= DenseColumnObjectMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = values.length - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        this.elements[i] = values[idxOther--];
                        i -= this.rowStride;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "columns()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseColumnObjectMatrix2D.this.rowStride + (DenseColumnObjectMatrix2D.this.columns - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            Object[] currentRow = values[r];
                            if (currentRow.length != DenseColumnObjectMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + DenseColumnObjectMatrix2D.this.columns());
                            }
                            int i = idx;
                            int c = DenseColumnObjectMatrix2D.this.columns;
                            while (--c >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[i] = currentRow[c];
                                i -= DenseColumnObjectMatrix2D.this.columnStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int r = this.rows;
            while (--r >= 0) {
                Object[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + currentRow.length + "columns()=" + this.columns());
                }
                int i = idx;
                int c = this.columns;
                while (--c >= 0) {
                    this.elements[i] = currentRow[c];
                    i -= this.columnStride;
                }
                idx -= this.rowStride;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        if (!(source instanceof DenseColumnObjectMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnObjectMatrix2D other = (DenseColumnObjectMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            ObjectMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnObjectMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnObjectMatrix2D)c;
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final Object[] otherElements = other.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnObjectMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[i] = otherElements[j];
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                                j -= rowStrideOther;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                            idxOther -= columnStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = otherElements[j];
                    i -= this.rowStride;
                    j -= rowStrideOther;
                }
                idx -= this.columnStride;
                idxOther -= columnStrideOther;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D y, final ObjectObjectFunction function) {
        if (!(y instanceof DenseColumnObjectMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnObjectMatrix2D other = (DenseColumnObjectMatrix2D)y;
        this.checkShape(y);
        final Object[] otherElements = other.elements;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int idxOther = zeroOther + (DenseColumnObjectMatrix2D.this.rows - 1) * rowStrideOther + (firstColumn - 1) * columnStrideOther;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                DenseColumnObjectMatrix2D.this.elements[i] = function.apply(DenseColumnObjectMatrix2D.this.elements[i], otherElements[j]);
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                                j -= rowStrideOther;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                            idxOther -= columnStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxOther = zeroOther + (this.rows - 1) * rowStrideOther + (this.columns - 1) * columnStrideOther;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxOther;
                int r = this.rows;
                while (--r >= 0) {
                    this.elements[i] = function.apply(this.elements[i], otherElements[j]);
                    i -= this.rowStride;
                    j -= rowStrideOther;
                }
                idx -= this.columnStride;
                idxOther -= columnStrideOther;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D y, final ObjectObjectFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        if (!(y instanceof DenseColumnObjectMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseColumnObjectMatrix2D other = (DenseColumnObjectMatrix2D)y;
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final Object[] otherElements = other.elements();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = size - j * k;
                final int lastIdx = j == nthreads - 1 ? 0 : firstIdx - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i = firstIdx;
                        while (--i >= lastIdx) {
                            int idx = zero + rowElements[i] * DenseColumnObjectMatrix2D.this.rowStride + columnElements[i] * DenseColumnObjectMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseColumnObjectMatrix2D.this.elements[idx] = function.apply(DenseColumnObjectMatrix2D.this.elements[idx], otherElements[idxOther]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = size;
            while (--i >= 0) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], otherElements[idxOther]);
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                if (DenseColumnObjectMatrix2D.this.elements[i] != null) {
                                    ++cardinality;
                                }
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    if (this.elements[i] != null) {
                        ++cardinality;
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return cardinality;
    }

    public Object[] elements() {
        return this.elements;
    }

    public ObjectMatrix2D forEachNonZero(final IntIntObjectFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                Object value = DenseColumnObjectMatrix2D.this.elements[i];
                                if (value != null) {
                                    DenseColumnObjectMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    Object value = this.elements[i];
                    if (value != null) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return this;
    }

    public DenseObjectMatrix2D getRowMajor() {
        DenseObjectMatrix2D R = new DenseObjectMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final Object[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int idxR = zeroR + (DenseColumnObjectMatrix2D.this.rows - 1) * rowStrideR + (firstColumn - 1) * columnStrideR;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int j = idxR;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                elementsR[j] = DenseColumnObjectMatrix2D.this.elements[i];
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                                j -= rowStrideR;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                            idxR -= columnStrideR;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int idxR = zeroR + (this.rows - 1) * rowStrideR + (this.columns - 1) * columnStrideR;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int j = idxR;
                int r = this.rows;
                while (--r >= 0) {
                    elementsR[j] = this.elements[i];
                    i -= this.rowStride;
                    j -= rowStrideR;
                }
                idx -= this.columnStride;
                idxR -= columnStrideR;
            }
        }
        return R;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int c = 0; c < this.columns; ++c) {
            int i = idx;
            for (int r = 0; r < this.rows; ++r) {
                Object value = this.elements[i];
                if (value != null) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
            }
            idx += this.columnStride;
        }
    }

    public Object getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new DenseColumnObjectMatrix2D(rows, columns);
    }

    public ObjectMatrix1D like1D(int size) {
        return new DenseObjectMatrix1D(size);
    }

    public void setQuick(int row, int column, Object value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    public Object[][] toArray() {
        final Object[][] values = new Object[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = this.columns - j * k;
                final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (--c >= lastColumn) {
                            int i = idx;
                            int r = DenseColumnObjectMatrix2D.this.rows;
                            while (--r >= 0) {
                                values[r][c] = DenseColumnObjectMatrix2D.this.elements[i];
                                i -= DenseColumnObjectMatrix2D.this.rowStride;
                            }
                            idx -= DenseColumnObjectMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int c = this.columns;
            while (--c >= 0) {
                int i = idx;
                int r = this.rows;
                while (--r >= 0) {
                    values[r][c] = this.elements[i];
                    i -= this.rowStride;
                }
                idx -= this.columnStride;
            }
        }
        return values;
    }

    public ObjectMatrix1D vectorize() {
        int size = (int)this.size();
        DenseObjectMatrix1D v = new DenseObjectMatrix1D(size);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((ObjectMatrix1D)v).elements(), 0, size);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final Object[] elementsOther = (Object[])((ObjectMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstColumn = this.columns - j * k;
                    final int lastColumn = j == nthreads - 1 ? 0 : firstColumn - k;
                    final int firstIdxOther = size - j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + (DenseColumnObjectMatrix2D.this.rows - 1) * DenseColumnObjectMatrix2D.this.rowStride + (firstColumn - 1) * DenseColumnObjectMatrix2D.this.columnStride;
                            int idxOther = zeroOther + (firstIdxOther - 1) * strideOther;
                            int c = firstColumn;
                            while (--c >= lastColumn) {
                                int i = idx;
                                int r = DenseColumnObjectMatrix2D.this.rows;
                                while (--r >= 0) {
                                    elementsOther[idxOther] = DenseColumnObjectMatrix2D.this.elements[i];
                                    i -= DenseColumnObjectMatrix2D.this.rowStride;
                                    idxOther -= strideOther;
                                }
                                idx -= DenseColumnObjectMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int idxOther = zeroOther + size - 1;
                int c = this.columns;
                while (--c >= 0) {
                    int i = idx;
                    int r = this.rows;
                    while (--r >= 0) {
                        elementsOther[idxOther] = this.elements[i];
                        i -= this.rowStride;
                        --idxOther;
                    }
                    idx -= this.columnStride;
                }
            }
        }
        return v;
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedDenseColumnObjectMatrix2D) {
            SelectedDenseColumnObjectMatrix2D otherMatrix = (SelectedDenseColumnObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnObjectMatrix2D) {
            DenseColumnObjectMatrix2D otherMatrix = (DenseColumnObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    protected ObjectMatrix1D like1D(int size, int zero, int stride) {
        return new DenseObjectMatrix1D(size, this.elements, zero, stride, true);
    }

    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnObjectMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

