/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfcomplex;

import cern.jet.math.tfloat.FloatConstants;

public class FComplex
extends FloatConstants {
    public static final float abs(float[] x) {
        float absX = Math.abs(x[0]);
        float absY = Math.abs(x[1]);
        if ((double)absX == 0.0 && (double)absY == 0.0) {
            return 0.0f;
        }
        if (absX >= absY) {
            float d = x[1] / x[0];
            return (float)((double)absX * Math.sqrt(1.0 + (double)(d * d)));
        }
        float d = x[0] / x[1];
        return (float)((double)absY * Math.sqrt(1.0 + (double)(d * d)));
    }

    public static final float abs(float re, float im) {
        float absX = Math.abs(re);
        float absY = Math.abs(im);
        if ((double)absX == 0.0 && (double)absY == 0.0) {
            return 0.0f;
        }
        if (absX >= absY) {
            float d = im / re;
            return (float)((double)absX * Math.sqrt(1.0 + (double)(d * d)));
        }
        float d = re / im;
        return (float)((double)absY * Math.sqrt(1.0 + (double)(d * d)));
    }

    public static final float[] acos(float[] x) {
        float[] z = new float[2];
        float re = (float)(1.0 - (double)(x[0] * x[0] - x[1] * x[1]));
        float im = -(x[0] * x[1] + x[1] * x[0]);
        z[0] = re;
        z[1] = im;
        z = FComplex.sqrt(z);
        re = -z[1];
        im = z[0];
        z[0] = x[0] + re;
        z[1] = x[1] + im;
        re = (float)Math.log(FComplex.abs(z));
        z[0] = im = (float)Math.atan2(z[1], z[0]);
        z[1] = -re;
        return z;
    }

    public static final float arg(float[] x) {
        return (float)Math.atan2(x[1], x[0]);
    }

    public static final float arg(float re, float im) {
        return (float)Math.atan2(im, re);
    }

    public static final float[] asin(float[] x) {
        float[] z = new float[2];
        float re = (float)(1.0 - (double)(x[0] * x[0] - x[1] * x[1]));
        float im = -(x[0] * x[1] + x[1] * x[0]);
        z[0] = re;
        z[1] = im;
        z = FComplex.sqrt(z);
        re = -z[1];
        im = z[0];
        z[0] = z[0] + re;
        z[1] = z[1] + im;
        re = (float)Math.log(FComplex.abs(z));
        z[0] = im = (float)Math.atan2(z[1], z[0]);
        z[1] = -re;
        return z;
    }

    public static final float[] atan(float[] x) {
        float[] z = new float[]{-x[0], 1.0f - x[1]};
        float re = x[0];
        float im = 1.0f + x[1];
        z = FComplex.div(z, re, im);
        re = (float)Math.log(FComplex.abs(z));
        im = (float)Math.atan2(z[1], z[0]);
        z[0] = 0.5f * im;
        z[1] = -0.5f * re;
        return z;
    }

    public static final float[] conj(float[] x) {
        float[] z = new float[]{x[0], -x[1]};
        return z;
    }

    public static final float[] cos(float[] x) {
        float[] z = new float[2];
        float iz_re = -x[1];
        float iz_im = x[0];
        float scalar = (float)Math.exp(iz_re);
        float re1 = (float)((double)scalar * Math.cos(iz_im));
        float im1 = (float)((double)scalar * Math.sin(iz_im));
        scalar = (float)Math.exp(-iz_re);
        float re2 = (float)((double)scalar * Math.cos(-iz_im));
        float im2 = (float)((double)scalar * Math.sin(-iz_im));
        z[0] = 0.5f * (re1 += re2);
        z[1] = 0.5f * (im1 += im2);
        return z;
    }

    public static final float[] div(float[] x, float re, float im) {
        float[] z = new float[2];
        if (Math.abs(re) >= Math.abs(im)) {
            float scalar = (float)(1.0 / (double)(re + im * (im / re)));
            z[0] = scalar * (x[0] + x[1] * (im / re));
            z[1] = scalar * (x[1] - x[0] * (im / re));
        } else {
            float scalar = (float)(1.0 / (double)(re * (re / im) + im));
            z[0] = scalar * (x[0] * (re / im) + x[1]);
            z[1] = scalar * (x[1] * (re / im) - x[0]);
        }
        return z;
    }

    public static final float[] div(float[] x, float[] y) {
        return FComplex.div(x, y[0], y[1]);
    }

    public static final float equals(float[] x, float[] y, float tol) {
        if (FComplex.abs(x[0] - y[0], x[1] - y[1]) <= Math.abs(tol)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static final boolean isEqual(float[] x, float[] y, float tol) {
        return FComplex.abs(x[0] - y[0], x[1] - y[1]) <= Math.abs(tol);
    }

    public static final float[] exp(float[] x) {
        float[] z = new float[2];
        float scalar = (float)Math.exp(x[0]);
        z[0] = (float)((double)scalar * Math.cos(x[1]));
        z[1] = (float)((double)scalar * Math.sin(x[1]));
        return z;
    }

    public static final float[] inv(float[] x) {
        float[] z = new float[2];
        if ((double)x[1] != 0.0) {
            if (Math.abs(x[0]) >= Math.abs(x[1])) {
                float scalar;
                z[0] = scalar = (float)(1.0 / (double)(x[0] + x[1] * (x[1] / x[0])));
                z[1] = scalar * (-x[1] / x[0]);
            } else {
                float scalar = (float)(1.0 / (double)(x[0] * (x[0] / x[1]) + x[1]));
                z[0] = scalar * (x[0] / x[1]);
                z[1] = -scalar;
            }
        } else {
            z[0] = 1.0f / x[0];
            z[1] = 0.0f;
        }
        return z;
    }

    public static final float[] log(float[] x) {
        float[] z = new float[]{(float)Math.log(FComplex.abs(x)), FComplex.arg(x)};
        return z;
    }

    public static final float[] minus(float[] x, float[] y) {
        float[] z = new float[]{x[0] - y[0], x[1] - y[1]};
        return z;
    }

    public static final float[] minusAbs(float[] x, float[] y) {
        float[] z = new float[]{Math.abs(x[0] - y[0]), Math.abs(x[1] - y[1])};
        return z;
    }

    public static final float[] mult(float[] x, float y) {
        float[] z = new float[]{x[0] * y, x[1] * y};
        return z;
    }

    public static final float[] mult(float[] x, float[] y) {
        float[] z = new float[]{x[0] * y[0] - x[1] * y[1], x[1] * y[0] + x[0] * y[1]};
        return z;
    }

    public static final float[] neg(float[] x) {
        float[] z = new float[]{-x[0], -x[1]};
        return z;
    }

    public static final float[] plus(float[] x, float[] y) {
        float[] z = new float[]{x[0] + y[0], x[1] + y[1]};
        return z;
    }

    public static final float[] pow(float[] x, float y) {
        float[] z = new float[2];
        float re = (float)((double)y * Math.log(FComplex.abs(x)));
        float im = y * FComplex.arg(x);
        float scalar = (float)Math.exp(re);
        z[0] = (float)((double)scalar * Math.cos(im));
        z[1] = (float)((double)scalar * Math.sin(im));
        return z;
    }

    public static final float[] pow(float x, float[] y) {
        float[] z = new float[2];
        float re = (float)Math.log(Math.abs(x));
        float im = (float)Math.atan2(0.0, x);
        float re2 = re * y[0] - im * y[1];
        float im2 = re * y[1] + im * y[0];
        float scalar = (float)Math.exp(re2);
        z[0] = (float)((double)scalar * Math.cos(im2));
        z[1] = (float)((double)scalar * Math.sin(im2));
        return z;
    }

    public static final float[] pow(float[] x, float[] y) {
        float[] z = new float[2];
        float re = (float)Math.log(FComplex.abs(x));
        float im = FComplex.arg(x);
        float re2 = re * y[0] - im * y[1];
        float im2 = re * y[1] + im * y[0];
        float scalar = (float)Math.exp(re2);
        z[0] = (float)((double)scalar * Math.cos(im2));
        z[1] = (float)((double)scalar * Math.sin(im2));
        return z;
    }

    public static final float[] sin(float[] x) {
        float[] z = new float[2];
        float iz_re = -x[1];
        float iz_im = x[0];
        float scalar = (float)Math.exp(iz_re);
        float re1 = (float)((double)scalar * Math.cos(iz_im));
        float im1 = (float)((double)scalar * Math.sin(iz_im));
        scalar = (float)Math.exp(-iz_re);
        float re2 = (float)((double)scalar * Math.cos(-iz_im));
        float im2 = (float)((double)scalar * Math.sin(-iz_im));
        z[0] = 0.5f * (im1 -= im2);
        z[1] = -0.5f * (re1 -= re2);
        return z;
    }

    public static final float[] sqrt(float[] x) {
        float[] z = new float[2];
        float absx = FComplex.abs(x);
        if ((double)absx > 0.0) {
            if ((double)x[0] > 0.0) {
                float tmp;
                z[0] = tmp = (float)Math.sqrt(0.5 * (double)(absx + x[0]));
                z[1] = 0.5f * (x[1] / tmp);
            } else {
                float tmp = (float)Math.sqrt(0.5 * (double)(absx - x[0]));
                if ((double)x[1] < 0.0) {
                    tmp = -tmp;
                }
                z[0] = 0.5f * (x[1] / tmp);
                z[1] = tmp;
            }
        } else {
            z[0] = 0.0f;
            z[1] = 0.0f;
        }
        return z;
    }

    public static final float[] square(float[] x) {
        return FComplex.mult(x, x);
    }

    public static final float[] tan(float[] x) {
        float[] z = new float[2];
        float iz_re = -x[1];
        float iz_im = x[0];
        float scalar = (float)Math.exp(iz_re);
        float re1 = (float)((double)scalar * Math.cos(iz_im));
        float im1 = (float)((double)scalar * Math.sin(iz_im));
        scalar = (float)Math.exp(-iz_re);
        float re2 = (float)((double)scalar * Math.cos(-iz_im));
        float im2 = (float)((double)scalar * Math.sin(-iz_im));
        float re3 = re1 - re2;
        float im3 = im1 - im2;
        z[0] = 0.5f * im3;
        z[1] = -0.5f * re3;
        re3 = re1 + re2;
        im3 = im1 + im2;
        float cs_re = 0.5f * re3;
        float cs_im = 0.5f * im3;
        z = FComplex.div(z, cs_re, cs_im);
        return z;
    }

    protected FComplex() {
    }
}

