/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tchar;

import cern.colt.PersistentObject;
import cern.colt.buffer.tchar.CharBufferConsumer;
import cern.colt.list.tchar.CharArrayList;

public class CharBuffer
extends PersistentObject
implements CharBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected CharBufferConsumer target;
    protected char[] elements;
    protected CharArrayList list;
    protected int capacity;
    protected int size;

    public CharBuffer(CharBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new char[capacity];
        this.list = new CharArrayList(this.elements);
        this.size = 0;
    }

    public void add(char element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    public void addAllOf(CharArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

