/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1DProcedure;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DComplexMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected DComplexMatrix2D() {
    }

    public double[] aggregate(final DComplexDComplexDComplexFunction aggr, final DComplexDComplexFunction f) {
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] a = f.apply(DComplexMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DComplexMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DComplexMatrix2D.this.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public double[] aggregate(final DComplexMatrix2D other, final DComplexDComplexDComplexFunction aggr, final DComplexDComplexDComplexFunction f) {
        this.checkShape(other);
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] a = f.apply(DComplexMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DComplexMatrix2D.this.columns; ++c) {
                                a = aggr.apply(a, f.apply(DComplexMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                }
                d = 0;
            }
        }
        return a;
    }

    public DComplexMatrix2D assign(final DComplexDComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, f.apply(DComplexMatrix2D.this.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexProcedure cond, final DComplexDComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double[] elem = DComplexMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                DComplexMatrix2D.this.setQuick(r, c, f.apply(elem));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double[] elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, f.apply(elem));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexProcedure cond, final double[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double[] elem = DComplexMatrix2D.this.getQuick(r, c);
                                if (!cond.apply(elem)) continue;
                                DComplexMatrix2D.this.setQuick(r, c, value);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double[] elem = this.getQuick(r, c);
                    if (!cond.apply(elem)) continue;
                    this.setQuick(r, c, value);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexRealFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double re = f.apply(DComplexMatrix2D.this.getQuick(r, c));
                                DComplexMatrix2D.this.setQuick(r, c, re, 0.0);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double re = f.apply(this.getQuick(r, c));
                    this.setQuick(r, c, re, 0.0);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final DComplexMatrix2D otherLoc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, otherLoc.getQuick(r, c));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, otherLoc.getQuick(r, c));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexMatrix2D y, final DComplexDComplexDComplexFunction f) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, f.apply(DComplexMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, f.apply(this.getQuick(r, c), y.getQuick(r, c)));
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final DComplexMatrix2D y, final DComplexDComplexDComplexFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(DComplexMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final double re, final double im) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, re, im);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, re, im);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final double[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = firstRow * DComplexMatrix2D.this.columns * 2;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, values[idx], values[idx + 1]);
                                idx += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx], values[idx + 1]);
                    idx += 2;
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final double[][] values) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            double[] currentRow = values[r];
                            if (currentRow.length != 2 * DComplexMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * DComplexMatrix2D.this.columns());
                            }
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                double[] currentRow = values[r];
                if (currentRow.length != 2 * this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * this.columns());
                }
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(final float[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = firstRow * DComplexMatrix2D.this.columns * 2;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                DComplexMatrix2D.this.setQuick(r, c, values[idx], values[idx + 1]);
                                idx += 2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    this.setQuick(r, c, values[idx], values[idx + 1]);
                    idx += 2;
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assignImaginary(final DoubleMatrix2D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double re = DComplexMatrix2D.this.getQuick(r, c)[0];
                                double im = other.getQuick(r, c);
                                DComplexMatrix2D.this.setQuick(r, c, re, im);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double re = this.getQuick(r, c)[0];
                    double im = other.getQuick(r, c);
                    this.setQuick(r, c, re, im);
                }
            }
        }
        return this;
    }

    public DComplexMatrix2D assignReal(final DoubleMatrix2D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double re = other.getQuick(r, c);
                                double im = DComplexMatrix2D.this.getQuick(r, c)[1];
                                DComplexMatrix2D.this.setQuick(r, c, re, im);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double re = other.getQuick(r, c);
                    double im = this.getQuick(r, c)[1];
                    this.setQuick(r, c, re, im);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        double[] tmp = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                tmp = DComplexMatrix2D.this.getQuick(r, c);
                                if (tmp[0] == 0.0 && tmp[1] == 0.0) continue;
                                ++cardinality;
                            }
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            double[] tmp = new double[2];
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    tmp = this.getQuick(r, c);
                    if (tmp[0] == 0.0 && tmp[1] == 0.0) continue;
                    ++cardinality;
                }
            }
        }
        return cardinality;
    }

    public DComplexMatrix2D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double[] value) {
        return DComplexProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DComplexMatrix2D)) {
            return false;
        }
        return DComplexProperty.DEFAULT.equals(this, (DComplexMatrix2D)obj);
    }

    public DComplexMatrix2D forEachNonZero(final IntIntDComplexFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double[] value = DComplexMatrix2D.this.getQuick(r, c);
                                if (value[0] == 0.0 && value[1] == 0.0) continue;
                                double[] v = function.apply(r, c, value);
                                DComplexMatrix2D.this.setQuick(r, c, v);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double[] value = this.getQuick(r, c);
                    if (value[0] == 0.0 && value[1] == 0.0) continue;
                    double[] v = function.apply(r, c, value);
                    this.setQuick(r, c, v);
                }
            }
        }
        return this;
    }

    public double[] get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    public DComplexMatrix2D getConjugateTranspose() {
        final DComplexMatrix2D transpose = this.viewDice().copy();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.columns : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] tmp = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.rows; ++c) {
                                tmp = transpose.getQuick(r, c);
                                tmp[1] = -tmp[1];
                                transpose.setQuick(r, c, tmp);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] tmp = new double[2];
            for (int r = 0; r < this.columns; ++r) {
                for (int c = 0; c < this.rows; ++c) {
                    tmp = transpose.getQuick(r, c);
                    tmp[1] = -tmp[1];
                    transpose.setQuick(r, c, tmp);
                }
            }
        }
        return transpose;
    }

    public abstract Object elements();

    public abstract DoubleMatrix2D getImaginaryPart();

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ArrayList<double[]> valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                double[] value = this.getQuick(r, c);
                if (value[0] == 0.0 && value[1] == 0.0) continue;
                rowList.add(r);
                columnList.add(c);
                valueList.add(value);
            }
        }
    }

    public abstract double[] getQuick(int var1, int var2);

    public abstract DoubleMatrix2D getRealPart();

    public DComplexMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DComplexMatrix2D like(int var1, int var2);

    public abstract DComplexMatrix1D like1D(int var1);

    public void set(int row, int column, double[] value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public void set(int row, int column, double re, double im) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, re, im);
    }

    public abstract void setQuick(int var1, int var2, double var3, double var5);

    public abstract void setQuick(int var1, int var2, double[] var3);

    public double[][] toArray() {
        final double[][] values = new double[this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                double[] tmp = DComplexMatrix2D.this.getQuick(r, c);
                                values[r][2 * c] = tmp[0];
                                values[r][2 * c + 1] = tmp[1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    double[] tmp = this.getQuick(r, c);
                    values[r][2 * c] = tmp[0];
                    values[r][2 * c + 1] = tmp[1];
                }
            }
        }
        return values;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String format) {
        StringBuffer s = new StringBuffer(String.format("ComplexMatrix2D: %d rows, %d columns\n\n", this.rows, this.columns));
        double[] elem = new double[2];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                elem = this.getQuick(r, c);
                if (elem[1] == 0.0) {
                    s.append(String.format(format + "\t", elem[0]));
                    continue;
                }
                if (elem[0] == 0.0) {
                    s.append(String.format(format + "i\t", elem[1]));
                    continue;
                }
                if (elem[1] < 0.0) {
                    s.append(String.format(format + " - " + format + "i\t", elem[0], -elem[1]));
                    continue;
                }
                s.append(String.format(format + " + " + format + "i\t", elem[0], elem[1]));
            }
            s.append("\n");
        }
        return s.toString();
    }

    public abstract DComplexMatrix1D vectorize();

    public DComplexMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DComplexMatrix2D viewColumnFlip() {
        return (DComplexMatrix2D)this.view().vColumnFlip();
    }

    public DComplexMatrix2D viewDice() {
        return (DComplexMatrix2D)this.view().vDice();
    }

    public DComplexMatrix2D viewPart(int row, int column, int height, int width) {
        return (DComplexMatrix2D)this.view().vPart(row, column, height, width);
    }

    public DComplexMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public DComplexMatrix2D viewRowFlip() {
        return (DComplexMatrix2D)this.view().vRowFlip();
    }

    public DComplexMatrix2D viewSelection(DComplexMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!condition.apply(this.viewRow(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    public DComplexMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        int i2;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            for (i2 = 0; i2 < this.rows; ++i2) {
                rowIndexes[i2] = i2;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            for (i2 = 0; i2 < this.columns; ++i2) {
                columnIndexes[i2] = i2;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        for (i = 0; i < rowIndexes.length; ++i) {
            rowOffsets[i] = this._rowOffset(this._rowRank(rowIndexes[i]));
        }
        for (i = 0; i < columnIndexes.length; ++i) {
            columnOffsets[i] = this._columnOffset(this._columnRank(columnIndexes[i]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public DComplexMatrix2D viewStrides(int rowStride, int columnStride) {
        return (DComplexMatrix2D)this.view().vStrides(rowStride, columnStride);
    }

    public DComplexMatrix1D zMult(DComplexMatrix1D y, DComplexMatrix1D z) {
        double[] dArray;
        double[] dArray2 = new double[]{1.0, 0.0};
        if (z == null) {
            double[] dArray3 = new double[2];
            dArray3[0] = 1.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        } else {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        }
        return this.zMult(y, z, dArray2, dArray, false);
    }

    public DComplexMatrix1D zMult(final DComplexMatrix1D y, DComplexMatrix1D z, final double[] alpha, final double[] beta, boolean transposeA) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(y, z, alpha, beta, false);
        }
        final DComplexMatrix1D zz = z == null ? y.like(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] s = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            s[0] = 0.0;
                            s[1] = 0.0;
                            for (int c = 0; c < DComplexMatrix2D.this.columns; ++c) {
                                s = DComplex.plus(s, DComplex.mult(DComplexMatrix2D.this.getQuick(r, c), y.getQuick(c)));
                            }
                            zz.setQuick(r, DComplex.plus(DComplex.mult(s, alpha), DComplex.mult(zz.getQuick(r), beta)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] s = new double[2];
            for (int r = 0; r < this.rows; ++r) {
                s[0] = 0.0;
                s[1] = 0.0;
                for (int c = 0; c < this.columns; ++c) {
                    s = DComplex.plus(s, DComplex.mult(this.getQuick(r, c), y.getQuick(c)));
                }
                zz.setQuick(r, DComplex.plus(DComplex.mult(s, alpha), DComplex.mult(zz.getQuick(r), beta)));
            }
        }
        return zz;
    }

    public DComplexMatrix2D zMult(DComplexMatrix2D B, DComplexMatrix2D C) {
        double[] dArray;
        double[] dArray2 = new double[]{1.0, 0.0};
        if (C == null) {
            double[] dArray3 = new double[2];
            dArray3[0] = 1.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        } else {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.0;
            dArray = dArray4;
            dArray4[1] = 0.0;
        }
        return this.zMult(B, C, dArray2, dArray, false, false);
    }

    public DComplexMatrix2D zMult(final DComplexMatrix2D B, DComplexMatrix2D C, final double[] alpha, final double[] beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        final int m = this.rows;
        final int n = this.columns;
        int p = B.columns;
        final DComplexMatrix2D CC = C == null ? this.like(m, p) : C;
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (CC.rows != m || CC.columns != p) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + CC.toStringShort());
        }
        if (this == CC || B == CC) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, p);
            Future[] futures = new Future[nthreads];
            int k = p / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? p : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] s = new double[2];
                        for (int a = firstIdx; a < lastIdx; ++a) {
                            for (int b = 0; b < m; ++b) {
                                s[0] = 0.0;
                                s[1] = 0.0;
                                for (int c = 0; c < n; ++c) {
                                    s = DComplex.plus(s, DComplex.mult(DComplexMatrix2D.this.getQuick(b, c), B.getQuick(c, a)));
                                }
                                CC.setQuick(b, a, DComplex.plus(DComplex.mult(s, alpha), DComplex.mult(CC.getQuick(b, a), beta)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] s = new double[2];
            for (int a = 0; a < p; ++a) {
                for (int b = 0; b < m; ++b) {
                    s[0] = 0.0;
                    s[1] = 0.0;
                    for (int c = 0; c < n; ++c) {
                        s = DComplex.plus(s, DComplex.mult(this.getQuick(b, c), B.getQuick(c, a)));
                    }
                    CC.setQuick(b, a, DComplex.plus(DComplex.mult(s, alpha), DComplex.mult(CC.getQuick(b, a), beta)));
                }
            }
        }
        return CC;
    }

    public double[] zSum() {
        if (this.size() == 0L) {
            return new double[]{0.0, 0.0};
        }
        return this.aggregate(DComplexFunctions.plus, DComplexFunctions.identity);
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DComplexMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix2D other) {
        return false;
    }

    protected abstract DComplexMatrix1D like1D(int var1, int var2, int var3);

    protected DComplexMatrix2D view() {
        return (DComplexMatrix2D)this.clone();
    }

    protected abstract DComplexMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

