/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseDComplexMatrix2D
extends DComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    protected double[] elements;

    public DenseDComplexMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length / 2);
        this.assign(values);
    }

    public DenseDComplexMatrix2D(DoubleMatrix2D realPart) {
        this(realPart.rows(), realPart.columns());
        this.assignReal(realPart);
    }

    public DenseDComplexMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 2 * columns, 2);
        this.elements = new double[rows * 2 * columns];
    }

    public DenseDComplexMatrix2D(int rows, int columns, double[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isNoView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction aggr, final DComplexDComplexFunction f) {
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        double[] a = f.apply(DenseDComplexMatrix2D.this.elements[idx], DenseDComplexMatrix2D.this.elements[idx + 1]);
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                idx = zero + r * DenseDComplexMatrix2D.this.rowStride + c * DenseDComplexMatrix2D.this.columnStride;
                                a = aggr.apply(a, f.apply(DenseDComplexMatrix2D.this.elements[idx], DenseDComplexMatrix2D.this.elements[idx + 1]));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero], this.elements[zero + 1]);
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    a = aggr.apply(a, f.apply(this.elements[idx], this.elements[idx + 1]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public double[] aggregate(DComplexMatrix2D other, final DComplexDComplexDComplexFunction aggr, final DComplexDComplexDComplexFunction f) {
        if (!(other instanceof DenseDComplexMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final double[] elemsOther = (double[])other.elements();
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        double[] a = f.apply(new double[]{DenseDComplexMatrix2D.this.elements[idx], DenseDComplexMatrix2D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int d = 1;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = d; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                idx = zero + r * DenseDComplexMatrix2D.this.rowStride + c * DenseDComplexMatrix2D.this.columnStride;
                                idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                                a = aggr.apply(a, f.apply(new double[]{DenseDComplexMatrix2D.this.elements[idx], DenseDComplexMatrix2D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                            }
                            d = 0;
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new double[]{this.elements[zero], this.elements[zero + 1]}, new double[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int d = 1;
            for (int r = 0; r < this.rows; ++r) {
                for (int c = d; c < this.columns; ++c) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    int idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                    a = aggr.apply(a, f.apply(new double[]{this.elements[idx], this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexDComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof DComplexMult) {
                double[] multiplicator = ((DComplexMult)function).multiplicator;
                if (multiplicator[0] == 1.0 && multiplicator[1] == 0.0) {
                    return this;
                }
                if (multiplicator[0] == 0.0 && multiplicator[1] == 0.0) {
                    return this.assign(0.0, 0.0);
                }
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        double[] tmp = new double[2];
                        if (function instanceof DComplexMult) {
                            double[] multiplicator = ((DComplexMult)function).multiplicator;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    DenseDComplexMatrix2D.this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp = function.apply(DenseDComplexMatrix2D.this.elements[i], DenseDComplexMatrix2D.this.elements[i + 1]);
                                    DenseDComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = tmp[1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            double[] tmp = new double[2];
            if (function instanceof DComplexMult) {
                double[] multiplicator = ((DComplexMult)function).multiplicator;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                        this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp = function.apply(this.elements[i], this.elements[i + 1]);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = tmp[1];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure cond, final DComplexDComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] elem = new double[2];
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                elem[0] = DenseDComplexMatrix2D.this.elements[i];
                                elem[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    elem = function.apply(elem);
                                    DenseDComplexMatrix2D.this.elements[i] = elem[0];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = elem[1];
                                }
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        elem = function.apply(elem);
                        this.elements[i] = elem[0];
                        this.elements[i + 1] = elem[1];
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure cond, final double[] value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        double[] elem = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                elem[0] = DenseDComplexMatrix2D.this.elements[i];
                                elem[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    DenseDComplexMatrix2D.this.elements[i] = value[0];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = value[1];
                                }
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        this.elements[i] = value[0];
                        this.elements[i + 1] = value[1];
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexRealFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        double[] tmp = new double[2];
                        if (function == DComplexFunctions.abs) {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    double d;
                                    tmp[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    double absX = Math.abs(DenseDComplexMatrix2D.this.elements[i]);
                                    double absY = Math.abs(DenseDComplexMatrix2D.this.elements[i + 1]);
                                    if (absX == 0.0 && absY == 0.0) {
                                        DenseDComplexMatrix2D.this.elements[i] = 0.0;
                                    } else if (absX >= absY) {
                                        d = tmp[1] / tmp[0];
                                        DenseDComplexMatrix2D.this.elements[i] = absX * Math.sqrt(1.0 + d * d);
                                    } else {
                                        d = tmp[0] / tmp[1];
                                        DenseDComplexMatrix2D.this.elements[i] = absY * Math.sqrt(1.0 + d * d);
                                    }
                                    DenseDComplexMatrix2D.this.elements[i + 1] = 0.0;
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                            }
                        } else {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    tmp[0] = function.apply(tmp);
                                    DenseDComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = 0.0;
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            double[] tmp = new double[2];
            if (function == DComplexFunctions.abs) {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        double d;
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        double absX = Math.abs(tmp[0]);
                        double absY = Math.abs(tmp[1]);
                        if (absX == 0.0 && absY == 0.0) {
                            this.elements[i] = 0.0;
                        } else if (absX >= absY) {
                            d = tmp[1] / tmp[0];
                            this.elements[i] = absX * Math.sqrt(1.0 + d * d);
                        } else {
                            d = tmp[0] / tmp[1];
                            this.elements[i] = absY * Math.sqrt(1.0 + d * d);
                        }
                        this.elements[i + 1] = 0.0;
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        tmp[0] = function.apply(tmp);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = 0.0;
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D source) {
        if (!(source instanceof DenseDComplexMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseDComplexMatrix2D other = (DenseDComplexMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DComplexMatrix2D c = other.copy();
            if (!(c instanceof DenseDComplexMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseDComplexMatrix2D)c;
        }
        final double[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                DenseDComplexMatrix2D.this.elements[i] = elemsOther[j];
                                DenseDComplexMatrix2D.this.elements[i + 1] = elemsOther[j + 1];
                                i += DenseDComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = elemsOther[j];
                    this.elements[i + 1] = elemsOther[j + 1];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D y, final DComplexDComplexDComplexFunction function) {
        if (!(y instanceof DenseDComplexMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final double[] elemsOther = ((DenseDComplexMatrix2D)y).elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        double[] tmp1 = new double[2];
                        double[] tmp2 = new double[2];
                        if (function == DComplexFunctions.mult) {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp1[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseDComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else if (function == DComplexFunctions.multConjFirst) {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp1[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseDComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else if (function == DComplexFunctions.multConjSecond) {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp1[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseDComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        } else {
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                int j = idxOther;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    tmp1[0] = DenseDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    tmp1 = function.apply(tmp1, tmp2);
                                    DenseDComplexMatrix2D.this.elements[i] = tmp1[0];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = tmp1[1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] tmp1 = new double[2];
            double[] tmp2 = new double[2];
            int idx = zero;
            int idxOther = zeroOther;
            if (function == DComplexFunctions.mult) {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else if (function == DComplexFunctions.multConjFirst) {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else if (function == DComplexFunctions.multConjSecond) {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            } else {
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    int j = idxOther;
                    for (int c = 0; c < this.columns; ++c) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        tmp1 = function.apply(tmp1, tmp2);
                        this.elements[i] = tmp1[0];
                        this.elements[i + 1] = tmp1[1];
                        i += this.columnStride;
                        j += columnStrideOther;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double re, final double im) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                DenseDComplexMatrix2D.this.elements[i] = re;
                                DenseDComplexMatrix2D.this.elements[i + 1] = im;
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = re;
                    this.elements[i + 1] = im;
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idxOther = firstRow * DenseDComplexMatrix2D.this.columns * 2;
                            int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                int i = idx;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    DenseDComplexMatrix2D.this.elements[i] = values[idxOther++];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = values[idxOther++];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = values[idxOther++];
                        this.elements[i + 1] = values[idxOther++];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = 2 * DenseDComplexMatrix2D.this.columns;
                            int i = firstRow * DenseDComplexMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                double[] currentRow = values[r];
                                if (currentRow.length != idx) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + idx);
                                }
                                System.arraycopy(currentRow, 0, DenseDComplexMatrix2D.this.elements, i, idx);
                                i += idx;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = 2 * this.columns;
                int i = 0;
                for (int r = 0; r < this.rows; ++r) {
                    double[] currentRow = values[r];
                    if (currentRow.length != idx) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + idx);
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, idx);
                    i += idx;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                for (int j = 0; j < nthreads; ++j) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                            for (int r = firstRow; r < lastRow; ++r) {
                                double[] currentRow = values[r];
                                if (currentRow.length != 2 * DenseDComplexMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * DenseDComplexMatrix2D.this.columns());
                                }
                                int i = idx;
                                for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                    DenseDComplexMatrix2D.this.elements[i] = currentRow[2 * c];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = currentRow[2 * c + 1];
                                    i += DenseDComplexMatrix2D.this.columnStride;
                                }
                                idx += DenseDComplexMatrix2D.this.rowStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                for (int r = 0; r < this.rows; ++r) {
                    double[] currentRow = values[r];
                    if (currentRow.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * this.columns());
                    }
                    int i = idx;
                    for (int c = 0; c < this.columns; ++c) {
                        this.elements[i] = currentRow[2 * c];
                        this.elements[i + 1] = currentRow[2 * c + 1];
                        i += this.columnStride;
                    }
                    idx += this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final float[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idxOther = firstRow * DenseDComplexMatrix2D.this.columns * 2;
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                DenseDComplexMatrix2D.this.elements[i] = values[idxOther];
                                DenseDComplexMatrix2D.this.elements[i + 1] = values[idxOther + 1];
                                i += DenseDComplexMatrix2D.this.columnStride;
                                idxOther += 2;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = 0;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = values[idxOther];
                    this.elements[i + 1] = values[idxOther + 1];
                    i += this.columnStride;
                    idxOther += 2;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignImaginary(DoubleMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final double[] elemsOther = ((DenseDoubleMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                DenseDComplexMatrix2D.this.elements[i + 1] = elemsOther[j];
                                i += DenseDComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i + 1] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignReal(DoubleMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final double[] elemsOther = ((DenseDoubleMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                DenseDComplexMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseDComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    this.elements[i] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                if (DenseDComplexMatrix2D.this.elements[i] != 0.0 || DenseDComplexMatrix2D.this.elements[i + 1] != 0.0) {
                                    ++cardinality;
                                }
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    if (this.elements[i] != 0.0 || this.elements[i + 1] != 0.0) {
                        ++cardinality;
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return cardinality;
    }

    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexForward(this.elements);
        } else {
            DComplexMatrix2D copy = this.copy();
            this.fft2.complexForward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void fftColumns() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDComplexMatrix1D)DenseDComplexMatrix2D.this.viewColumn(c)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDComplexMatrix1D)this.viewColumn(c)).fft();
            }
        }
    }

    public void fftRows() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDComplexMatrix1D)DenseDComplexMatrix2D.this.viewRow(r)).fft();
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDComplexMatrix1D)this.viewRow(r)).fft();
            }
        }
    }

    @Override
    public DComplexMatrix2D forEachNonZero(final IntIntDComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        double[] value = new double[2];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                value[0] = DenseDComplexMatrix2D.this.elements[i];
                                value[1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                if (value[0] != 0.0 || value[1] != 0.0) {
                                    double[] v = function.apply(r, c, value);
                                    DenseDComplexMatrix2D.this.elements[i] = v[0];
                                    DenseDComplexMatrix2D.this.elements[i + 1] = v[1];
                                }
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            double[] value = new double[2];
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    value[0] = this.elements[i];
                    value[1] = this.elements[i + 1];
                    if (value[0] != 0.0 || value[1] != 0.0) {
                        double[] v = function.apply(r, c, value);
                        this.elements[i] = v[0];
                        this.elements[i + 1] = v[1];
                    }
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D getConjugateTranspose() {
        DComplexMatrix2D transpose = this.viewDice().copy();
        final double[] elemsOther = ((DenseDComplexMatrix2D)transpose).elements;
        final int zeroOther = (int)transpose.index(0, 0);
        final int columnStrideOther = transpose.columnStride();
        final int rowStrideOther = transpose.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int columnsOther = transpose.columns();
        int rowsOther = transpose.rows();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, rowsOther);
            Future[] futures = new Future[nthreads];
            int k = rowsOther / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rowsOther : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < columnsOther; ++c) {
                                elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                                idxOther += columnStrideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = zeroOther;
            for (int r = 0; r < rowsOther; ++r) {
                for (int c = 0; c < columnsOther; ++c) {
                    elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                    idxOther += columnStrideOther;
                }
            }
        }
        return transpose;
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        DenseDoubleMatrix2D Im = new DenseDoubleMatrix2D(this.rows, this.columns);
        final double[] elemsOther = Im.elements();
        final int columnStrideOther = Im.columnStride();
        final int rowStrideOther = Im.rowStride();
        final int zeroOther = (int)Im.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                elemsOther[j] = DenseDComplexMatrix2D.this.elements[i + 1];
                                i += DenseDComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    elemsOther[j] = this.elements[i + 1];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ArrayList<double[]> valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        for (int r = 0; r < this.rows; ++r) {
            int i = idx;
            for (int c = 0; c < this.columns; ++c) {
                double[] value = new double[]{this.elements[i], this.elements[i + 1]};
                if (value[0] != 0.0 || value[1] != 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
            }
            idx += this.rowStride;
        }
    }

    @Override
    public double[] getQuick(int row, int column) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        return new double[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        DenseDoubleMatrix2D R = new DenseDoubleMatrix2D(this.rows, this.columns);
        final double[] elemsOther = R.elements();
        final int columnStrideOther = R.columnStride();
        final int rowStrideOther = R.rowStride();
        final int zeroOther = (int)R.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            int j = idxOther;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                elemsOther[j] = DenseDComplexMatrix2D.this.elements[i];
                                i += DenseDComplexMatrix2D.this.columnStride;
                                j += columnStrideOther;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                int j = idxOther;
                for (int c = 0; c < this.columns; ++c) {
                    elemsOther[j] = this.elements[i];
                    i += this.columnStride;
                    j += columnStrideOther;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
            }
        }
        return R;
    }

    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.complexInverse(this.elements, scale);
        } else {
            DComplexMatrix2D copy = this.copy();
            this.fft2.complexInverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifftColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            ((DenseDComplexMatrix1D)DenseDComplexMatrix2D.this.viewColumn(c)).ifft(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int c = 0; c < this.columns; ++c) {
                ((DenseDComplexMatrix1D)this.viewColumn(c)).ifft(scale);
            }
        }
    }

    public void ifftRows(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int r = firstRow; r < lastRow; ++r) {
                            ((DenseDComplexMatrix1D)DenseDComplexMatrix2D.this.viewRow(r)).ifft(scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int r = 0; r < this.rows; ++r) {
                ((DenseDComplexMatrix1D)this.viewRow(r)).ifft(scale);
            }
        }
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new DenseDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new DenseDComplexMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public double[][] toArray() {
        final double[][] values = new double[this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                values[r][2 * c] = DenseDComplexMatrix2D.this.elements[i];
                                values[r][2 * c + 1] = DenseDComplexMatrix2D.this.elements[i + 1];
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    values[r][2 * c] = this.elements[i];
                    values[r][2 * c + 1] = this.elements[i + 1];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return values;
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D v = new DenseDComplexMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
        final int strideOther = v.stride();
        final double[] elemsOther = (double[])((DComplexMatrix1D)v).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                final int firstIdx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            idx = zero + c * DenseDComplexMatrix2D.this.columnStride;
                            for (int r = 0; r < DenseDComplexMatrix2D.this.rows; ++r) {
                                elemsOther[idxOther] = DenseDComplexMatrix2D.this.elements[idx];
                                elemsOther[idxOther + 1] = DenseDComplexMatrix2D.this.elements[idx + 1];
                                idx += DenseDComplexMatrix2D.this.rowStride;
                                idxOther += strideOther;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int idxOther = zeroOther;
            for (int c = 0; c < this.columns; ++c) {
                idx = zero + c * this.columnStride;
                for (int r = 0; r < this.rows; ++r) {
                    elemsOther[idxOther] = this.elements[idx];
                    elemsOther[idxOther + 1] = this.elements[idx + 1];
                    idx += this.rowStride;
                    idxOther += strideOther;
                }
            }
        }
        return v;
    }

    @Override
    public DComplexMatrix1D zMult(DComplexMatrix1D y, DComplexMatrix1D z, final double[] alpha, final double[] beta, boolean transposeA) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(y, z, alpha, beta, false);
        }
        DComplexMatrix1D zz = z == null ? new DenseDComplexMatrix1D(this.rows) : z;
        if ((long)this.columns != y.size() || (long)this.rows > zz.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + zz.toStringShort());
        }
        final double[] elemsY = (double[])y.elements();
        final double[] elemsZ = (double[])zz.elements();
        if (this.elements == null || elemsY == null || elemsZ == null) {
            throw new InternalError();
        }
        final int strideY = y.stride();
        final int strideZ = zz.stride();
        final int zero = (int)this.index(0, 0);
        final int zeroY = (int)y.index(0);
        final int zeroZ = (int)zz.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int idxZero = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        int idxZeroZ = zeroZ + firstRow * strideZ;
                        for (int r = firstRow; r < lastRow; ++r) {
                            double reS = 0.0;
                            double imS = 0.0;
                            int idx = idxZero;
                            int idxY = zeroY;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                double reA = DenseDComplexMatrix2D.this.elements[idx];
                                double imA = DenseDComplexMatrix2D.this.elements[idx + 1];
                                double reY = elemsY[idxY];
                                double imY = elemsY[idxY + 1];
                                reS += reA * reY - imA * imY;
                                imS += imA * reY + reA * imY;
                                idx += DenseDComplexMatrix2D.this.columnStride;
                                idxY += strideY;
                            }
                            double reZ = elemsZ[idxZeroZ];
                            double imZ = elemsZ[idxZeroZ + 1];
                            elemsZ[idxZeroZ] = reS * alpha[0] - imS * alpha[1] + reZ * beta[0] - imZ * beta[1];
                            elemsZ[idxZeroZ + 1] = imS * alpha[0] + reS * alpha[1] + imZ * beta[0] + reZ * beta[1];
                            idxZero += DenseDComplexMatrix2D.this.rowStride;
                            idxZeroZ += strideZ;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxZero = zero;
            int idxZeroZ = zeroZ;
            for (int r = 0; r < this.rows; ++r) {
                double reS = 0.0;
                double imS = 0.0;
                int idx = idxZero;
                int idxY = zeroY;
                for (int c = 0; c < this.columns; ++c) {
                    double reA = this.elements[idx];
                    double imA = this.elements[idx + 1];
                    double reY = elemsY[idxY];
                    double imY = elemsY[idxY + 1];
                    reS += reA * reY - imA * imY;
                    imS += imA * reY + reA * imY;
                    idx += this.columnStride;
                    idxY += strideY;
                }
                double reZ = elemsZ[idxZeroZ];
                double imZ = elemsZ[idxZeroZ + 1];
                elemsZ[idxZeroZ] = reS * alpha[0] - imS * alpha[1] + reZ * beta[0] - imZ * beta[1];
                elemsZ[idxZeroZ + 1] = imS * alpha[0] + reS * alpha[1] + imZ * beta[0] + reZ * beta[1];
                idxZero += this.rowStride;
                idxZeroZ += strideZ;
            }
        }
        return zz;
    }

    @Override
    public DComplexMatrix2D zMult(DComplexMatrix2D B, DComplexMatrix2D C, final double[] alpha, final double[] beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseDComplexMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSeq(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            DComplexMatrix2D CC;
            DComplexMatrix2D BB;
            DComplexMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    ((DenseDComplexMatrix2D)AA).zMultSeq(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    protected DComplexMatrix2D zMultSeq(DComplexMatrix2D B, DComplexMatrix2D C, double[] alpha, double[] beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseDComplexMatrix2D(m, p);
        }
        if (!(C instanceof DenseDComplexMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseDComplexMatrix2D BB = (DenseDComplexMatrix2D)B;
        DenseDComplexMatrix2D CC = (DenseDComplexMatrix2D)C;
        double[] AElems = this.elements;
        double[] BElems = BB.elements;
        double[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - n) / (n + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = m / m_optimal;
        int rr = 0;
        if (m % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += m - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    double imB;
                    double reB;
                    double imA;
                    double reA;
                    int kA = iA;
                    int kB = jB;
                    double reS = 0.0;
                    double imS = 0.0;
                    kA -= cA;
                    kB -= rB;
                    int k = n % 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    k = n / 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    double reC = CElems[iC];
                    double imC = CElems[iC + 1];
                    CElems[iC] = alpha[0] * reS - alpha[1] * imS + beta[0] * reC - beta[1] * imC;
                    CElems[iC + 1] = alpha[1] * reS + alpha[0] * imS + beta[1] * reC + beta[0] * imC;
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    public double[] zSum() {
        double[] sum = new double[2];
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        int idx = zero + firstRow * DenseDComplexMatrix2D.this.rowStride;
                        for (int r = firstRow; r < lastRow; ++r) {
                            int i = idx;
                            for (int c = 0; c < DenseDComplexMatrix2D.this.columns; ++c) {
                                sum[0] = sum[0] + DenseDComplexMatrix2D.this.elements[i];
                                sum[1] = sum[1] + DenseDComplexMatrix2D.this.elements[i + 1];
                                i += DenseDComplexMatrix2D.this.columnStride;
                            }
                            idx += DenseDComplexMatrix2D.this.rowStride;
                        }
                        return sum;
                    }
                });
            }
            try {
                for (int j = 0; j < nthreads; ++j) {
                    double[] tmp = (double[])futures[j].get();
                    sum[0] = sum[0] + tmp[0];
                    sum[1] = sum[1] + tmp[1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            for (int r = 0; r < this.rows; ++r) {
                int i = idx;
                for (int c = 0; c < this.columns; ++c) {
                    sum[0] = sum[0] + this.elements[i];
                    sum[1] = sum[1] + this.elements[i + 1];
                    i += this.columnStride;
                }
                idx += this.rowStride;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D other) {
        if (other instanceof SelectedDenseDComplexMatrix2D) {
            SelectedDenseDComplexMatrix2D otherMatrix = (SelectedDenseDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDComplexMatrix2D) {
            DenseDComplexMatrix2D otherMatrix = (DenseDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    protected DComplexMatrix1D like1D(int size, int zero, int stride) {
        return new DenseDComplexMatrix1D(size, this.elements, zero, stride, false);
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDComplexMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

